/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans.tasks;

import com.sun.portal.admin.common.BackupVersion;
import com.sun.portal.desktop.admin.mbeans.tasks.DPAException;
import com.sun.portal.desktop.admin.mbeans.tasks.DPAUtil;
import com.sun.portal.desktop.admin.mbeans.tasks.DPHelper;
import com.sun.portal.desktop.admin.mbeans.tasks.DesktopDataException;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.deployment.DPBasedPPCtx;
import com.sun.portal.desktop.deployment.ExtractOp;
import com.sun.portal.desktop.deployment.Par;
import com.sun.portal.desktop.deployment.ParFileBuilder;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.log.common.PortalLogManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.DTDResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CreatePAR {
    public static final String DP_MAPPING = "DPMapping.properties";
    public static final String TEMPLATE_BASE_DIR_PROP = "templateBaseDir";
    public static final String COMMUNITY_TEMPLATE_BASE_DIR_PROP = "communityTemplateBaseDir";
    public static final String UTF8 = "UTF-8";
    public static final String GLOBAL_KEY = "global";
    public static final String DESKTOP = "desktop";
    public static final String MERGED_ORDER = "mergedOrder";
    public static final String FS = File.separator;
    private static Logger m_Logger = null;
    private String m_DPNode = null;
    private Properties m_DPProps = null;
    private File m_DPRootDir = null;
    static /* synthetic */ Class class$com$sun$portal$desktop$admin$mbeans$tasks$CreatePAR;

    public CreatePAR() {
        PortalLogManager manager = new PortalLogManager();
        manager.init("debug.com.sun.portal");
        m_Logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$admin$mbeans$tasks$CreatePAR == null ? (class$com$sun$portal$desktop$admin$mbeans$tasks$CreatePAR = CreatePAR.class$("com.sun.portal.desktop.admin.mbeans.tasks.CreatePAR")) : class$com$sun$portal$desktop$admin$mbeans$tasks$CreatePAR));
    }

    public void parFromDir(String path, String parFileName) throws Exception, Throwable {
        File f;
        if (path.endsWith(FS)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((f = new File(parFileName)).exists()) {
            m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0098");
            f.delete();
        }
        try {
            Object[] tokens;
            DPBasedPPCtx ppctx = new DPBasedPPCtx(null, null);
            HashMap<String, Document> parDocs = new HashMap<String, Document>();
            HashMap dpMappings = new HashMap();
            Properties dtProps = new Properties();
            String templateBaseDirPath = path + FS + "pbfiles" + FS + TEMPLATE_BASE_DIR_PROP;
            dtProps.setProperty(TEMPLATE_BASE_DIR_PROP, templateBaseDirPath);
            String communityTemplateBaseDirPath = path + FS + "pbfiles" + FS + COMMUNITY_TEMPLATE_BASE_DIR_PROP;
            dtProps.setProperty(COMMUNITY_TEMPLATE_BASE_DIR_PROP, communityTemplateBaseDirPath);
            ppctx.setDTProps(dtProps);
            boolean dpExists = this.setupDPAndProp(path);
            Map docs = null;
            if (dpExists) {
                docs = this.getDPDocObjectMap(path, dpMappings);
                if (this.m_DPNode == null) {
                    this.m_DPNode = "";
                }
            }
            Set keys = null;
            if (docs != null && !docs.isEmpty()) {
                keys = docs.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    Element e;
                    String key = (String)i.next();
                    Document parEntry = Par.makeParEntry(key, null, e = (Element)docs.get(key));
                    if (parEntry == null) continue;
                    tokens = new Object[]{key};
                    m_Logger.log(Level.INFO, "PSDT_CSPDAMT0099", tokens);
                    if (key.equals(GLOBAL_KEY)) {
                        parDocs.put(GLOBAL_KEY, parEntry);
                        continue;
                    }
                    parDocs.put(URLEncoder.encode(key, UTF8), parEntry);
                }
            }
            Map properties = dpExists ? this.getPropertyObjectMap(path, dpMappings) : null;
            ExtractOp op = dpMappings.isEmpty() ? null : ExtractOp.makeOpWithDPMapping(this.m_DPNode, dpMappings);
            Vector files = new Vector();
            m_Logger.log(Level.INFO, "PSDT_CSPDAMT0100");
            ppctx.addDirectory(TEMPLATE_BASE_DIR_PROP, null, true, false, null, 3, null, files);
            m_Logger.log(Level.INFO, "PSDT_CSPDAMT0116");
            ppctx.addDirectory(COMMUNITY_TEMPLATE_BASE_DIR_PROP, null, true, true, null, 3, null, files);
            String webSrcPath = path + FS + "static" + FS + "web-src";
            System.setProperty("ps.staticDir", webSrcPath);
            if (m_Logger.isLoggable(Level.INFO)) {
                tokens = new Object[]{webSrcPath};
                m_Logger.log(Level.INFO, "PSDT_CSPDAMT0101", tokens);
            }
            ppctx.addDirectory(null, null, true, true, null, 3, null, files);
            String warDir = path + FS + "war";
            System.setProperty("ps.warDir", warDir);
            if (m_Logger.isLoggable(Level.INFO)) {
                Object[] tokens2 = new Object[]{warDir};
                m_Logger.log(Level.INFO, "PSDT_CSPDAMT0102", tokens2);
            }
            ppctx.addDirectory("ps.warDir", null, false, true, null, 3, null, files);
            String backupVersion = BackupVersion.generateBackupVersion((String)"---", (String)"---", (String)DESKTOP);
            if (m_Logger.isLoggable(Level.INFO)) {
                Object[] tokens3 = new Object[]{parFileName};
                m_Logger.log(Level.INFO, "PSDT_CSPDAMT0103", tokens3);
            }
            ParFileBuilder pfb = new ParFileBuilder(true, m_Logger, backupVersion);
            pfb.addDPEntry(GLOBAL_KEY, parDocs, files, properties, op);
            pfb.makeParFile(parFileName);
        }
        catch (Exception e) {
            m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0104", e);
            throw e;
        }
        catch (Throwable t) {
            m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0104", t);
            throw t;
        }
        m_Logger.log(Level.INFO, "PSDT_CSPDAMT0105");
    }

    private Properties getProp(String name) throws DesktopDataException {
        Properties prop = new Properties();
        try {
            FileInputStream is = new FileInputStream(name);
            prop.load(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fne) {
            m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0106", fne);
            throw new DesktopDataException(fne.getMessage(), fne);
        }
        catch (Exception se) {
            m_Logger.log(Level.SEVERE, "PSDT_CSPDAMT0073", se);
            throw new DesktopDataException(se.getMessage(), se);
        }
        return prop;
    }

    private boolean setupDPAndProp(String path) {
        String dpDir = path + FS + "dp";
        String mapFileName = dpDir + FS + DP_MAPPING;
        try {
            if (this.m_DPRootDir == null) {
                this.m_DPRootDir = new File(dpDir);
            }
            if (!this.m_DPRootDir.exists()) {
                Object[] tokens = new Object[]{dpDir};
                m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0107", tokens);
                m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0108");
                return false;
            }
            if (this.m_DPProps == null) {
                this.m_DPProps = this.getProp(mapFileName);
            }
        }
        catch (DesktopDataException de) {
            m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0072", de);
            m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0109");
            return false;
        }
        this.m_DPNode = (String)this.m_DPProps.get("dpnode");
        return true;
    }

    private void validateMappingFile(String ext) throws DesktopDataException {
        Set<Object> keys = this.m_DPProps.keySet();
        File[] children = this.m_DPRootDir.listFiles();
        for (int i = 0; i < children.length; ++i) {
            String name = children[i].getName();
            boolean found = false;
            Iterator<Object> it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.equals("dpnode") || !name.endsWith(ext) || !name.startsWith(key)) continue;
                found = true;
                break;
            }
            if (name.equals(DP_MAPPING) || !name.endsWith(ext) || found) continue;
            name = name.substring(0, name.indexOf(ext));
            throw new DesktopDataException("CreatePAR.validateMappingFile(), entry is not found in the mapping file: " + name);
        }
    }

    private Map getDPDocObjectMap(String path, Map dpMappings) throws DesktopDataException {
        HashMap<String, Element> docs = new HashMap<String, Element>();
        String dpDir = path + FS + "dp";
        this.validateMappingFile(".xml");
        Set<Object> keys = this.m_DPProps.keySet();
        File[] children = this.m_DPRootDir.listFiles();
        Iterator<Object> it = keys.iterator();
        while (it.hasNext()) {
            XMLDPRoot dpr;
            HashSet<String> dps = new HashSet<String>();
            Object subName = null;
            String key = (String)it.next();
            String val = this.m_DPProps.getProperty(key);
            if (m_Logger.isLoggable(Level.FINER)) {
                Object[] tokens = new Object[]{key};
                m_Logger.log(Level.FINER, "PSDT_CSPDAMT0110", tokens);
            }
            if (key.equals("dpnode")) continue;
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                String name = child.getName();
                if (!name.endsWith(".xml") || !name.startsWith(key)) continue;
                dps.add(name);
                if (!m_Logger.isLoggable(Level.FINER)) continue;
                Object[] tokens = new Object[]{name};
                m_Logger.log(Level.FINER, "PSDT_CSPDAMT0111", tokens);
            }
            if (dps.size() == 1) {
                Object[] array = new Object[1];
                dps.toArray(array);
                Document doc = this.getDocument(dpDir + FS + array[0]);
                docs.put(key, doc.getDocumentElement());
                dpMappings.put(key, val);
                continue;
            }
            if (dps.size() <= 0) continue;
            String mergedOrder = (String)this.m_DPProps.get("mergedOrder-" + key);
            m_Logger.log(Level.FINER, "PSDT_CSPDAMT0115", mergedOrder);
            StringTokenizer st = mergedOrder == null ? null : new StringTokenizer(mergedOrder, ",");
            LinkedHashSet<String> ls = new LinkedHashSet<String>();
            if (st != null) {
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (!dps.contains(token)) continue;
                    ls.add(token);
                    dps.remove(token);
                }
                if (!dps.isEmpty()) {
                    ls.addAll(dps);
                }
            } else {
                ls.addAll(dps);
            }
            if ((dpr = this.combineDP(dpDir, ls)) == null) continue;
            docs.put(key, dpr.getElement());
            dpMappings.put(key, val);
        }
        return docs;
    }

    private Map getPropertyObjectMap(String path, Map dpMappings) throws DesktopDataException {
        HashMap<String, Properties> propMap = new HashMap<String, Properties>();
        String dpDir = path + FS + "dp";
        this.validateMappingFile(".properties");
        Set<Object> keys = this.m_DPProps.keySet();
        Set mappingKeys = dpMappings.keySet();
        File[] children = this.m_DPRootDir.listFiles();
        Iterator<Object> it = keys.iterator();
        block0: while (it.hasNext()) {
            String key = (String)it.next();
            if (m_Logger.isLoggable(Level.FINER)) {
                Object[] tokens = new Object[]{key};
                m_Logger.log(Level.FINER, "PSDT_CSPDAMT0110", tokens);
            }
            if (key.equals("dpnode")) continue;
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                String name = child.getName();
                Properties props = null;
                if (!name.endsWith(".properties") || name.equals(DP_MAPPING) || !name.startsWith(key)) continue;
                if (!mappingKeys.contains(key)) {
                    dpMappings.put(key, (String)this.m_DPProps.get(key));
                }
                props = this.getProp(dpDir + FS + key + ".properties");
                propMap.put(key, props);
                if (!m_Logger.isLoggable(Level.FINER)) continue block0;
                Object[] tokens = new Object[]{dpDir + FS + name};
                m_Logger.log(Level.FINER, "PSDT_CSPDAMT0112", tokens);
                continue block0;
            }
        }
        return propMap;
    }

    private XMLDPRoot combineDP(String rootPath, Set dps) throws DesktopDataException {
        Iterator i = dps.iterator();
        String next = null;
        XMLDPRoot rootDpr = null;
        XMLDPRoot dpr = null;
        XMLDPFactory dpf = XMLDPFactory.getInstance();
        DSAMEAdminDPContext dc = new DSAMEAdminDPContext();
        Object doc = null;
        String dp = null;
        try {
            while (dp == null) {
                Object[] tokens;
                if (!i.hasNext()) continue;
                String first = (String)i.next();
                if (m_Logger.isLoggable(Level.FINER)) {
                    tokens = new Object[]{rootPath + FS + first};
                    m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0113", tokens);
                }
                if ((dp = DPHelper.generateDPDocument(this.getDocument(rootPath + FS + first))) == null) {
                    if (!m_Logger.isLoggable(Level.WARNING)) continue;
                    tokens = new Object[]{first};
                    m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0114", tokens);
                    continue;
                }
                rootDpr = (XMLDPRoot)dpf.createRoot((DPContext)dc, dp);
                break;
            }
            while (i.hasNext()) {
                Object[] tokens;
                next = (String)i.next();
                if (m_Logger.isLoggable(Level.FINER)) {
                    tokens = new Object[]{rootPath + FS + next};
                    m_Logger.log(Level.FINEST, "PSDT_CSPDAMT0113", tokens);
                }
                if ((dp = DPHelper.generateDPDocument(this.getDocument(rootPath + FS + next))) == null) {
                    if (!m_Logger.isLoggable(Level.WARNING)) continue;
                    tokens = new Object[]{next};
                    m_Logger.log(Level.WARNING, "PSDT_CSPDAMT0114", tokens);
                    continue;
                }
                dpr = (XMLDPRoot)dpf.createRoot((DPContext)dc, dp);
                DPAUtil.combineRoots(rootDpr, dpr);
            }
        }
        catch (DPAException de) {
            throw new DesktopDataException("CreatePAR.combineDP()", de);
        }
        if (rootDpr.isDirty()) {
            rootDpr.setDirty(false);
        }
        return rootDpr;
    }

    private Document getDocument(String xmlFilePath) throws DesktopDataException {
        Document d = null;
        try {
            FileInputStream fi = new FileInputStream(new File(xmlFilePath));
            byte[] bytes = new byte[fi.available()];
            fi.read(bytes);
            fi.close();
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            InputSource is = new InputSource(bi);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            DTDResolver dtdReso = new DTDResolver();
            db.setEntityResolver((EntityResolver)dtdReso);
            db.setErrorHandler((ErrorHandler)dtdReso);
            d = db.parse(is);
        }
        catch (SAXParseException spe) {
            throw new DesktopDataException("desktopData.getDocument(): line=" + spe.getLineNumber() + ".  ", spe);
        }
        catch (SAXException se) {
            throw new DesktopDataException("desktopData.getDocment(): ", se);
        }
        catch (ParserConfigurationException pce) {
            throw new DesktopDataException("desktopData.getDocment(): ", pce);
        }
        catch (IOException ioe) {
            throw new DesktopDataException("desktopData.getDocment(): ", ioe);
        }
        return d;
    }

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            try {
                CreatePAR cp = new CreatePAR();
                cp.parFromDir(args[0], args[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(-1);
            }
        } else {
            System.out.println("Error: Insufficient arguments");
            System.exit(-1);
        }
        System.out.println("Create par completed!");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

