/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.desktop.admin.mbeans.DisplayProfileMBean;
import com.sun.portal.desktop.admin.mbeans.tasks.DPHelper;
import com.sun.portal.desktop.admin.mbeans.tasks.DPTreeHelper;
import com.sun.portal.desktop.admin.mbeans.tasks.DesktopDataException;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.taskadmin.ChannelTaskAdmin;
import com.sun.portal.taskadmin.TaskAdminException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DisplayProfile
extends PSResource
implements DisplayProfileMBean {
    private String psPortalID;
    private PSConfigContext cc;
    private PortalDomainContext pdc;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$admin$mbeans$DisplayProfile == null ? (class$com$sun$portal$desktop$admin$mbeans$DisplayProfile = DisplayProfile.class$("com.sun.portal.desktop.admin.mbeans.DisplayProfile")) : class$com$sun$portal$desktop$admin$mbeans$DisplayProfile));
    private static final String MSG_PREFIX = "desktop.";
    private static final String PROPERTY_TOP_LEVEL_CONTAINER = "isTopLevel";
    static /* synthetic */ Class class$com$sun$portal$desktop$admin$mbeans$DisplayProfile;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.cc = cc;
        this.psPortalID = (String)path.get(1);
    }

    public void createChannel(String baseDN, String channelName, String providerName) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.createChannel(channelName, providerName);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        catch (DPError e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0012", e);
            throw new PSMBeanException("desktop.message.create.channel.dperror", e.getMessage());
        }
    }

    public void createContainer(String baseDN, String channelName, String providerName) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.createContainer(channelName, providerName);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        catch (DPError e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0012", e);
            throw new PSMBeanException("desktop.message.create.container.dperror", e.getMessage());
        }
    }

    public void createTab(String baseDN, String channelName, String providerName, String parentContainer, Map tabProps) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            if (parentContainer != null) {
                String cName = parentContainer + "/" + channelName;
                String title = (String)tabProps.get("title");
                String description = (String)tabProps.get("description");
                cta.createContainer(cName, providerName);
                if (title != null && title.length() != 0) {
                    cta.setStringProperty(cName, "title", title, null);
                }
                if (description != null && description.length() != 0) {
                    cta.setStringProperty(cName, "description", description, null);
                }
                List available = cta.getAvailableChannels(parentContainer);
                List selected = cta.getSelectedChannels(parentContainer);
                available.add(cName);
                selected.add(cName);
                cta.setAvailableChannels(available, parentContainer);
                cta.setSelectedChannels(selected, parentContainer);
                Map props = cta.getMapProperty(parentContainer, "TabProperties", null);
                props.put(cName, (Map)tabProps.get("TabProperties"));
                cta.setMapProperty(parentContainer, "TabProperties", props, null);
            }
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public Set getNonExistentContainerAssignableChannels(String baseDN, String parentContainer, String channelName, String providerName) throws PSMBeanException {
        Set channels = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            String cName = null;
            if (parentContainer != null) {
                cName = parentContainer + "/" + channelName;
            }
            cta.createContainer(cName, providerName);
            channels = cta.getAssignableChannels(cName);
            cta.deleteChannel(channelName, parentContainer);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return channels;
    }

    public void deleteChannel(String baseDN, String channelName, String parentcontainer) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            cta.deleteChannel(channelName, parentcontainer);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        catch (DPError e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0012", e);
            throw new PSMBeanException("desktop.message.delete.channel.dperror", e.getMessage());
        }
    }

    public Set getExistingChannels(String baseDN, Boolean all) throws PSMBeanException {
        Set channels = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            channels = cta.getExistingChannels(all);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        catch (DPError e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0012", e);
            throw new PSMBeanException("desktop.message.get.existing.channels.dperror", e.getMessage());
        }
        return channels;
    }

    public Set getExistingContainers(String baseDN, Boolean all) throws PSMBeanException {
        Set containers = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            containers = cta.getExistingContainers(all);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        catch (DPError e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0012", e);
            throw new PSMBeanException("desktop.message.get.existing.containers.dperror", e.getMessage());
        }
        return containers;
    }

    public Set getExistingTabContainers(String baseDN, Boolean all) throws PSMBeanException {
        HashSet<String> tabContainers = new HashSet<String>();
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            Set containers = cta.getExistingContainers(all);
            Iterator i = containers.iterator();
            while (i.hasNext()) {
                String container = (String)i.next();
                if (!cta.isTabContainer(container)) continue;
                tabContainers.add(container);
            }
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        catch (DPError e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0012", e);
            throw new PSMBeanException("desktop.message.get.existing.tabcontainers.dperror", e.getMessage());
        }
        return tabContainers;
    }

    public Set getExistingProviders(String baseDN) throws PSMBeanException {
        Set providers = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            providers = cta.getExistingProviders();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return providers;
    }

    public Set getExistingContainerProviders(String baseDN) throws PSMBeanException {
        Set providers = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            providers = cta.getExistingContainerProviders();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return providers;
    }

    public Set getAssignableChannels(String baseDN, String container) throws PSMBeanException {
        Set channels = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            channels = cta.getAssignableChannels(container);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return channels;
    }

    public List getAvailableChannels(String baseDN, String containerName) throws PSMBeanException {
        List channels = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            channels = cta.getAvailableChannels(containerName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return channels;
    }

    public List getSelectedChannels(String baseDN, String containerName) throws PSMBeanException {
        List channels = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            channels = cta.getSelectedChannels(containerName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return channels;
    }

    public void setAvailableChannels(String baseDN, List available, String containerName) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setAvailableChannels(available, containerName);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public void setSelectedChannels(String baseDN, List selected, String containerName) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setSelectedChannels(selected, containerName);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public String getStringProperty(String baseDN, String channelName, String key, List pflist) throws PSMBeanException {
        String value = null;
        ChannelTaskAdmin cta = null;
        try {
            cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            value = cta.getStringProperty(channelName, key, pflist);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return value;
    }

    public Integer getIntegerProperty(String baseDN, String channelName, String key, List pflist) throws PSMBeanException {
        int value;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            value = cta.getIntegerProperty(channelName, key, pflist);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return new Integer(value);
    }

    public Boolean getBooleanProperty(String baseDN, String channelName, String key, List pflist) throws PSMBeanException {
        boolean value;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            value = cta.getBooleanProperty(channelName, key, pflist);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return new Boolean(value);
    }

    public Map getMapProperty(String baseDN, String channelName, String key, List pflist) throws PSMBeanException {
        Map value = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            value = cta.getMapProperty(channelName, key, pflist);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return value;
    }

    public List getListProperty(String baseDN, String channelName, String key, List pflist) throws PSMBeanException {
        List value = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            value = cta.getListProperty(channelName, key, pflist);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return value;
    }

    public void setStringProperty(String baseDN, String channelName, String key, String value, List pflist) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setStringProperty(channelName, key, value, pflist);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public void setIntegerProperty(String baseDN, String channelName, String key, Integer value, List pflist) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setIntegerProperty(channelName, key, value, pflist);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public void setBooleanProperty(String baseDN, String channelName, String key, Boolean value, List pflist) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setBooleanProperty(channelName, key, value, pflist);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public void setMapProperty(String baseDN, String channelName, String key, Map value, List pflist) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setMapProperty(channelName, key, value, pflist);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public void setListProperty(String baseDN, String channelName, String key, List value, List pflist) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setListProperty(channelName, key, value, pflist);
            cta.store();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public Object[] getVisualHierarchy(String baseDN, String rootContainer) throws PSMBeanException {
        Object[] tree = null;
        try {
            DPTreeHelper dth = new DPTreeHelper(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            dth.setLogger(logger);
            tree = dth.getVisualTree(rootContainer);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "Error Getting Visual Hierarcy", tae);
            throw new PSMBeanException("Error Getting Visual Hierarcy");
        }
        return tree;
    }

    public Set getTopLevelChannels(String baseDN) throws PSMBeanException {
        TreeSet<String> topLevelChannels = new TreeSet<String>();
        boolean isTopLevelContainerValue = false;
        ChannelTaskAdmin cta = null;
        try {
            cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            Set containers = cta.getExistingContainers(true);
            Iterator iterator = containers.iterator();
            while (iterator.hasNext()) {
                String containerName = (String)iterator.next();
                try {
                    isTopLevelContainerValue = false;
                    isTopLevelContainerValue = cta.getBooleanProperty(containerName, PROPERTY_TOP_LEVEL_CONTAINER, null);
                    if (!isTopLevelContainerValue) continue;
                    topLevelChannels.add(containerName);
                }
                catch (TaskAdminException tae) {}
            }
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
        }
        return topLevelChannels;
    }

    public Object[] getPhysicalHierarchy(String baseDN) throws PSMBeanException {
        Object[] tree = null;
        try {
            DPTreeHelper dth = new DPTreeHelper(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            dth.setLogger(logger);
            tree = dth.getPhysicalTree();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "Error Getting Visual Hierarcy", tae);
            throw new PSMBeanException("Error Getting Visual Hierarcy");
        }
        return tree;
    }

    public Map getNodeProperties(String fqcn, String rpn, String dn, String client, String locale) throws PSMBeanException {
        Map map = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), dn, this.psPortalID);
            map = cta.getNodeProperties(fqcn, rpn, client, locale);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "Error getting properties for " + fqcn + " at " + dn, tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), this.getStackTrace(tae), tae.getTokens());
        }
        catch (Error dpe) {
            logger.log(Level.SEVERE, "Error getting properties for " + fqcn + " at " + dn, dpe);
            throw new PSMBeanException("", this.getStackTrace(dpe));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error getting properties for " + fqcn + " at " + dn, e);
            throw new PSMBeanException("", this.getStackTrace(e));
        }
        return map;
    }

    public void setNodeProperties(String fqcn, String rpn, String dn, String client, String locale, Object values) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), dn, this.psPortalID, false);
            cta.setNodeProperties(fqcn, rpn, client, locale, values);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "Error setting properties for " + fqcn + " at " + dn, tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), this.getStackTrace(tae), tae.getTokens());
        }
        catch (Error dpe) {
            logger.log(Level.SEVERE, "Error setting properties for " + fqcn + " at " + dn, dpe);
            throw new PSMBeanException("", this.getStackTrace(dpe));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error setting properties for " + fqcn + " at " + dn, e);
            throw new PSMBeanException("", this.getStackTrace(e));
        }
    }

    public void removeCustomization(String fqcn, String rpn, String dn, String client, String locale, List names) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), dn, this.psPortalID, false, false);
            cta.removeCustomization(fqcn, rpn, client, locale, names);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "Error removing customization for " + fqcn + " at " + dn, tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), this.getStackTrace(tae), tae.getTokens());
        }
        catch (Error dpe) {
            logger.log(Level.SEVERE, "Error removing customization for " + fqcn + " at " + dn, dpe);
            throw new PSMBeanException("", this.getStackTrace(dpe));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error removing customization for " + fqcn + " at " + dn, e);
            throw new PSMBeanException("", this.getStackTrace(e));
        }
    }

    public void createNodeProperty(String fqcn, String rpn, String dn, String client, String locale, String name, Object value, Boolean advanced) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), dn, this.psPortalID, false);
            cta.createNodeProperty(fqcn, rpn, client, locale, name, value, advanced);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "Error creating property " + name + " for " + fqcn + " at " + dn, tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), this.getStackTrace(tae), tae.getTokens());
        }
        catch (Error dpe) {
            logger.log(Level.SEVERE, "Error creating property " + name + " for " + fqcn + " at " + dn, dpe);
            throw new PSMBeanException("", this.getStackTrace(dpe));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating property " + name + " for " + fqcn + " at " + dn, e);
            throw new PSMBeanException("", this.getStackTrace(e));
        }
    }

    public String getDPPriority(String baseDN) throws PSMBeanException {
        String priority = null;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            priority = cta.getDPPriority();
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return priority;
    }

    public void setDPPriority(String baseDN, String priority) throws PSMBeanException {
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID, false);
            cta.setDPPriority(priority);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
    }

    public Boolean isContainer(String baseDN, String channelName) throws PSMBeanException {
        boolean container = false;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            container = cta.isContainer(channelName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), (Throwable)tae);
        }
        return new Boolean(container);
    }

    public Boolean isTabContainer(String baseDN, String channelName) throws PSMBeanException {
        boolean container = false;
        try {
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), baseDN, this.psPortalID);
            container = cta.isTabContainer(channelName);
        }
        catch (TaskAdminException tae) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0008", tae);
            throw new PSMBeanException(MSG_PREFIX + tae.getErrorKey(), tae.getMessage(), tae.getTokens());
        }
        return new Boolean(container);
    }

    public String getDPDocument(String baseDN) throws PSMBeanException {
        String dp = null;
        try {
            DPHelper dpHelper = DPHelper.getDPHelper(this.cc, AdminServerUtil.getSSOToken(), this.psPortalID);
            DPHelper.setLogger(logger);
            dp = dpHelper.getDPDocument(baseDN);
        }
        catch (DesktopDataException de) {
            throw new PSMBeanException("desktop.getDP.DesktopDataException", de.getMessage(), (Throwable)de);
        }
        catch (ContextError ce) {
            throw new PSMBeanException("desktop.getDP.ContextError", ce.getMessage(), (Throwable)ce);
        }
        return dp;
    }

    public void setDPDocument(String baseDN, String dp) throws PSMBeanException {
        try {
            DPHelper dpHelper = DPHelper.getDPHelper(this.cc, AdminServerUtil.getSSOToken(), this.psPortalID);
            DPHelper.setLogger(logger);
            dpHelper.storeDPDocument(baseDN, dp);
        }
        catch (DesktopDataException de) {
            throw new PSMBeanException("desktop.storeDP.DesktopDataException", (Throwable)de);
        }
        catch (ContextError ce) {
            throw new PSMBeanException("desktop.storeDP.ContextError", (Throwable)ce);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

