/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.common.util.UploadDownloadException;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.desktop.admin.mbeans.tasks.DesktopData;
import com.sun.portal.desktop.admin.mbeans.tasks.DesktopDataException;
import com.sun.portal.desktop.deployment.ParFile;
import com.sun.portal.desktop.deployment.ParFileException;
import com.sun.portal.desktop.deployment.ParManifest;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.remote.JMXConnector;

public class DesktopDynamic
extends PSResource
implements DynamicMBean {
    public static final int BUFFER_SIZE = 4096;
    private String dClassName = this.getClass().getName();
    private MBeanInfo dMBeanInfo = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$admin$mbeans$DesktopDynamic == null ? (class$com$sun$portal$desktop$admin$mbeans$DesktopDynamic = DesktopDynamic.class$("com.sun.portal.desktop.admin.mbeans.DesktopDynamic")) : class$com$sun$portal$desktop$admin$mbeans$DesktopDynamic));
    private String domainId;
    private String portalId;
    private PSConfigContext pcc;
    public static final String FS = File.separator;
    static /* synthetic */ Class class$com$sun$portal$desktop$admin$mbeans$DesktopDynamic;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.buildMBeanInfo();
        this.domainId = pdc.getID();
        this.portalId = (String)path.get(1);
        this.pcc = cc;
    }

    public Object getAttribute(String attribute) {
        return null;
    }

    public void setAttribute(Attribute attribute) {
    }

    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    public MBeanInfo getMBeanInfo() {
        return this.dMBeanInfo;
    }

    public Object invoke(String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        block12: {
            if (operationName == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Operation name cannot be null"), "Cannot invoke a null operation in " + this.dClassName);
            }
            try {
                if (operationName.equals("getArchiveFileVersion")) {
                    return this.getArchiveFileVersion((String)params[0]);
                }
                if (operationName.equals("deleteTempFile")) {
                    this.deleteTempFile((String)params[0]);
                    break block12;
                }
                if (operationName.equals("importDesktop")) {
                    this.importDesktop((Boolean)params[0], (Boolean)params[1], (Boolean)params[2], (Boolean)params[3], (Boolean)params[4], (String)params[5], (Boolean)params[6], (String)params[7], (String)params[8]);
                    break block12;
                }
                if (operationName.equals("importProvider")) {
                    this.importProvider((String)params[0], (Boolean)params[1], (Boolean)params[2], (List)params[3], (String)params[4]);
                    break block12;
                }
                if (operationName.equals("lImportProvider")) {
                    this.lImportProvider((String)params[0], (Boolean)params[1], (Boolean)params[2], (String)params[3], (List)params[4], (String)params[5], (Boolean)params[6]);
                    break block12;
                }
                if (operationName.equals("exportDesktop")) {
                    this.exportDesktop((String)params[0], (Boolean)params[1], (Boolean)params[2], (Boolean)params[3], (String)params[4]);
                    break block12;
                }
                if (operationName.equals("exportProvider")) {
                    this.exportProvider((String)params[0], (Boolean)params[1], (String)params[2], (Boolean)params[3], (byte[][])params[4]);
                    break block12;
                }
                if (operationName.equals("lImportDesktop")) {
                    this.lImportDesktop((Boolean)params[0], (Boolean)params[1], (Boolean)params[2], (Boolean)params[3], (Boolean)params[4], (String)params[5], (String)params[6], (Boolean)params[7], (String)params[8], (String)params[9]);
                    break block12;
                }
                if (operationName.equals("listPar")) {
                    return this.listPar((String)params[0], (Boolean)params[1], (Boolean)params[2], (Boolean)params[3], (Boolean)params[4], (Boolean)params[5]);
                }
                throw new ReflectionException(new NoSuchMethodException(operationName), "Cannot find the operation " + operationName + " in " + this.dClassName);
            }
            catch (PSMBeanException pe) {
                throw new MBeanException((Exception)((Object)pe), pe.getMessage());
            }
        }
        return null;
    }

    public String getArchiveFileVersion(String parFileName) throws PSMBeanException {
        String version = null;
        try {
            ParFile par = ParFile.makeParFile(parFileName);
            ParManifest pMan = par.getParManifest();
            version = pMan.getBackupVersion();
            if (logger.isLoggable(Level.INFO)) {
                Object[] tokens = new Object[]{version};
                logger.log(Level.INFO, "PSDT_CSPDAMB0001", tokens);
            }
        }
        catch (ParFileException pe) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0002", pe);
            throw new PSMBeanException("error.archive.file.version", pe.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
            throw new PSMBeanException("error.archive.file.version", e.getMessage());
        }
        return version;
    }

    public void deleteTempFile(String tempFileName) {
        logger.log(Level.INFO, "PSDT_CSPDAMB0011", tempFileName);
        File f = new File(tempFileName);
        if (f.exists()) {
            f.delete();
        }
    }

    public void exportProvider(String parFileName, Boolean verbose, String dn, Boolean global, byte[][] exportfile) throws PSMBeanException {
        try {
            String host = this.getRemoteHost();
            if (host != null) {
                JMXConnector connector = AdminServerUtil.getJMXConnector((String)host);
                MBeanServerConnection mbsc = connector.getMBeanServerConnection();
                String tempName = Integer.toString(new Random().nextInt());
                String tempFileName = this.pcc.getPSDataDir() + FS + "tmp" + FS + tempName;
                Object[] params = new Object[]{tempFileName, verbose, dn, global, exportfile};
                String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "[[B"};
                LinkedList<String> pPath = new LinkedList<String>();
                pPath.addFirst(this.domainId);
                pPath.addFirst(this.portalId);
                pPath.addFirst("DesktopDynamic");
                ObjectName objName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.DesktopDynamic", pPath);
                mbsc.invoke(objName, "exportProvider", params, signature);
                this.downloadFile(mbsc, tempFileName, parFileName);
                connector.close();
            } else {
                DesktopData dd = new DesktopData(AdminServerUtil.getSSOToken(), this.cc, this.pdc.getID(), (String)this.path.get(1), verbose, logger, null);
                dd.exportProvider(parFileName, dn, global, exportfile);
            }
        }
        catch (MalformedObjectNameException me) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", me);
            throw new PSMBeanException("error.execute.export", me.getMessage());
        }
        catch (DesktopDataException ce) {
            String message = ce.getCause() == null ? ce.getMessage() : ce.getCause().getMessage();
            throw new PSMBeanException("error.execute.export", message);
        }
        catch (PSMBeanException me) {
            throw me;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
            throw new PSMBeanException("error.execute.export", e.getMessage());
        }
    }

    public void exportDesktop(String parFileName, Boolean verbose, Boolean fsOnly, Boolean dpOnly, String searchLevel) throws PSMBeanException {
        logger.log(Level.SEVERE, "PSDT_CSPDAMB0001", parFileName);
        try {
            String host = this.getRemoteHost();
            if (host != null) {
                if (logger.isLoggable(Level.INFO)) {
                    Object[] token = new Object[]{host};
                    logger.log(Level.INFO, "PSDT_CSPDAMB0010", token);
                }
                JMXConnector connector = AdminServerUtil.getJMXConnector((String)host);
                MBeanServerConnection mbsc = connector.getMBeanServerConnection();
                String tempName = Integer.toString(new Random().nextInt());
                String tempFileName = this.pcc.getPSDataDir() + FS + "tmp" + FS + tempName;
                Object[] params = new Object[]{tempFileName, verbose, fsOnly, dpOnly, searchLevel};
                String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String"};
                LinkedList<String> pPath = new LinkedList<String>();
                pPath.addFirst(this.domainId);
                pPath.addFirst(this.portalId);
                pPath.addFirst("DesktopDynamic");
                ObjectName objName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.DesktopDynamic", pPath);
                mbsc.invoke(objName, "exportDesktop", params, signature);
                this.downloadFile(mbsc, tempFileName, parFileName);
                params = new Object[]{tempFileName};
                signature = new String[]{"java.lang.String"};
                mbsc.invoke(objName, "deleteTempFile", params, signature);
                connector.close();
            } else {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "PSDT_CSPDAMB0009");
                }
                LinkedList<String> pPath = new LinkedList<String>();
                pPath.addFirst(this.domainId);
                pPath.addFirst(this.portalId);
                String portalUri = this.pdc.getAttributeValue("PortalDomain.Portal", pPath, "PortalWebAppUri");
                DesktopData dd = new DesktopData(AdminServerUtil.getSSOToken(), this.cc, this.pdc.getID(), (String)this.path.get(1), verbose, logger, portalUri);
                dd.exportDesktop(parFileName, null, fsOnly, dpOnly, searchLevel);
            }
        }
        catch (MalformedObjectNameException me) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", me);
            throw new PSMBeanException("error.execute.export", me.getMessage());
        }
        catch (DesktopDataException ce) {
            String message = ce.getCause() == null ? ce.getMessage() : ce.getCause().getMessage();
            throw new PSMBeanException("error.execute.export", message);
        }
        catch (PSMBeanException me) {
            throw me;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
            throw new PSMBeanException("error.execute.export", e.getMessage());
        }
    }

    public void importProvider(String parFileName, Boolean verbose, Boolean overwrite, List operations, String dpnode) throws PSMBeanException {
        Set hosts = this.getHosts();
        Iterator it = hosts.iterator();
        String domainId = this.pdc.getID();
        String portalId = (String)this.path.get(1);
        LinkedList<String> pPath = new LinkedList<String>();
        pPath.addFirst(domainId);
        pPath.addFirst(portalId);
        pPath.addFirst("DesktopDynamic");
        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String", "java.util.List", "java.lang.String", "java.lang.Boolean"};
        ObjectName objName = null;
        try {
            objName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.DesktopDynamic", pPath);
        }
        catch (MalformedObjectNameException me) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", me);
            throw new PSMBeanException("error.execute.import", me.getMessage());
        }
        Boolean extractDP = new Boolean(true);
        while (it.hasNext()) {
            String hostName = (String)it.next();
            try {
                if (AdminServerUtil.isLocal((String)hostName)) {
                    this.lImportProvider(parFileName, verbose, overwrite, portalId, operations, dpnode, extractDP);
                    extractDP = new Boolean(false);
                    continue;
                }
                JMXConnector connector = AdminServerUtil.getJMXConnector((String)hostName);
                MBeanServerConnection mbsc = connector.getMBeanServerConnection();
                String[] dest = this.uploadFile(mbsc, parFileName);
                String destFileName = dest[1];
                Object[] params = new Object[]{destFileName, verbose, overwrite, portalId, operations, dpnode, extractDP};
                mbsc.invoke(objName, "lImportProvider", params, signature);
                extractDP = new Boolean(false);
                try {
                    AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)domainId, (String)dest[0]);
                }
                catch (UploadDownloadException upe) {
                    if (connector != null) {
                        connector.close();
                    }
                    logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", upe);
                    throw new PSMBeanException("error.execute.import", upe.getMessage());
                }
                connector.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
                throw new PSMBeanException("error.execute.import", e.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importDesktop(Boolean verbose, Boolean fsOnly, Boolean dpOnly, Boolean overwrite, Boolean redeploy, String parFileName, Boolean cont, String searchLevel, String dpnode) throws PSMBeanException {
        LinkedList<String> pPath = new LinkedList<String>();
        pPath.addFirst(this.domainId);
        pPath.addFirst(this.portalId);
        pPath.addFirst("DesktopDynamic");
        ObjectName objName = null;
        JMXConnector connector = null;
        try {
            objName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.DesktopDynamic", pPath);
        }
        catch (MalformedObjectNameException me) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", me);
            throw new PSMBeanException("error.execute.import", me.getMessage());
        }
        try {
            Set hosts = this.getHosts();
            Iterator it = hosts.iterator();
            boolean fsOnlyFlag = fsOnly;
            boolean dpOnlyFlag = dpOnly;
            String[] signature = new String[]{"java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{verbose, null, null, overwrite, redeploy, null, this.portalId, cont, searchLevel, dpnode};
            while (it.hasNext()) {
                String hostName = (String)it.next();
                logger.log(Level.INFO, "importDesktop, next host: " + hostName);
                if (AdminServerUtil.isLocal((String)hostName)) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "PSDT_CSPDAMB0009");
                    }
                    this.lImportDesktop(verbose, new Boolean(fsOnlyFlag), new Boolean(dpOnlyFlag), overwrite, redeploy, parFileName, this.portalId, cont, searchLevel, dpnode);
                    if (dpOnlyFlag) return;
                    if (fsOnlyFlag) continue;
                    fsOnlyFlag = true;
                    continue;
                }
                if (logger.isLoggable(Level.INFO)) {
                    Object[] token = new Object[]{hostName};
                    logger.log(Level.INFO, "PSDT_CSPDAMB0010", token);
                }
                try {
                    connector = AdminServerUtil.getJMXConnector((String)hostName);
                    MBeanServerConnection mbsc = connector.getMBeanServerConnection();
                    String[] dest = this.uploadFile(mbsc, parFileName);
                    String destFileName = dest[1];
                    params[1] = new Boolean(fsOnlyFlag);
                    params[2] = new Boolean(dpOnlyFlag);
                    params[5] = destFileName;
                    mbsc.invoke(objName, "lImportDesktop", params, signature);
                    try {
                        AdminClientUtil.uploadDownloadCleanUp((MBeanServerConnection)mbsc, (String)this.domainId, (String)dest[0]);
                    }
                    catch (UploadDownloadException upe) {
                        if (connector != null) {
                            connector.close();
                        }
                        logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", upe);
                        throw new PSMBeanException("error.execute.import", upe.getMessage());
                    }
                    connector.close();
                    if (dpOnlyFlag) return;
                    if (fsOnlyFlag) continue;
                    fsOnlyFlag = true;
                }
                catch (Exception e) {
                    if (connector != null) {
                        connector.close();
                    }
                    logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
                    throw new PSMBeanException("error.execute.import", e.getMessage());
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
            throw new PSMBeanException("error.execute.import", e.getMessage());
        }
    }

    public void lImportProvider(String parFileName, Boolean verbose, Boolean overwrite, String portalId, List operations, String dpnode, Boolean extractDP) throws PSMBeanException {
        try {
            DesktopData dd = new DesktopData(AdminServerUtil.getSSOToken(), this.cc, this.pdc.getID(), portalId, verbose, logger, null);
            dd.importProvider(parFileName, operations, overwrite, dpnode, extractDP);
        }
        catch (DesktopDataException de) {
            String message = de.getCause() == null ? de.getMessage() : de.getCause().getMessage();
            throw new PSMBeanException("error.execute.import", message);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
            throw new PSMBeanException("error.execute.import", e.getMessage());
        }
    }

    public void lImportDesktop(Boolean verbose, Boolean fsOnly, Boolean dpOnly, Boolean overwrite, Boolean redeploy, String parFileName, String portalId, Boolean cont, String searchLevel, String dpnode) throws PSMBeanException {
        try {
            DesktopData dd = new DesktopData(AdminServerUtil.getSSOToken(), this.cc, this.pdc.getID(), portalId, verbose, logger, null);
            dd.importDesktop(parFileName, fsOnly, dpOnly, cont, searchLevel, overwrite, dpnode);
            if (redeploy.booleanValue()) {
                this.createPortalWebApp();
            }
        }
        catch (DesktopDataException de) {
            String message = de.getCause() == null ? de.getMessage() : de.getCause().getMessage();
            throw new PSMBeanException("error.execute.import", message);
        }
        catch (PSMBeanException pe) {
            throw pe;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
            throw new PSMBeanException("error.execute.import", e.getMessage());
        }
    }

    public String listPar(String parFileName, Boolean verbose, Boolean dpOnly, Boolean pbfilesOnly, Boolean warOnly, Boolean staticOnly) throws PSMBeanException {
        String parDescription = null;
        HashMap<Integer, Boolean> types = new HashMap<Integer, Boolean>();
        try {
            ParFile pf = ParFile.makeParFile(parFileName);
            ParManifest pMan = pf.getParManifest();
            if (!(dpOnly.booleanValue() || pbfilesOnly.booleanValue() || warOnly.booleanValue() || staticOnly.booleanValue())) {
                parDescription = pMan.describeAll(pf);
            } else {
                types.put(new Integer(2), dpOnly);
                types.put(new Integer(3), pbfilesOnly);
                types.put(new Integer(5), warOnly);
                types.put(new Integer(4), staticOnly);
                parDescription = pMan.describeAll(pf, types);
            }
        }
        catch (ParFileException e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0002", e);
            throw new PSMBeanException("error.list.par", "DesktopDynamic.listPar");
        }
        return parDescription;
    }

    private Set getHosts() throws PSMBeanException {
        TreeSet<String> hosts = new TreeSet<String>();
        LinkedList<String> pPath = new LinkedList<String>();
        pPath.addFirst(this.pdc.getID());
        pPath.addFirst((String)this.path.get(1));
        try {
            Set instances = this.pdc.getResourceIDs("PortalDomain.Portal.ServerInstance", pPath);
            Iterator it = instances.iterator();
            MBeanServer mbs = PASModule.getMBeanServer();
            while (it.hasNext()) {
                String instance = (String)it.next();
                ObjectName iObjectName = AdminUtil.getInstanceMBeanObjectName((String)this.pdc.getID(), (String)((String)this.path.get(1)), (String)instance);
                String host = (String)mbs.getAttribute(iObjectName, "Host");
                if (hosts.contains(host)) continue;
                hosts.add(host);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0004", e);
            throw new PSMBeanException("error.importexport.get.instances", e.getMessage());
        }
        return hosts;
    }

    private String[] uploadFile(MBeanServerConnection mbsc, String parFileName) throws PSMBeanException {
        String[] dest = new String[2];
        try {
            dest = AdminClientUtil.uploadFile((MBeanServerConnection)mbsc, (String)this.pdc.getID(), (File)new File(parFileName), (int)0);
        }
        catch (UploadDownloadException upde) {
            Object[] tokens = new Object[]{parFileName};
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", upde);
            throw new PSMBeanException("error.importexport.upload", upde.getMessage(), tokens);
        }
        return dest;
    }

    private void downloadFile(MBeanServerConnection mbsc, String tempFileName, String parFileName) throws PSMBeanException {
        String destFileName = parFileName;
        try {
            AdminClientUtil.downloadFile((MBeanServerConnection)mbsc, (String)this.pdc.getID(), (String)tempFileName, (int)0, (String)destFileName);
        }
        catch (UploadDownloadException upde) {
            Object[] tokens = new Object[]{parFileName};
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", upde);
            throw new PSMBeanException("error.importexport.download", upde.getMessage(), tokens);
        }
    }

    private String getRemoteHost() throws PSMBeanException {
        String host = null;
        boolean isLocal = false;
        String oneHost = null;
        try {
            Set hosts = this.getHosts();
            String localhost = InetAddress.getLocalHost().getCanonicalHostName();
            Iterator it = hosts.iterator();
            oneHost = null;
            while (it.hasNext()) {
                oneHost = (String)it.next();
                logger.log(Level.INFO, "portal: " + this.portalId + ", host:  " + oneHost);
                if (!AdminServerUtil.isLocal((String)oneHost)) continue;
                logger.log(Level.INFO, "Is local true");
                isLocal = true;
                break;
            }
            if (isLocal) {
                logger.log(Level.INFO, "remote host: " + host);
                return host;
            }
            if (oneHost != null) {
                host = oneHost;
            }
            logger.log(Level.SEVERE, "DesktopDynamic.getRemoteHost(), localhost: " + localhost);
        }
        catch (UnknownHostException uhe) {
            Object[] tokens = new Object[]{oneHost};
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", uhe);
            throw new PSMBeanException("error.importexport.unknownhost", uhe.getMessage(), tokens);
        }
        return host;
    }

    private void createPortalWebApp() throws PSMBeanException {
        String[] signature = new String[]{};
        Object[] params = new Object[]{};
        try {
            ObjectName on = AdminUtil.getPortalMBeanObjectName((String)this.domainId, (String)this.portalId);
            MBeanServer mbs = PASModule.getMBeanServer();
            mbs.invoke(on, "createPortalWebApp", params, signature);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSDT_CSPDAMB0003", e);
            throw new PSMBeanException("error.importexport.createPortalWeb", e.getMessage());
        }
    }

    private void buildMBeanInfo() {
        String description = "Desktop Dynamic mbean implementation.";
        Constructor<?>[] constructors = this.getClass().getConstructors();
        MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[]{new MBeanConstructorInfo("DesktopDynamic(): Constructs a DesktopDynamic object", constructors[0])};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[9];
        MBeanParameterInfo[] bParams = new MBeanParameterInfo[]{new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName")};
        MBeanParameterInfo[] dParams = new MBeanParameterInfo[]{new MBeanParameterInfo("tempFileName", "java.lang.String", "tempFileName")};
        MBeanParameterInfo[] eParams = new MBeanParameterInfo[]{new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName"), new MBeanParameterInfo("verbose", "java.lang.Boolean", "verbose"), new MBeanParameterInfo("fsOnly", "java.lang.Boolean", "files-only"), new MBeanParameterInfo("dpOnly", "java.lang.Boolean", "dp-only"), new MBeanParameterInfo("searchLevel", "java.lang.String", "scope")};
        MBeanParameterInfo[] pParams = new MBeanParameterInfo[]{new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName"), new MBeanParameterInfo("verbose", "java.lang.Boolean", "verbose"), new MBeanParameterInfo("dn", "java.lang.String", "dn"), new MBeanParameterInfo("global", "java.lang.Boolean", "global"), new MBeanParameterInfo("exportfile", "[[B", "exportfile")};
        MBeanParameterInfo[] ipParams = new MBeanParameterInfo[]{new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName"), new MBeanParameterInfo("verbose", "java.lang.Boolean", "verbose"), new MBeanParameterInfo("overwrite", "java.lang.Boolean", "overwrite"), new MBeanParameterInfo("operations", "java.util.List", "operations"), new MBeanParameterInfo("dpnode", "java.lang.String", "dpnode")};
        MBeanParameterInfo[] lipParams = new MBeanParameterInfo[]{new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName"), new MBeanParameterInfo("verbose", "java.lang.Boolean", "verbose"), new MBeanParameterInfo("overwrite", "java.lang.Boolean", "overwrite"), new MBeanParameterInfo("portalId", "java.lang.String", "portalId"), new MBeanParameterInfo("operations", "java.util.List", "operations"), new MBeanParameterInfo("dpnode", "java.lang.String", "dpnode"), new MBeanParameterInfo("extractDP", "java.lang.Boolean", "extractDP")};
        MBeanParameterInfo[] iParams = new MBeanParameterInfo[]{new MBeanParameterInfo("verbose", "java.lang.Boolean", "verbose"), new MBeanParameterInfo("fsOnly", "java.lang.Boolean", "files-only"), new MBeanParameterInfo("dpOnly", "java.lang.Boolean", "dp-only"), new MBeanParameterInfo("overwrite", "java.lang.Boolean", "overwrite"), new MBeanParameterInfo("redeploy", "java.lang.Boolean", "redeploy"), new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName"), new MBeanParameterInfo("cont", "java.lang.Boolean", "continue"), new MBeanParameterInfo("searchLevel", "java.lang.String", "scope"), new MBeanParameterInfo("dpnode", "java.lang.String", "dpnode")};
        MBeanParameterInfo[] lParams = new MBeanParameterInfo[]{new MBeanParameterInfo("verbose", "java.lang.Boolean", "verbose"), new MBeanParameterInfo("fsOnly", "java.lang.Boolean", "files-only"), new MBeanParameterInfo("dpOnly", "java.lang.Boolean", "dp-only"), new MBeanParameterInfo("overwrite", "java.lang.Boolean", "overwrite"), new MBeanParameterInfo("redeploy", "java.lang.Boolean", "redeploy"), new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName"), new MBeanParameterInfo("portalId", "java.lang.String", "portal"), new MBeanParameterInfo("cont", "java.lang.Boolean", "continue"), new MBeanParameterInfo("searchLevel", "java.lang.String", "scope"), new MBeanParameterInfo("dpnode", "java.lang.String", "dpnode")};
        MBeanParameterInfo[] tParams = new MBeanParameterInfo[]{new MBeanParameterInfo("parFileName", "java.lang.String", "parFileName"), new MBeanParameterInfo("verbose", "java.lang.Boolean", "verbose"), new MBeanParameterInfo("dpOnly", "java.lang.Boolean", "dpOnly"), new MBeanParameterInfo("pbfilesOnly", "java.lang.Boolean", "pbfilesOnly"), new MBeanParameterInfo("warOnly", "java.lang.Boolean", "warOnly"), new MBeanParameterInfo("staticOnly", "java.lang.Boolean", "staticOnly")};
        operations[0] = new MBeanOperationInfo("getArchiveFileVersion", "getArchiveFileVersion(): get the backup file version", bParams, "java.lang.String", 1);
        operations[1] = new MBeanOperationInfo("deleteTempFile", "deleteTempFile(): delete temporary file", dParams, "void", 1);
        operations[2] = new MBeanOperationInfo("exportDesktop", "exportDesktop(): export desktop data", eParams, "void", 1);
        operations[3] = new MBeanOperationInfo("importDesktop", "importDesktop(): import desktop data", iParams, "void", 1);
        operations[4] = new MBeanOperationInfo("lImportDesktop", "lImportDesktop(): import desktop data", lParams, "void", 1);
        operations[5] = new MBeanOperationInfo("listPar", "listPar(): describes par file", tParams, "java.lang.String", 1);
        operations[6] = new MBeanOperationInfo("exportProvider", "exportProvider(): export provider data", pParams, "void", 1);
        operations[7] = new MBeanOperationInfo("importProvider", "importProvider(): import provider data", ipParams, "void", 1);
        operations[8] = new MBeanOperationInfo("lImportProvider", "lImportProvider(): import provider data", lipParams, "void", 1);
        this.dMBeanInfo = new MBeanInfo(this.dClassName, description, new MBeanAttributeInfo[0], constructorInfo, operations, new MBeanNotificationInfo[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

