/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.jato.util.Encoder;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.ServletContextThreadLocalizer;
import com.sun.portal.desktop.admin.model.EditDisplayProfileModel;
import com.sun.portal.desktop.admin.model.EditDisplayProfileModelImpl;
import com.sun.portal.log.common.PortalLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DPServlet
extends HttpServlet {
    private static final String DPSERVLET_SESSION_ATTR = "ps-admin-session-attrs";
    private static final String TOKEN_DELIMITER = "\u0c20";
    protected static String loginURL = SystemProperties.get((String)"com.iplanet.am.server.protocol") + "://" + SystemProperties.get((String)"com.iplanet.am.server.host") + ":" + SystemProperties.get((String)"com.iplanet.am.server.port") + SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor") + "/UI/Login";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$desktop$admin$DPServlet == null ? (class$com$sun$portal$desktop$admin$DPServlet = DPServlet.class$("com.sun.portal.desktop.admin.DPServlet")) : class$com$sun$portal$desktop$admin$DPServlet));
    private static int TYPE_ERROR = 0;
    private static int TYPE_WARNING = 1;
    private static int TYPE_INFORMATION = 2;
    private SSOToken ssoToken;
    private String psDeployURI;
    static /* synthetic */ Class class$com$sun$portal$desktop$admin$DPServlet;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String reqURI = req.getRequestURI();
        this.psDeployURI = reqURI.substring(0, reqURI.indexOf(47, 1));
        ServletContextThreadLocalizer.set(this.getServletConfig().getServletContext());
        try {
            this.ssoToken = this.checkAuthentication(req);
        }
        catch (SSOException soe) {
            try {
                resp.sendRedirect(loginURL);
                return;
            }
            catch (IOException ioe) {
                throw new ServletException("Cannot redirect to " + loginURL);
            }
        }
        super.service(req, resp);
    }

    private SSOToken checkAuthentication(HttpServletRequest request) throws SSOException {
        SSOTokenManager manager = SSOTokenManager.getInstance();
        SSOToken ssoToken = manager.createSSOToken(request);
        manager.getInstance().validateToken(ssoToken);
        return ssoToken;
    }

    protected String getDelimitedValue(List values) {
        StringBuffer sb = new StringBuffer();
        if (values != null && values.size() > 0) {
            for (int i = 0; i < values.size(); ++i) {
                sb.append((String)values.get(i));
                if (i >= values.size() - 1) continue;
                sb.append(TOKEN_DELIMITER);
            }
        }
        return sb.toString();
    }

    protected List getUnDelimitedValue(String value) {
        StringTokenizer st = new StringTokenizer(value, TOKEN_DELIMITER);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            result.add(token);
        }
        return result;
    }

    public void storeToSession(String name, List values) {
        block3: {
            String delimitedValue = null;
            if (name != null && !name.equals("") && values != null) {
                delimitedValue = this.getDelimitedValue(values);
            }
            try {
                this.ssoToken.setProperty(name, delimitedValue);
            }
            catch (SSOException ssoe) {
                if (!debugLogger.isLoggable(Level.INFO)) break block3;
                LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDA0006");
                logRecord.setLoggerName(debugLogger.getName());
                logRecord.setParameters(new String[]{name});
                logRecord.setThrown(ssoe);
                debugLogger.log(logRecord);
            }
        }
    }

    public List getFromSession(String name) {
        String delimitedValue;
        block2: {
            delimitedValue = null;
            try {
                delimitedValue = this.ssoToken.getProperty(name);
            }
            catch (SSOException ssoe) {
                if (!debugLogger.isLoggable(Level.INFO)) break block2;
                LogRecord logRecord = new LogRecord(Level.INFO, "PSDT_CSPDA0007");
                logRecord.setLoggerName(debugLogger.getName());
                logRecord.setParameters(new String[]{name});
                logRecord.setThrown(ssoe);
                debugLogger.log(logRecord);
            }
        }
        return this.getUnDelimitedValue(delimitedValue);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String encoding = request.getParameter("gx_charset");
        String ServiceName = request.getParameter("SvcName");
        String Location2 = request.getParameter("LocDN");
        String Template = request.getParameter("isTemplate");
        String SchemaType = request.getParameter("SchemaType");
        String action = request.getParameter("action");
        String userDN = request.getParameter("userDN");
        if (encoding == null || ServiceName == null || Location2 == null || Template == null || SchemaType == null) {
            debugLogger.info("PSDT_CSPDA0008");
            response.sendError(500);
        }
        ServiceName = new String(Encoder.decode((String)ServiceName), encoding);
        Location2 = new String(Encoder.decode((String)Location2), encoding);
        if (userDN != null && userDN.length() != 0) {
            userDN = new String(Encoder.decode((String)userDN), encoding);
        }
        HashMap<String, String> mp = new HashMap<String, String>(5);
        mp.put("gx_charset", encoding);
        mp.put("com.iplanet.am.console.service.svcName", ServiceName);
        mp.put("com-iplanet-am-console-location-dn", Location2);
        mp.put("com.iplanet.am.console.service.templateLevel", Template);
        mp.put("schemaType", SchemaType);
        ArrayList<String> lst = new ArrayList<String>(6);
        lst.add(encoding);
        lst.add(ServiceName);
        lst.add(Location2);
        lst.add(Template);
        lst.add(SchemaType);
        lst.add(userDN);
        this.storeToSession(DPSERVLET_SESSION_ATTR, lst);
        try {
            EditDisplayProfileModelImpl model = new EditDisplayProfileModelImpl(request, "psDesktopAdmin", mp);
            if (userDN != null && userDN.length() != 0) {
                model.setCurrentUser(userDN);
            }
            if (action != null && action.equalsIgnoreCase("getDP")) {
                response.setContentType("application/x-xxxxx; charset=" + encoding);
                response.setHeader("Content-Disposition", "filename=\"DisplayProfileXML\"");
                PrintWriter out = response.getWriter();
                out = response.getWriter();
                String dpXML = model.getDisplayProfile();
                if (dpXML == null || dpXML.length() < 1) {
                    dpXML = "\n";
                }
                out.write(dpXML);
                out.close();
            } else {
                response.setContentType("text/html;charset=" + encoding);
                request.setAttribute("pageTitle", (Object)model.getLocalizedString("console.title"));
                request.setAttribute("desktopLabel", (Object)model.getLocalizedString("popup.label.desktop"));
                request.setAttribute("dpLabel", (Object)model.getLocalizedString("popup.label.displayProfile"));
                request.setAttribute("selectFileLabel", (Object)model.getLocalizedString("popup.label.selectFile"));
                request.setAttribute("uploadLabel", (Object)model.getLocalizedString("popup.button.upload"));
                request.setAttribute("closeLabel", (Object)model.getLocalizedString("popup.button.close"));
                request.setAttribute("psDeployURI", (Object)this.psDeployURI);
                RequestDispatcher rd = request.getRequestDispatcher("/ps/dtadmin/UploadDP.jsp");
                rd.include((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSDT_CSPDA0009", e);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        List sessionVals = this.getFromSession(DPSERVLET_SESSION_ATTR);
        String encoding = (String)sessionVals.get(0);
        HashMap<String, String> mp = new HashMap<String, String>(5);
        mp.put("gx_charset", encoding);
        mp.put("com.iplanet.am.console.service.svcName", (String)sessionVals.get(1));
        mp.put("com-iplanet-am-console-location-dn", (String)sessionVals.get(2));
        mp.put("com.iplanet.am.console.service.templateLevel", (String)sessionVals.get(3));
        mp.put("schemaType", (String)sessionVals.get(4));
        String userDN = (String)sessionVals.get(5);
        EditDisplayProfileModelImpl model = null;
        try {
            model = new EditDisplayProfileModelImpl(req, "psDesktopAdmin", mp);
            if (userDN != null && userDN.length() != 0) {
                model.setCurrentUser(userDN);
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSDT_CSPDA0010", e);
            response.sendError(500);
        }
        response.setContentType("text/html;charset=" + encoding);
        PrintWriter out = response.getWriter();
        Hashtable postArgs = null;
        String msgMarkup = "";
        try {
            if (req.getContentType().toLowerCase().startsWith("multipart/form-data")) {
                postArgs = this.parseMultiPartFormData(req.getContentType(), req.getContentLength(), req.getInputStream());
                UploadedFile uf = (UploadedFile)postArgs.get("files");
                if (uf != null && uf.filename != null && uf.filename.length() > 0 && uf.content.length > 0) {
                    model.setDisplayProfile(uf.content);
                    msgMarkup = this.showMessage(TYPE_INFORMATION, model.getLocalizedString("popup.uploadsuccess.title"), "", model);
                } else {
                    msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), model.getLocalizedString("popup.nocontent.msg"), model);
                }
            } else {
                debugLogger.info("PSDT_CSPDA0009");
                msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), "", model);
            }
        }
        catch (AMConsoleException ce) {
            List list = ce.getErrors();
            String title = (String)list.get(0);
            String msg = (String)list.get(1);
            msgMarkup = this.showMessage(TYPE_ERROR, title, msg, model);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSDT_CSPDA0012", e);
            msgMarkup = this.showMessage(TYPE_ERROR, model.getLocalizedString("popup.uploadfailed.title"), "", model);
        }
        out.write(msgMarkup);
        out.close();
    }

    public Hashtable parseMultiPartFormData(String reqContentType, int len, ServletInputStream in) throws IOException, ServletException {
        int ind = reqContentType.indexOf("boundary=");
        String boundary = null;
        if (ind == -1 || (boundary = reqContentType.substring(ind + 9)) == null) {
            throw new ServletException("Missing or invalid boundary parameter in content type");
        }
        int buffSize = 8192;
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        String boundaryStr = "--" + boundary;
        byte[] boundaryBuf = ("\r\n" + boundaryStr).getBytes();
        byte[] b = new byte[buffSize];
        int result = in.readLine(b, 0, b.length);
        if (result == -1) {
            throw new IllegalArgumentException("InputStream truncated");
        }
        len -= result;
        String line = new String(b, 0, result, "ISO-8859-1");
        if (!line.startsWith(boundaryStr)) {
            throw new IllegalArgumentException("MIME boundary missing: " + line);
        }
        while (len > 0) {
            String filename = null;
            String contentType = null;
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            String name = null;
            result = in.readLine(b, 0, b.length);
            if (result == -1) {
                return hash;
            }
            len -= result;
            line = new String(b, 0, result - 2, "ISO-8859-1");
            String lowerline = line.toLowerCase();
            if (!lowerline.startsWith("content-disposition")) continue;
            ind = lowerline.indexOf("content-disposition: ");
            int ind2 = lowerline.indexOf(";");
            if (ind == -1 || ind2 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            String disposition = lowerline.substring(ind + 21, ind2);
            if (!disposition.equals("form-data")) {
                throw new IllegalArgumentException("Content Disposition of " + disposition + " is not supported");
            }
            int ind3 = lowerline.indexOf("name=\"", ind2);
            int ind4 = lowerline.indexOf("\"", ind3 + 7);
            if (ind3 == -1 || ind4 == -1) {
                throw new IllegalArgumentException("Content Disposition line misformatted: " + line);
            }
            name = line.substring(ind3 + 6, ind4);
            int ind5 = lowerline.indexOf("filename=\"", ind4 + 2);
            int ind6 = lowerline.indexOf("\"", ind5 + 10);
            if (ind5 != -1 && ind6 != -1) {
                filename = line.substring(ind5 + 10, ind6);
            }
            if ((result = in.readLine(b, 0, b.length)) == -1) {
                return hash;
            }
            len -= result;
            line = new String(b, 0, result - 2, "ISO-8859-1");
            lowerline = line.toLowerCase();
            if (lowerline.startsWith("content-type")) {
                int ind7 = lowerline.indexOf(" ");
                if (ind7 == -1) {
                    throw new IllegalArgumentException("Content-Type line misformatted: " + line);
                }
                contentType = lowerline.substring(ind7 + 1);
                result = in.readLine(b, 0, b.length);
                if (result == -1) {
                    return hash;
                }
                len -= result;
                line = new String(b, 0, result - 2, "ISO-8859-1");
                if (line.length() != 0) {
                    throw new IllegalArgumentException("Unexpected line in MIMEpart header: " + line);
                }
            } else if (line.length() != 0) {
                throw new IllegalArgumentException("Misformatted line following disposition: " + line);
            }
            boolean readingContent = true;
            byte[] buf = new byte[boundaryBuf.length];
            byte[] c = new byte[1];
            result = in.read(c);
            while (readingContent) {
                if (result == -1) {
                    return hash;
                }
                len -= result;
                if (c[0] == 13) {
                    int i;
                    buf[0] = c[0];
                    for (i = 1; i < boundaryBuf.length && (result = in.read(c)) != -1 && c[0] == boundaryBuf[i]; ++i) {
                        buf[i] = c[0];
                        len -= result;
                    }
                    if (i == boundaryBuf.length) {
                        readingContent = false;
                        in.read(c);
                        if (c[0] == 45) {
                            in.read(c);
                            in.read(c);
                            len -= 2;
                        }
                        in.read(c);
                        len -= 2;
                        continue;
                    }
                    if (result == -1) {
                        return hash;
                    }
                    content.write(buf, 0, i);
                    continue;
                }
                content.write(c);
                result = in.read(c);
            }
            if (filename == null) {
                if (hash.get(name) == null) {
                    String[] values = new String[]{content.toString("UTF-8")};
                    hash.put(name, values);
                    continue;
                }
                Object prevobj = hash.get(name);
                if (prevobj instanceof String[]) {
                    String[] prev = (String[])prevobj;
                    String[] newStr = new String[prev.length + 1];
                    System.arraycopy(prev, 0, newStr, 0, prev.length);
                    newStr[prev.length] = content.toString("UTF-8");
                    hash.put(name, newStr);
                    continue;
                }
                throw new IllegalArgumentException("failure in parseMulti hashtable building code");
            }
            UploadedFile uf = new UploadedFile();
            uf.name = name;
            uf.filename = filename;
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            uf.contentType = contentType;
            uf.content = content.toByteArray();
            hash.put(name, uf);
        }
        return hash;
    }

    private String showMessage(int type, String title, String message, EditDisplayProfileModel model) {
        StringBuffer buffer = new StringBuffer();
        String cssURI = this.psDeployURI + "/console/css";
        String imageURI = this.psDeployURI + "/console/images";
        String backLabel = model.getLocalizedString("popup.button.back");
        String closeLabel = model.getLocalizedString("popup.button.close");
        buffer.append("\n<html>").append("\n<head>").append("\n<link rel=\"stylesheet\" href=\"" + cssURI + "/adminstyle.css\">").append("\n</head>").append("\n<body>").append("\n<table align=center border=\"0\" cellspacing=\"0\" ").append("cellpadding=\"10\">").append("\n<tr>\n<td>").append("\n<table border=\"0\" cellspacing=\"0\" ").append("cellpadding=\"2\" ").append("class=\"").append(this.getBorderStyle(type)).append("\"").append(">").append("\n<tr>").append("\n<td>").append("\n<table cellspacing=\"0\" cellpadding=\"5\" ").append("border=\"0\" class=\"").append(this.getContentStyle(type)).append("\">").append("\n<tr>").append("\n<td valign=\"top\"><img src=\"").append(this.getTypeIcon(type, imageURI)).append("\" width=\"32\" height=\"32\" border=\"0\">").append("\n</td>").append("\n<td>").append("\n<div class=\"alert-header-text\"><b>").append(title).append("</b></div>").append("\n<div class=\"alert-normal-text\">").append(message).append("</div>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n<table align=center border=0 cellpadding=5 cellspacing=2>").append("\n<tr>").append("\n<td align=right>").append("\n<table border=0 cellpadding=1 cellspacing=0 class=\"button-frame-enabled\">").append("\n<tr><td>").append("\n<table border=0 cellpadding=0 cellspacing=0 width=\"100%\" class=\"button-content-enabled\">").append("\n<tr>").append("\n<td align=\"center\" nowrap>").append("\n<a href=\"javascript:window.history.back()\" class=\"button-link\">").append("\n<span class=\"button-link-enabled-text\">").append(backLabel).append("\n</span>").append("\n</a></td></tr>").append("\n</table>").append("\n</td></tr>").append("\n</table>").append("\n</td>").append("\n<td align=left>").append("\n<table border=0 cellpadding=1 cellspacing=0 class=\"button-frame-enabled\">").append("\n<tr><td>").append("\n<table border=0 cellpadding=0 cellspacing=0 width=\"100%\" class=\"button-content-enabled\">").append("\n<tr>").append("\n<td align=\"center\" nowrap>").append("\n<a href=\"javascript:window.close()\" class=\"button-link\">").append("\n<span class=\"button-link-enabled-text\">").append(closeLabel).append("\n</span>").append("\n</a></td></tr>").append("\n</table>").append("\n</td></tr>").append("\n</table>").append("\n</td>").append("\n</tr>").append("\n</table>").append("\n</body>").append("\n</html>");
        return buffer.toString();
    }

    protected String getTypeIcon(int type, String URI2) {
        String image = null;
        image = type == TYPE_WARNING ? URI2 + "/warning_32_sunplex.gif" : (type == TYPE_INFORMATION ? URI2 + "/info_32_sunplex.gif" : URI2 + "/error_32_sunplex.gif");
        return image;
    }

    protected String getContentStyle(int type) {
        String style = null;
        style = type == TYPE_WARNING ? "alert-warning-content" : (type == TYPE_INFORMATION ? "alert-info-content" : "alert-error-content");
        return style;
    }

    protected String getBorderStyle(int type) {
        String style = null;
        style = type == TYPE_WARNING ? "alert-warning-frame" : (type == TYPE_INFORMATION ? "alert-info-frame" : "alert-error-frame");
        return style;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UploadedFile {
        public String name;
        public String filename;
        public String contentType;
        public byte[] content;

        UploadedFile() {
        }
    }
}

