/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.pool;

import com.sun.common.pool.ObjectManager;
import com.sun.common.pool.Pool;
import com.sun.portal.desktop.monitoring.PoolStatistic;
import java.util.ArrayList;
import java.util.List;

public class SimpleObjectPool
implements Pool {
    private ObjectManager _objectManager;
    private List _objectPool;
    private int _minSize;
    private int _maxSize;
    private boolean _overflow;
    private int _leased;
    private int _mid;
    private boolean _destroyed;
    private PoolStatistic poolStatistic;

    public SimpleObjectPool(ObjectManager objectManager, int minSize, int maxSize, boolean overflow) {
        this._objectManager = objectManager;
        this._objectPool = new ArrayList(maxSize);
        this._minSize = minSize;
        this._maxSize = maxSize;
        this._mid = (this._minSize + this._maxSize) / 2 + 1;
        this._overflow = overflow;
        this._leased = 0;
        this._destroyed = false;
        for (int i = 0; i < this._minSize; ++i) {
            this._objectPool.add(this._objectManager.createObject(null));
        }
    }

    public synchronized Object obtainObject(Object param) {
        if (this._destroyed) {
            throw new IllegalStateException();
        }
        Object o = null;
        int size = this._objectPool.size();
        if (size > 0) {
            o = this._objectPool.remove(size - 1);
            ++this._leased;
        } else if (this._leased < this._maxSize || this._overflow) {
            o = this._objectManager.createObject(param);
            ++this._leased;
        }
        if (this.poolStatistic != null) {
            this.poolStatistic.setCurrent(this._leased);
        }
        return o;
    }

    public synchronized void releaseObject(Object o) {
        --this._leased;
        if (this._destroyed) {
            this._objectManager.destroyObject(o);
        } else {
            this._objectPool.add(o);
            int size = this._objectPool.size();
            int extra = size - this._maxSize;
            if (extra > 0 && this._leased < this._mid) {
                for (int i = 0; i < extra; ++i) {
                    o = this._objectPool.remove(--size);
                    this._objectManager.destroyObject(o);
                }
            }
        }
        if (this.poolStatistic != null) {
            this.poolStatistic.setCurrent(this._leased);
        }
    }

    public int getLeased() {
        return this._leased;
    }

    public int getMinSize() {
        return this._minSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (this._destroyed) {
            throw new IllegalStateException();
        }
        this._maxSize = maxSize;
    }

    public synchronized void destroy() {
        if (this._destroyed) {
            throw new IllegalStateException();
        }
        this._destroyed = true;
        for (int i = 0; i < this._objectPool.size(); ++i) {
            Object o = this._objectPool.get(i);
            this._objectManager.destroyObject(o);
        }
    }

    public final boolean doesReuseObjects() {
        return true;
    }

    protected void finalize() {
        if (!this._destroyed) {
            this.destroy();
        }
    }

    public void setPoolStatistic(PoolStatistic poolStatistic) {
        this.poolStatistic = poolStatistic;
    }
}

