/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.pool;

import com.sun.common.pool.ObjectManager;
import com.sun.common.pool.Pool;
import com.sun.portal.desktop.monitoring.PoolStatistic;

public class NullObjectPool
implements Pool {
    private ObjectManager _objectManager;
    private boolean _destroyed;
    private int _leased;
    private PoolStatistic poolStatistic;

    public NullObjectPool(ObjectManager objectManager) {
        this._objectManager = objectManager;
        this._destroyed = false;
    }

    public Object obtainObject(Object param) {
        if (this._destroyed) {
            throw new IllegalStateException();
        }
        ++this._leased;
        if (this.poolStatistic != null) {
            this.poolStatistic.setCurrent(this._leased);
        }
        return this._objectManager.createObject(param);
    }

    public void releaseObject(Object o) {
        this._objectManager.destroyObject(o);
        --this._leased;
        if (this.poolStatistic != null) {
            this.poolStatistic.setCurrent(this._leased);
        }
    }

    public int getLeased() {
        return this._leased;
    }

    public int getMinSize() {
        return 0;
    }

    public int getMaxSize() {
        return 0;
    }

    public void setMaxSize(int maxSize) {
    }

    public void destroy() {
        this._destroyed = true;
    }

    public final boolean doesReuseObjects() {
        return false;
    }

    public void setPoolStatistic(PoolStatistic poolStatistic) {
        this.poolStatistic = poolStatistic;
    }
}

