/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands.portlet;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class UNRegisterPortletCommand
extends AdminBaseCommand {
    public static final String ERROR_EITHER_DN_OR_GLOBAL = "error.psadmin.deploy-portlet.either.dn.or.global";
    public static final String ERROR_NEITHER_DN_NOR_GLOBAL = "error.psadmin.deploy-portlet.neither.dn.nor.global";
    public static final String ERROR_OPERAND_NOT_FOUND = "error.psadmin.deploy-portlet.operand.not.found";
    public static final String OPT_DN = "dn";
    public static final String OPT_GLOBAL = "global";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_NODEPLOY = "nodeploy";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String dn = null;
    private boolean global = false;
    private boolean verbose = false;
    private String instance = null;
    private String earAppName = null;

    protected void checkDependency() throws CommandException {
        if (this.dn != null && this.global) {
            throw new CommandException(this.getLocalizedString(ERROR_EITHER_DN_OR_GLOBAL), null);
        }
        if (this.dn == null && !this.global) {
            throw new CommandException(this.getLocalizedString(ERROR_NEITHER_DN_NOR_GLOBAL), null);
        }
    }

    protected void validateOperands() throws CommandException {
        Vector operandsVector = this.getOperands();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        try {
            this.validateOptions();
            this.validatePortalId();
            this.validateOperands();
            this.verbose = true;
            Vector operandsVector = this.getOperands();
            this.earAppName = (String)operandsVector.get(0);
            this.dn = this.getOption(OPT_DN);
            this.global = this.getBooleanOption(OPT_GLOBAL);
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst(this.getPortalId());
            path.addFirst("PortletAdmin");
            String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean"};
            Object[] params = new Object[]{this.dn, new Boolean(this.global), this.earAppName, new Boolean(this.verbose)};
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.PortletAdmin", path);
            msc.invoke(objName, "unregisterPortletApp", params, signature);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{"unregisterPortletApp"}), null);
        }
        catch (MBeanException me) {
            PSMBeanException pme = (PSMBeanException)me.getTargetException();
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", me);
            throw new CommandException(this.getLocalizedString(pme.getErrorKey(), pme.getTokens()));
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ce);
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), null);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    public void loadProperties(String fileName, Properties properties) throws IOException {
        File f = new File(fileName);
        FileInputStream fis = new FileInputStream(f);
        properties.load(fis);
        fis.close();
    }
}

