/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands.portlet;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class UNDeployPortletCommand
extends AdminBaseCommand {
    public static final String ERROR_EITHER_DN_OR_GLOBAL = "error.psadmin.deploy-portlet.either.dn.or.global";
    public static final String ERROR_NEITHER_DN_NOR_GLOBAL = "error.psadmin.deploy-portlet.neither.dn.nor.global";
    public static final String ERROR_OPERAND_NOT_FOUND = "error.psadmin.deploy-portlet.operand.not.found";
    public static final String OPT_DN = "dn";
    public static final String OPT_GLOBAL = "global";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_INSTANCE = "instance";
    private String dn = null;
    private boolean global;
    private boolean verbose;
    private String instance = null;
    private String portletAppName = null;

    protected void checkDependency() throws CommandException {
        if (this.dn != null && this.global) {
            throw new CommandException(this.getLocalizedString(ERROR_EITHER_DN_OR_GLOBAL), null);
        }
        if (this.dn == null && !this.global) {
            throw new CommandException(this.getLocalizedString(ERROR_NEITHER_DN_NOR_GLOBAL), null);
        }
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Properties rolesProperties = new Properties();
        Properties userinfoProperties = new Properties();
        this.validateOptions();
        this.validatePortalId();
        try {
            this.dn = this.getOption(OPT_DN);
            this.global = this.getBooleanOption(OPT_GLOBAL);
            this.checkDependency();
            this.verbose = true;
            this.instance = this.getOption(OPT_INSTANCE);
            this.portletAppName = (String)this.getOperands().get(0);
            ArrayList<String> instances = null;
            if (this.instance != null) {
                instances = new ArrayList<String>();
                instances.add(this.instance);
            }
            Object[] params = new Object[]{this.dn, new Boolean(this.global), this.portletAppName, new Boolean(this.verbose), instances, new Boolean(false)};
            String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.util.List", "java.lang.Boolean"};
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst(this.getPortalId());
            path.addFirst("PortletAdmin");
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.PortletAdmin", path);
            msc.invoke(objName, "undeployAll", params, signature);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{"undeployAll"}), null);
        }
        catch (MBeanException me) {
            PSMBeanException pme = (PSMBeanException)me.getTargetException();
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", me);
            throw new CommandException(this.getLocalizedString(pme.getErrorKey(), pme.getTokens()));
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ce);
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), null);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }
}

