/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands.portlet;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class RegisterPortletCommand
extends AdminBaseCommand {
    public static final String ERROR_EITHER_DN_OR_GLOBAL = "error.psadmin.deploy-portlet.either.dn.or.global";
    public static final String ERROR_NEITHER_DN_NOR_GLOBAL = "error.psadmin.deploy-portlet.neither.dn.nor.global";
    public static final String ERROR_OPERAND_NOT_FOUND = "error.psadmin.deploy-portlet.operand.not.found";
    public static final String ERROR_DEPLOY_PORTLET_EAR_EXT_NOT_RIGHT = "error.psadmin.deploy-portlet.ear.ext.not.right";
    public static final String ERROR_READING_PROPERTIES_FILE = "portlet.errorReadingProperties";
    public static final String VERBOSE_LOADING_ROLES = "portlet.verbose.LoadingRolesFile";
    public static final String VERBOSE_LOADING_USERINFO = "portlet.verbose.LoadingUserInfoFile";
    public static final String VERBOSE_GET_CONNECTION = "portlet.verbose.ObtainServerConnection";
    public static final String VERBOSE_INVOKE_MBEAN = "portlet.verbose.InvokingMbeanMethod";
    public static final String VERBOSE_INVOKE_SUCCESS = "portlet.verbose.MbeanMethodInvoked";
    public static final String OPT_DN = "dn";
    public static final String OPT_GLOBAL = "global";
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_ROLESFILE = "rolesfile";
    public static final String OPT_USERINFOFILE = "userinfofile";
    public static final String OPT_INSTANCE = "instance";
    public static final String OPT_NODEPLOY = "nodeploy";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String dn = null;
    private boolean global = false;
    private boolean verbose = false;
    private String rolesfile = null;
    private String userinfofile = null;
    private String instance = null;
    private String earFileName = null;

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.validatePortalId();
        this.validateOperands();
        this.verbose = true;
        Vector operandsVector = this.getOperands();
        Properties rolesProperties = new Properties();
        Properties userinfoProperties = new Properties();
        this.userinfofile = this.getOption(OPT_USERINFOFILE);
        this.rolesfile = this.getOption(OPT_ROLESFILE);
        StringBuffer outputBuffer = new StringBuffer();
        if (this.rolesfile != null) {
            this.validateFile(this.rolesfile);
            if (this.verbose) {
                CLILogger.getInstance().printMessage(this.getLocalizedString(VERBOSE_LOADING_ROLES));
            }
            try {
                this.loadProperties(this.rolesfile, rolesProperties);
                rolesProperties.list(System.out);
            }
            catch (IOException ie) {
                logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ie);
                throw new CommandException(this.getLocalizedString(ERROR_READING_PROPERTIES_FILE, new Object[]{this.rolesfile}), null);
            }
        }
        if (this.userinfofile != null) {
            this.validateFile(this.userinfofile);
            if (this.verbose) {
                CLILogger.getInstance().printMessage(this.getLocalizedString(VERBOSE_LOADING_USERINFO));
            }
            try {
                this.loadProperties(this.userinfofile, userinfoProperties);
                userinfoProperties.list(System.out);
            }
            catch (IOException ie) {
                logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ie);
                throw new CommandException(this.getLocalizedString(ERROR_READING_PROPERTIES_FILE, new Object[]{this.userinfofile}), null);
            }
        }
        this.dn = this.getOption(OPT_DN);
        this.global = this.getBooleanOption(OPT_GLOBAL);
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.util.Properties", "java.util.Properties", "java.lang.Boolean"};
            Object[] params = new Object[]{this.dn, new Boolean(this.global), this.earFileName, rolesProperties, userinfoProperties, new Boolean(true)};
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst(this.getPortalId());
            path.addFirst("PortletAdmin");
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.PortletAdmin", path);
            msc.invoke(objName, "registerPortletApp", params, signature);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{"registerPortletApp"}), null);
        }
        catch (MBeanException me) {
            PSMBeanException pme = (PSMBeanException)me.getTargetException();
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", me);
            throw new CommandException(this.getLocalizedString(pme.getErrorKey(), pme.getTokens()));
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACCD0001", ce);
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACCP0001", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), null);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    protected void checkDependency() throws CommandException {
        if (this.dn != null && this.global) {
            throw new CommandException(this.getLocalizedString(ERROR_EITHER_DN_OR_GLOBAL), null);
        }
        if (this.dn == null && !this.global) {
            throw new CommandException(this.getLocalizedString(ERROR_NEITHER_DN_NOR_GLOBAL), null);
        }
    }

    protected void validateOperands() throws CommandException {
        Vector operandsVector = this.getOperands();
        this.earFileName = (String)operandsVector.get(0);
        if (!this.earFileName.endsWith(".ear")) {
            throw new CommandException(this.getLocalizedString(ERROR_DEPLOY_PORTLET_EAR_EXT_NOT_RIGHT), null);
        }
        this.validateFile(this.earFileName);
    }

    private void validateFile(String filename) throws CommandException {
        File file = new File(filename);
        String fullPath = file.getAbsolutePath();
        if (!file.exists()) {
            Object[] token = new String[]{fullPath};
            throw new CommandException(this.getLocalizedString("error.psadmin.file.not.found", token));
        }
        if (!file.canRead() || file.length() == 0L) {
            Object[] token = new String[]{fullPath};
            throw new CommandException(this.getLocalizedString("error.psadmin.error.reading.file", token));
        }
    }

    public void loadProperties(String fileName, Properties properties) throws IOException {
        File f = new File(fileName);
        FileInputStream fis = new FileInputStream(f);
        properties.load(fis);
        fis.close();
    }
}

