/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util;

import com.sun.portal.rewriter.RewriterLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Debug {
    private static final Logger debugRest = RewriterLogger.getLogger("debug.com.sun.portal.rewriter.rest");
    private static final Logger debugRuleSetInfo = RewriterLogger.getLogger("debug.com.sun.portal.rewriter.rulesetinfo");
    private static final Logger debugURI = RewriterLogger.getLogger("debug.com.sun.portal.rewriter.uriinfo");
    private static final Logger debugOriginalPage = RewriterLogger.getLogger("debug.com.sun.portal.rewriter.original");
    private static final Logger debugUnaffectedPage = RewriterLogger.getLogger("debug.com.sun.portal.rewriter.unaffected");
    private static final Logger debugRewrittenPage = RewriterLogger.getLogger("debug.com.sun.portal.rewriter.rewritten");

    public static void recordRuleSetWarning(String aRecordRuleSet) {
        debugRuleSetInfo.warning(aRecordRuleSet);
    }

    public static void recordRuleSetWarning(String aRecordRuleSet, Object[] param) {
        debugRuleSetInfo.log(Level.WARNING, aRecordRuleSet, param);
    }

    public static void recordRuleSetMessage(String aRecordRuleSet) {
        debugRuleSetInfo.finest(aRecordRuleSet);
    }

    public static void recordURIMessage(String aRecordURI) {
        debugURI.finest(aRecordURI);
    }

    public static void recordURIMessage(String aRecordURI, Object[] param) {
        debugURI.log(Level.FINEST, aRecordURI, param);
    }

    public static void recordURIWarning(String aRecordURI) {
        debugURI.warning(aRecordURI);
    }

    public static void recordURIWarning(String aRecordURI, Object[] param) {
        debugURI.log(Level.WARNING, aRecordURI, param);
    }

    public static void recordURIWarning(String aRecordURI, Exception e) {
        debugURI.log(Level.WARNING, aRecordURI, e);
    }

    public static void recordOriginalPageMessage(String aOriginalContent) {
        debugOriginalPage.finest(aOriginalContent);
    }

    public static void recordOriginalPageMessage(String aOriginalContent, Object[] param) {
        debugOriginalPage.log(Level.FINEST, aOriginalContent, param);
    }

    public static void recordOriginalPageWarning(String aOriginalContent) {
        debugOriginalPage.warning(aOriginalContent);
    }

    public static void recordOriginalPageWarning(String aOriginalContent, Object[] param) {
        debugOriginalPage.log(Level.WARNING, aOriginalContent, param);
    }

    public static void recordOriginalPageWarning(String aOriginalContent, Exception e) {
        debugOriginalPage.log(Level.WARNING, aOriginalContent, e);
    }

    public static void recordRewrittenPageMessage(String aRewrittenContent) {
        debugRewrittenPage.finest(aRewrittenContent);
    }

    public static void recordRewrittenPageMessage(String aRewrittenContent, Object[] param) {
        debugRewrittenPage.log(Level.FINEST, aRewrittenContent, param);
    }

    public static void recordUnaffectedPageMessage(String aRewrittenContent) {
        debugUnaffectedPage.finest(aRewrittenContent);
    }

    public static void recordUnaffectedPageMessage(String aRewrittenContent, Object[] param) {
        debugUnaffectedPage.log(Level.FINEST, aRewrittenContent, param);
    }

    public static void recordUnaffectedPageWarning(String aRecordWarning) {
        debugUnaffectedPage.warning(aRecordWarning);
    }

    public static void message(String msg) {
        debugRest.finest(msg);
    }

    public static void message(String msg, Object[] param) {
        debugRest.log(Level.FINEST, msg, param);
    }

    public static void warning(String msg) {
        debugRest.warning(msg);
    }

    public static void warning(String msg, Object[] param) {
        debugRest.log(Level.WARNING, msg, param);
    }

    public static void warning(String msg, Throwable t) {
        debugRest.log(Level.WARNING, msg, t);
    }

    public static void error(String msg) {
        debugRest.severe(msg);
    }

    public static void error(String msg, Throwable t) {
        debugRest.log(Level.SEVERE, msg, t);
    }

    public static void println(Object msg) {
        System.out.println(msg);
    }

    public static boolean isMessageEnabled() {
        return debugRest.isLoggable(Level.FINEST);
    }

    public static boolean isWarningEnabled() {
        return debugRest.isLoggable(Level.WARNING);
    }

    public static boolean isErrorEnabled() {
        return debugRest.isLoggable(Level.SEVERE);
    }

    public static void main(String[] args) {
        Debug.error("I am Error");
        Debug.warning("I am Warning");
        Debug.message("I am Message");
    }

    static {
        String dummyMSG = "DUMMY_INFO_TO_CREATE_THE_FILE";
        debugRest.severe(dummyMSG);
        if (Debug.isWarningEnabled() || Debug.isMessageEnabled()) {
            debugRuleSetInfo.warning(dummyMSG);
            debugURI.warning(dummyMSG);
            debugOriginalPage.warning(dummyMSG);
            debugUnaffectedPage.warning(dummyMSG);
            debugRewrittenPage.warning(dummyMSG);
        }
    }
}

