/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.services.file;

import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceException;
import com.sun.portal.rewriter.services.DataServiceHelper;
import com.sun.portal.rewriter.services.file.FileEventListenerImpl;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;

public final class FileDataService
implements DataService {
    public static final String[][] default_rulesets = new String[][]{{"generic_ruleset", "/resources/GenericRuleSet.xml"}, {"default_gateway_ruleset", "/resources/DefaultGatewayRuleSet.xml"}};
    private static final FileEventListenerImpl registar = new FileEventListenerImpl();
    private static final String FILE_BASE_DIR = "DATA_SERVICE_BASE";
    private String baseDir;
    static /* synthetic */ Class class$java$util$logging$FileHandler;

    public FileDataService(Properties aProps) {
        File f;
        String lBaseDir = aProps.getProperty(FILE_BASE_DIR, ".");
        if (!lBaseDir.endsWith(File.separator)) {
            this.baseDir = lBaseDir + File.separator;
        }
        if (!(f = new File(this.baseDir)).exists()) {
            f.mkdirs();
        }
    }

    public String storeXML(String aRuleSetID, String aXMLRuleSet) throws DataServiceException, UnsupportedOperationException {
        String result = "";
        try {
            result = this.retrieveXML(aRuleSetID);
            File f = new File(this.baseDir + aRuleSetID);
            f.createNewFile();
            FileOutputStream fOut = new FileOutputStream(f);
            fOut.write(aXMLRuleSet.getBytes());
            fOut.flush();
            fOut.close();
            fOut = null;
            this.fireEvent(aRuleSetID);
        }
        catch (Exception e) {
            throw new DataServiceException(e.getMessage(), e);
        }
        return result;
    }

    public String deleteKey(String aRuleSetID) throws DataServiceException, UnsupportedOperationException {
        try {
            String oldValue = this.readAndDelete(aRuleSetID);
            this.fireEvent(aRuleSetID);
            return oldValue;
        }
        catch (Exception e) {
            throw new DataServiceException(e.getMessage(), e);
        }
    }

    public String retrieveXML(String aRuleSetID) throws DataServiceException {
        Debug.message("Retrieve the RuleSet Located at: " + this.baseDir + aRuleSetID);
        try {
            for (int i = 0; i < default_rulesets.length; ++i) {
                if (!aRuleSetID.equals(default_rulesets[i][0])) continue;
                return Resource.readXML(default_rulesets[i][1]);
            }
            return FileDataService.read(new File(this.baseDir + aRuleSetID));
        }
        catch (Exception e) {
            throw new DataServiceException(e.getMessage(), e);
        }
    }

    public Set retrieveKeys() throws DataServiceException {
        try {
            return new HashSet<String>(Arrays.asList(new File(this.baseDir).list()));
        }
        catch (Exception e) {
            throw new DataServiceException(e.getMessage(), e);
        }
    }

    private String readAndDelete(String aRuleSetIDKey) throws Exception {
        File f = new File(this.baseDir + aRuleSetIDKey);
        String result = FileDataService.read(f);
        f.delete();
        return result;
    }

    private static String read(File f) throws Exception {
        String result = "File Does Not Exisit: " + f.toURL();
        if (f.exists()) {
            return Resource.read(new FileReader(f));
        }
        return result;
    }

    public Observable getChangeNotifier() {
        return registar;
    }

    private void fireEvent(String aEventInfo) {
        ((FileEventListenerImpl)this.getChangeNotifier()).dispatch(aEventInfo);
    }

    public String matchesWithID(String aKey) throws DataServiceException {
        if (this.retrieveKeys().contains(aKey)) {
            return aKey;
        }
        return null;
    }

    public static void main(String[] args) throws DataServiceException {
        String lBaseDir = args[0];
        String lFileName = args[1];
        Properties props = new Properties();
        props.setProperty("DATA_SOURCE_TYPE", "FILE");
        props.setProperty(FILE_BASE_DIR, lBaseDir);
        FileDataService dataService = new FileDataService(props);
        Debug.println(dataService.storeXML(lFileName, "one raja devaki devi"));
        Debug.println(dataService.retrieveKeys());
        Debug.println(dataService.storeXML(lFileName, "two raja nagendra kumar"));
        Debug.println(dataService.storeXML(lFileName + lFileName, "two raja nagendra kumar"));
        Debug.println(dataService.deleteKey(lFileName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DataServiceHelper.initLogSystem(class$java$util$logging$FileHandler == null ? (class$java$util$logging$FileHandler = FileDataService.class$("java.util.logging.FileHandler")) : class$java$util$logging$FileHandler, ConfigManager.getLogLocation(), ConfigManager.getLogLevel());
    }
}

