/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines.markup;

import com.sun.portal.rewriter.AbsoluteTranslator;
import com.sun.portal.rewriter.LookAheadInfo;
import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.TranslatorHelper;
import com.sun.portal.rewriter.engines.AbstractRewriter;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.engines.html.HTMLRewriter;
import com.sun.portal.rewriter.engines.js.JSRewriter;
import com.sun.portal.rewriter.engines.markup.MarkupRewriterHelper;
import com.sun.portal.rewriter.engines.markup.PageContext;
import com.sun.portal.rewriter.engines.markup.TagContext;
import com.sun.portal.rewriter.rom.Data;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.rom.RuleSetHelper;
import com.sun.portal.rewriter.rom.common.Attribute;
import com.sun.portal.rewriter.rom.html.Applet;
import com.sun.portal.rewriter.rom.html.Form;
import com.sun.portal.rewriter.test.util.CreateRuleSet;
import com.sun.portal.rewriter.test.util.SampleRuleObjects;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.re.Pattern;
import com.sun.portal.rewriter.util.uri.PageSpec;
import com.sun.portal.rewriter.util.xml.TagParser;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public final class MarkupRewriter
extends AbstractRewriter {
    public static final String PROPERTY_IS_COMMENT_BASE_HREF = "IS_COMMENT_BASE_HREF";
    public static final String PROPERTY_IS_COMMENT_BODY_BACKGROUND = "IS_COMMENT_BODY_BACKGROUND";
    public static final String PROPERTY_IS_INSERT_CODEBASE = "IS_INSERT_CODEBASE";
    public static final String PROPERTY_EXCLUDED_FORM_INPUT_TYPES = "EXCLUDED_FORM_INPUT_TYPES";
    private static final boolean IS_INSERT_CODEBASE = ConfigManager.getBoolean("IS_INSERT_CODEBASE");
    private static final List EXCLUDED_FORM_INPUT_TYPES = Arrays.asList(StringHelper.tokenize(ConfigManager.getProperty("EXCLUDED_FORM_INPUT_TYPES").toLowerCase(), ";"));

    public MarkupRewriter(RewriterBroker aRewriterBroker) {
        super(aRewriterBroker, "text/markup");
    }

    public final void plugableRewriter(PageContent aPageContent, Translator aTranslator) {
        this.parseMarkupContent(aPageContent, aTranslator);
    }

    private final void parseMarkupContent(PageContent aPageContent, Translator aTranslator) {
        StringBuffer lPageBuff = aPageContent.getResultBuffer();
        PageContext lPageContext = new PageContext(lPageBuff);
        String aContent = aPageContent.getOriginalContent();
        StringBuffer jsb = MarkupRewriterHelper.createBuffer();
        StringBuffer cssb = MarkupRewriterHelper.createBuffer();
        StringBuffer xmlb = MarkupRewriterHelper.createBuffer();
        int startIndex = 0;
        int endIndex = 0;
        boolean needs = true;
        boolean isS = false;
        boolean isL = false;
        boolean isTag = false;
        String prev = null;
        String endedWith = "";
        boolean isTextArea = false;
        boolean isJScript = false;
        boolean isCSS = false;
        boolean isSPAN = false;
        boolean isXML = false;
        int length = aPageContent.length();
        while (startIndex < length) {
            if (isS) {
                isS = false;
                ++startIndex;
                isTag = true;
                if (isJScript) {
                    jsb.append("<");
                    continue;
                }
                if (isXML) {
                    xmlb.append("<");
                    continue;
                }
                if (isCSS) {
                    cssb.append("<");
                    continue;
                }
                lPageBuff.append("<");
                continue;
            }
            if (isL) {
                isL = false;
                ++startIndex;
                isTag = false;
                if (isJScript) {
                    jsb.append(endedWith);
                    continue;
                }
                if (isXML) {
                    xmlb.append(endedWith);
                    continue;
                }
                if (isCSS) {
                    cssb.append(endedWith);
                    continue;
                }
                if (isTextArea) {
                    isTextArea = false;
                    lPageBuff.append(endedWith);
                    int endTextArea = MarkupRewriterHelper.skip2EndOfTag(aPageContent.toLowerCase(), startIndex, "/textarea");
                    if (endTextArea == -1) continue;
                    lPageBuff.append(aContent.substring(startIndex, endTextArea));
                    startIndex = endTextArea;
                    continue;
                }
                lPageBuff.append(endedWith);
                continue;
            }
            if (needs) {
                endIndex = aContent.indexOf(60, startIndex);
                if (endIndex == -1) {
                    prev = aContent.substring(startIndex);
                    startIndex = length;
                } else {
                    prev = aContent.substring(startIndex, endIndex);
                    startIndex = endIndex;
                }
                isS = true;
                needs = false;
            } else {
                endIndex = aContent.indexOf(62, startIndex);
                if (endIndex == -1) {
                    prev = aContent.substring(startIndex);
                    startIndex = length;
                } else {
                    endedWith = ">";
                    int bIndex = endIndex;
                    if (MarkupRewriterHelper.isEmptyTag(aContent, endIndex)) {
                        --bIndex;
                        endedWith = "/>";
                    }
                    prev = aContent.substring(startIndex, bIndex);
                    startIndex = endIndex;
                }
                isL = true;
                needs = true;
            }
            if (prev == null) continue;
            if (prev.trim().length() == 0) {
                if (isJScript) {
                    jsb.append(prev);
                    continue;
                }
                if (isXML) {
                    xmlb.append(prev);
                    continue;
                }
                if (isCSS) {
                    cssb.append(prev);
                    continue;
                }
                lPageBuff.append(prev);
                continue;
            }
            if (isTag) {
                if (isXML) {
                    String tmptag = MarkupRewriterHelper.getBlockTag(prev, xmlb);
                    if (tmptag.trim().equalsIgnoreCase("/xml")) {
                        isXML = false;
                        this.rewriteTagBlock(this.getRewriterBroker().getXMLRewriter(), aTranslator, xmlb.toString().trim(), lPageBuff);
                        lPageBuff.append(tmptag);
                        xmlb = MarkupRewriterHelper.createBuffer();
                    } else {
                        xmlb.append(tmptag);
                    }
                } else if (isJScript) {
                    String tmptag = MarkupRewriterHelper.getBlockTag(prev, jsb);
                    if (tmptag.trim().equalsIgnoreCase("/script")) {
                        isJScript = false;
                        aTranslator.getLookAheadInfo().markJSStartIndex(lPageBuff);
                        this.rewriteTagBlock(this.getRewriterBroker().getJSRewriter(), aTranslator, jsb.toString().trim(), lPageBuff);
                        lPageBuff.append(tmptag);
                        jsb = MarkupRewriterHelper.createBuffer();
                    } else {
                        jsb.append(tmptag);
                    }
                } else if (isCSS) {
                    String tmptag = MarkupRewriterHelper.getBlockTag(prev, cssb);
                    if (tmptag.trim().equalsIgnoreCase("/style")) {
                        isCSS = false;
                        this.rewriteTagBlock(this.getRewriterBroker().getCSSRewriter(), aTranslator, cssb.toString().trim(), lPageBuff);
                        lPageBuff.append(tmptag);
                        cssb = MarkupRewriterHelper.createBuffer();
                    } else {
                        cssb.append(tmptag);
                    }
                } else if (prev.indexOf("=") == -1) {
                    lPageBuff.append(prev);
                } else if (prev.startsWith("!--") && prev.endsWith("--")) {
                    lPageBuff.append(prev);
                } else {
                    String lResult = this.parseTag(prev, endedWith, aTranslator, lPageContext);
                    if (lResult.endsWith("--")) {
                        endedWith = ">";
                    }
                    lPageBuff.append(lResult);
                }
                String bPrevContent = prev.trim();
                if (bPrevContent.regionMatches(true, 0, "textarea", 0, "textarea".length()) && MarkupRewriterHelper.isValidNextTagChar(bPrevContent, "textarea") && !isJScript) {
                    isTextArea = true;
                    continue;
                }
                if (bPrevContent.regionMatches(true, 0, "script", 0, "script".length()) && MarkupRewriterHelper.isValidNextTagChar(bPrevContent, "script")) {
                    isJScript = true;
                    continue;
                }
                if (bPrevContent.regionMatches(true, 0, "xml", 0, "xml".length()) && MarkupRewriterHelper.isValidNextTagChar(bPrevContent, "xml")) {
                    if (bPrevContent.regionMatches(true, 0, "XML:namespace", 0, 13) || isJScript) continue;
                    isXML = true;
                    continue;
                }
                if (bPrevContent.regionMatches(true, 0, "span", 0, "span".length()) && MarkupRewriterHelper.isValidNextTagChar(bPrevContent, "span")) {
                    if (isXML || isJScript) continue;
                    isSPAN = true;
                    continue;
                }
                if (!bPrevContent.regionMatches(true, 0, "style", 0, "style".length()) || !MarkupRewriterHelper.isValidNextTagChar(bPrevContent, "style") || isXML || isJScript) continue;
                isCSS = true;
                continue;
            }
            if (isJScript) {
                jsb.append(prev);
                continue;
            }
            if (isXML) {
                xmlb.append(prev);
                continue;
            }
            if (isCSS) {
                cssb.append(prev);
                continue;
            }
            if (isSPAN) {
                isSPAN = false;
                this.getRewriterBroker().getHTMLRewriter();
                lPageBuff.append(HTMLRewriter.parseSPAN(prev, aTranslator));
                continue;
            }
            lPageBuff.append(prev);
        }
        if (jsb.length() > 0) {
            lPageBuff.append(jsb.toString());
        }
        if (cssb.length() > 0) {
            lPageBuff.append(cssb.toString());
        }
    }

    public void endRewriting(PageContent aPageContent, Translator aTranslator) {
        LookAheadInfo lLookAheadInfo = aTranslator.getLookAheadInfo();
        int jsStartIndex = lLookAheadInfo.getJSStartIndex();
        String jsWrapperFunctionsDefination = lLookAheadInfo.readJSFunctions(aTranslator);
        if (jsStartIndex != -1 && jsWrapperFunctionsDefination.length() != 0) {
            aPageContent.getResultBuffer().insert(jsStartIndex, "\n//-->\n</SCRIPT>\n").insert(jsStartIndex, jsWrapperFunctionsDefination).insert(jsStartIndex, "\n<SCRIPT>\n<!--\n");
        }
    }

    private String parseTag(String aTagContent, String aEndedWith, Translator aTranslator, PageContext aPageContext) {
        String lLowerTagContent = aTagContent.toLowerCase();
        StringBuffer lTagResultBuffer = new StringBuffer(aTagContent.length());
        LookAheadInfo lLookAheadInfo = aTranslator.getLookAheadInfo();
        lLookAheadInfo.setTagContext(new TagContext());
        String lResult = this.doParseTag(aTagContent, lLowerTagContent, lTagResultBuffer, aEndedWith, aPageContext, aTranslator);
        lLookAheadInfo.setTagContext(null);
        lLookAheadInfo.setAppletCodeBase(null);
        return lResult;
    }

    private String doParseTag(String aTagContent, String aLowerTagContent, StringBuffer aTagResultBuffer, String aEndedWith, PageContext aPageContext, Translator aTranslator) {
        int currentCharIndex;
        TagContext lTagContext = aTranslator.getLookAheadInfo().getTagContext();
        StringTokenizer lStringTokenizer = new StringTokenizer(aLowerTagContent);
        if (lStringTokenizer.hasMoreTokens()) {
            lTagContext.tagName = lStringTokenizer.nextToken();
            aPageContext.currentTag(lTagContext.tagName);
            if (lTagContext.tagName.equals("applet") || lTagContext.tagName.equals("object")) {
                String spaceRemovedTagStmt;
                if (IS_INSERT_CODEBASE && aEndedWith.length() != 0 && (spaceRemovedTagStmt = StringHelper.searchAndReplace(aLowerTagContent, " ", "")).indexOf("codebase=") == -1) {
                    StringBuffer modSB = new StringBuffer(aTagContent);
                    aTranslator.getLookAheadInfo().enableContentChanged();
                    modSB.insert(aLowerTagContent.indexOf(lTagContext.tagName) + lTagContext.tagName.length(), " codebase=" + aTranslator.getPageSpec().getBaseURI().getBaseHREF());
                    String bModifiedTagContent = modSB.toString();
                    return this.doParseTag(bModifiedTagContent, bModifiedTagContent.toLowerCase(), aTagResultBuffer, aEndedWith, aPageContext, aTranslator);
                }
                MarkupRewriterHelper.setLookAheadCodeBaseInfo(aTranslator, TagParser.parse(aTagContent));
            }
        }
        int mContentLength = aLowerTagContent.length();
        int mStart = 0;
        int mHolder = 0;
        int mPrevStart = 0;
        int mStartLink = 0;
        int mEndLink = 0;
        int mEqual2Index = -1;
        boolean inSQuote = false;
        boolean inDQuote = false;
        boolean inESQuote = false;
        boolean inEDQuote = false;
        boolean mEndOfString = false;
        boolean mLookForString = false;
        for (currentCharIndex = 0; currentCharIndex < mContentLength; ++currentCharIndex) {
            char currentChar = aLowerTagContent.charAt(currentCharIndex);
            if (Character.isWhitespace(currentChar) || mEndOfString) {
                if (inSQuote || inDQuote) continue;
                mLookForString = false;
                mEndOfString = false;
                if (Character.isWhitespace(currentChar)) {
                    while (currentCharIndex + 1 < mContentLength && Character.isWhitespace(aLowerTagContent.charAt(currentCharIndex + 1))) {
                        ++currentCharIndex;
                    }
                    if (currentCharIndex + 1 >= mContentLength) {
                        mStart = currentCharIndex + 1;
                    } else {
                        if (aLowerTagContent.charAt(currentCharIndex + 1) == '=') continue;
                        mStart = currentCharIndex + 1;
                    }
                } else {
                    mStart = currentCharIndex;
                }
                if (mStartLink > mEndLink) {
                    mEndLink = currentCharIndex;
                }
                this.rewriteAttribute(aTagContent, aTagResultBuffer, lTagContext, aTranslator, aPageContext, mStartLink, mEndLink, mPrevStart, currentCharIndex);
                mPrevStart = mEndLink = currentCharIndex;
                continue;
            }
            if (currentChar == '\\') {
                if (currentCharIndex + 1 >= mContentLength) continue;
                char c2 = aLowerTagContent.charAt(currentCharIndex + 1);
                if (c2 == '\'') {
                    if (currentCharIndex != mEqual2Index + 1 && !inESQuote) continue;
                    boolean bl = inESQuote = !inESQuote;
                    if (inESQuote) {
                        mStartLink = currentCharIndex + 2;
                    } else {
                        mEndLink = currentCharIndex;
                        mEndOfString = true;
                    }
                    ++currentCharIndex;
                    continue;
                }
                if (c2 != '\"' || currentCharIndex != mEqual2Index + 1 && !inEDQuote) continue;
                boolean bl = inEDQuote = !inEDQuote;
                if (inEDQuote) {
                    mStartLink = currentCharIndex + 2;
                } else {
                    mEndLink = currentCharIndex;
                    mEndOfString = true;
                }
                ++currentCharIndex;
                continue;
            }
            if (currentChar == '\'') {
                if (currentCharIndex != mEqual2Index + 1 && !inSQuote || inDQuote) continue;
                boolean bl = inSQuote = !inSQuote;
                if (inSQuote) {
                    mStartLink = currentCharIndex + 1;
                    continue;
                }
                mEndLink = currentCharIndex;
                mEndOfString = true;
                continue;
            }
            if (currentChar == '\"') {
                if (currentCharIndex != mEqual2Index + 1 && !inDQuote || inSQuote) continue;
                boolean bl = inDQuote = !inDQuote;
                if (inDQuote) {
                    mStartLink = currentCharIndex + 1;
                    continue;
                }
                mEndLink = currentCharIndex;
                mEndOfString = true;
                continue;
            }
            if (currentChar != '=' || mLookForString || inDQuote || inSQuote) continue;
            mEqual2Index = currentCharIndex;
            mLookForString = true;
            mStartLink = currentCharIndex + 1;
            if (mStartLink >= mContentLength) {
                aTagResultBuffer.append(aTagContent.substring(mPrevStart));
                return aTagResultBuffer.toString();
            }
            mHolder = currentCharIndex;
            while (mStartLink < mContentLength && Character.isWhitespace(aLowerTagContent.charAt(mStartLink))) {
                ++mEqual2Index;
                ++mStartLink;
                ++mHolder;
            }
            lTagContext.attributeName = aLowerTagContent.substring(mStart, currentCharIndex).trim();
            this.matchWithHTMLRules(lTagContext, aTranslator, aPageContext);
            currentCharIndex = mHolder;
        }
        if (mStartLink > mEndLink) {
            mEndLink = currentCharIndex;
        }
        this.rewriteAttribute(aTagContent, aTagResultBuffer, lTagContext, aTranslator, aPageContext, mStartLink, mEndLink, mPrevStart, currentCharIndex);
        if (aTranslator.getPageSpec().getMIME().equalsIgnoreCase("text/html") || aTranslator.getPageSpec().getMIME().equalsIgnoreCase("application/x-javascript")) {
            MarkupRewriterHelper.commentAttributes(lTagContext.tagName, aTagResultBuffer, aEndedWith, aTranslator);
        }
        return aTagResultBuffer.toString();
    }

    private void rewriteAttribute(String aTagContent, StringBuffer aTagResultBuffer, TagContext aTagContext, Translator aTranslator, PageContext aPageContext, int aLinkStart, int aLinkEnd, int aPrevStart, int aCursorIndex) {
        aTagContext.attributeValue = aTagContent.substring(aLinkStart, aLinkEnd);
        this.storePageAndTagValues(aPageContext, aTagContext, aTranslator);
        Data lMache = aTagContext.getMache();
        if (lMache != null) {
            aTagResultBuffer.append(aTagContent.substring(aPrevStart, aLinkStart));
            Attribute bMatch = null;
            if (lMache instanceof Attribute) {
                bMatch = (Attribute)lMache;
            }
            if (bMatch == null || bMatch.getType().equals("URL")) {
                this.rewriteURL(aTagResultBuffer, aPageContext, aTagContext, aTranslator);
            } else if (bMatch.getType().equals("DJS")) {
                this.rewriteSCRIPT(aTagResultBuffer, aPageContext, aTagContext.attributeValue, false, aTranslator);
            } else if (bMatch.getType().equals("DHTML")) {
                aTagResultBuffer.append(this.rewrite(aTagContext.attributeValue, aTranslator));
            }
        } else {
            aTagResultBuffer.append(aTagContent.substring(aPrevStart, aLinkEnd));
        }
        aTagResultBuffer.append(aTagContent.substring(aLinkEnd, aCursorIndex));
        aTagContext.reset();
    }

    private void storePageAndTagValues(PageContext aPageContext, TagContext aTagContext, Translator aTranslator) {
        if (aTagContext.attributeName.equals("name") || aTagContext.attributeName.equals("id")) {
            if (aTagContext.tagName.equals("form")) {
                aPageContext.formName = aTagContext.attributeValue;
            } else if (aTagContext.tagName.equals("select")) {
                aPageContext.selectName = aTagContext.attributeValue;
            } else {
                aTagContext.inputFieldName = aTagContext.attributeValue;
            }
        } else if (aTagContext.attributeName.equals("href")) {
            if (aTagContext.tagName.equals("base")) {
                aTagContext.attributeValue = MarkupRewriterHelper.setBaseSpec(aTranslator, aTagContext.attributeValue);
            }
        } else if (aTagContext.attributeName.equals("type")) {
            if (aTagContext.tagName.equals("input")) {
                aTagContext.inputFieldType = aTagContext.attributeValue.toLowerCase();
                return;
            }
        } else {
            MarkupRewriter.dealWithApplet(aPageContext, aTagContext, aTranslator);
        }
    }

    private final void rewriteURL(StringBuffer aTagResultBuffer, PageContext aPageContext, TagContext aTagContext, Translator aTranslator) {
        if (aTagContext.attributeValue.trim().regionMatches(true, 0, "javascript:", 0, 11)) {
            int index = aTagContext.attributeValue.indexOf(":") + 1;
            aTagResultBuffer.append(aTagContext.attributeValue.substring(0, index));
            this.rewriteSCRIPT(aTagResultBuffer, aPageContext, aTagContext.attributeValue.substring(index), aTagContext.isCodeBase(), aTranslator);
        } else {
            Pattern[] patterns = aTagContext.getPatterns();
            if (patterns.length > 0) {
                String result = TranslatorHelper.translateSubStrings(patterns, aTagContext.attributeValue, aTranslator);
                aTagResultBuffer.append(result);
            } else if (aTagContext.tagName.equals("meta") && aTagContext.attributeName.equals("content")) {
                MarkupRewriterHelper.rewriteMetaTag(aTagResultBuffer, aTagContext.attributeValue, aTranslator);
            } else if (aTagContext.attributeName.equals("style")) {
                aTagResultBuffer.append(this.getRewriterBroker().getCSSRewriter().rewrite(aTagContext.attributeValue, aTranslator));
            } else {
                aTagResultBuffer.append(aTranslator.translate(aTagContext.attributeValue));
            }
        }
    }

    private static void dealWithApplet(PageContext aPageContext, TagContext aTagContext, Translator aTranslator) {
        if (aTagContext.tagName.equals("applet") || aTagContext.tagName.equals("object")) {
            if (aTagContext.attributeName.equals("code") || aTagContext.attributeName.equals("classid")) {
                aPageContext.appletName = aTagContext.attributeValue;
            }
            MarkupRewriterHelper.checkAndSetAppletBegin(aTagContext, aTranslator);
        }
    }

    private void matchWithHTMLRules(TagContext aTagContext, Translator aTranslator, PageContext aPageContext) {
        PageSpec lPageSpec = aTranslator.getPageSpec();
        if (aTagContext.attributeName.length() != 0) {
            aTranslator.getLookAheadInfo().setInAppletAttributeEnd();
        }
        aTagContext.setMacheRule(null);
        String lTagName = aTagContext.tagName;
        if (aTagContext.attributeName.equals("value")) {
            if (lTagName.equals("param")) {
                Applet bMache = aPageContext.getAppletInstance().recycleMatchee(aPageContext.appletName, aTagContext.inputFieldName, lPageSpec.getPageURI().getFullFileURI());
                aTagContext.setMacheRule(RuleSetHelper.findHTMLAppletMatch(this.getRuleSet(), bMache));
                return;
            }
            if (lTagName.equals("input")) {
                if (EXCLUDED_FORM_INPUT_TYPES.contains(aTagContext.inputFieldType)) {
                    return;
                }
                Form bMache = aPageContext.getFormInstance().recycleMatchee(aPageContext.formName, aTagContext.inputFieldName, lPageSpec.getPageURI().getFullFileURI());
                aTagContext.setMacheRule(RuleSetHelper.findHTMLFormMatch(this.getRuleSet(), bMache));
                return;
            }
            if (lTagName.equals("option")) {
                Form bMache = aPageContext.getFormInstance().recycleMatchee(aPageContext.formName, aPageContext.selectName, lPageSpec.getPageURI().getFullFileURI());
                aTagContext.setMacheRule(RuleSetHelper.findHTMLFormMatch(this.getRuleSet(), bMache));
                return;
            }
        }
        Attribute bMache = aPageContext.getAttributeInstance().recycleMatchee(aTagContext.attributeName, lTagName, "URL", aTranslator.getPageSpec().getPageURI().getFullFileURI());
        aTagContext.setMacheRule(RuleSetHelper.findHTMLAttributeMatch(this.getRuleSet(), bMache));
    }

    private void rewriteTagBlock(Rewriter aRewriter, Translator aTranslator, String aContent, StringBuffer aPageBuff) {
        String lContent = aContent.substring(">".length(), aContent.length() - "<".length());
        aPageBuff.append(">");
        int bCommentEndIndex = lContent.length();
        if (!(aRewriter instanceof JSRewriter) && lContent.trim().startsWith("<!--")) {
            int startIndex = lContent.indexOf("<!--");
            aPageBuff.append(lContent.substring(0, startIndex));
            aPageBuff.append("<!--");
            lContent = lContent.substring(startIndex + "<!--".length());
            bCommentEndIndex = lContent.lastIndexOf("-->");
            if (bCommentEndIndex != -1) {
                if (lContent.substring(bCommentEndIndex + "-->".length()).trim().length() != 0) {
                    bCommentEndIndex = lContent.length();
                }
            } else {
                bCommentEndIndex = lContent.length();
            }
        }
        aPageBuff.append(aRewriter.rewrite(lContent.substring(0, bCommentEndIndex), aTranslator));
        aPageBuff.append(lContent.substring(bCommentEndIndex));
        aPageBuff.append("<");
    }

    private void rewriteSCRIPT(StringBuffer aTagResultBuffer, PageContext aPageContext, String aAttributeValue, boolean aISCodeBase, Translator aTranslator) {
        aTranslator.getLookAheadInfo().markJSStartIndex(aPageContext.getPageBuffer());
        if (aISCodeBase) {
            String bExpressionFunctionName = aTranslator.getJSFunctionSpec().getExpressionFunctionName();
            aTranslator.getLookAheadInfo().addJSFunction(bExpressionFunctionName);
            aTagResultBuffer.append(bExpressionFunctionName).append('(');
        }
        String jsResult = this.getRewriterBroker().getJSRewriter().rewrite(aAttributeValue, aTranslator);
        aTagResultBuffer.append(jsResult);
        if (aISCodeBase) {
            int lastSemiColen = jsResult.lastIndexOf(59);
            if (lastSemiColen == -1) {
                aTagResultBuffer.append(')');
            } else {
                lastSemiColen = jsResult.length() - lastSemiColen;
                aTagResultBuffer.insert(aTagResultBuffer.length() - lastSemiColen, ')');
            }
        }
    }

    public static void main(String[] args) {
        try {
            RuleSet lRuleSet = CreateRuleSet.emptyRuleSet();
            Rewriter uRewriter = RewriterPool.create(lRuleSet, "text/markup");
            Debug.println(uRewriter.rewrite(Resource.read(args[0]), (Translator)new AbsoluteTranslator(SampleRuleObjects.testPageSpec)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

