/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.engines;

import com.sun.portal.rewriter.Rewriter;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.engines.LanguageConstants;
import com.sun.portal.rewriter.engines.PageContent;
import com.sun.portal.rewriter.engines.RewriterBroker;
import com.sun.portal.rewriter.rom.RuleSet;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.PageSpec;
import java.io.Reader;
import java.io.StringReader;

public abstract class AbstractRewriter
implements Rewriter,
LanguageConstants {
    private final RewriterBroker rewriterBroker;
    private final String mime;

    protected AbstractRewriter(RewriterBroker aRewriterBroker, String aMIME) {
        this.rewriterBroker = aRewriterBroker;
        this.mime = aMIME;
    }

    public RuleSet getRuleSet() {
        return this.rewriterBroker.getRuleSet();
    }

    public String getMIME() {
        return this.mime;
    }

    public Reader rewrite(Reader aReader, Translator aTranslator) {
        return new StringReader(this.rewrite(Resource.read(aReader), aTranslator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String rewrite(String aContent, Translator aTranslator) {
        boolean root = aTranslator.getLookAheadInfo().isRootRewriter();
        String lRewrittenConent = aContent;
        try {
            if (StringHelper.normalize(aContent).length() < 1) {
                String string = aContent;
                return string;
            }
            PageContent lPageContent = new PageContent(aContent);
            this.plugableRewriter(lPageContent, aTranslator);
            if (root) {
                this.endRewriting(lPageContent, aTranslator);
            }
            lRewrittenConent = lPageContent.getResult();
        }
        catch (Exception e) {
            Debug.recordOriginalPageWarning("", e);
        }
        finally {
            if (root) {
                this.recordPage(aTranslator.getPageSpec(), lRewrittenConent, aContent);
            }
        }
        return lRewrittenConent;
    }

    public abstract void plugableRewriter(PageContent var1, Translator var2);

    public void endRewriting(PageContent aPageContent, Translator aTranslator) {
    }

    protected final RewriterBroker getRewriterBroker() {
        return this.rewriterBroker;
    }

    private void recordPage(PageSpec aPageSpec, String aRewrittenConent, String aContent) {
        if (Debug.isMessageEnabled()) {
            Object[] param1;
            Object[] param0;
            String bRewrittenConent = aRewrittenConent;
            boolean unaffected = false;
            if (aRewrittenConent.trim().equals(aContent.trim())) {
                bRewrittenConent = "This Page remains same as the Original Page even after rewritting";
                unaffected = true;
            }
            String bHeadder = "\n{\n" + (unaffected ? "(IDENTICAL)" : "") + aPageSpec + "RuleSet ID: " + this.getRuleSet().getID() + ",\n" + "Parser MIME: " + this.mime + ",\n";
            if (unaffected) {
                param0 = new Object[]{bHeadder};
                param1 = new Object[]{bRewrittenConent};
                Debug.recordUnaffectedPageMessage("PSRW_CSPR_0016", param0);
                Debug.recordUnaffectedPageMessage("PSRW_CSPR_0015", param1);
            } else {
                param0 = new Object[]{bHeadder};
                param1 = new Object[]{bRewrittenConent};
                Debug.recordRewrittenPageMessage("PSRW_CSPR_0016", param0);
                Debug.recordRewrittenPageMessage("PSRW_CSPR_0015", param1);
            }
            param0 = new Object[]{bHeadder};
            param1 = new Object[]{aContent};
            Debug.recordOriginalPageMessage("PSRW_CSPR_0017", param0);
            Debug.recordOriginalPageMessage("PSRW_CSPR_0015", param1);
        }
    }
}

