/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.RewriterPool;
import com.sun.portal.rewriter.rom.RuleSetManager;
import com.sun.portal.rewriter.services.DataService;
import com.sun.portal.rewriter.services.DataServiceFactory;
import com.sun.portal.rewriter.services.DataServiceHelper;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.i18n.EncodingHelper;
import com.sun.portal.rewriter.util.i18n.MIMEHelper;
import java.util.Map;
import java.util.Properties;

public class RewriterModule {
    public static final String REWRITER_LOG = "debug.com.sun.portal.rewriter";
    public static final String REWRITER_LOG_REST = "debug.com.sun.portal.rewriter.rest";
    public static final String REWRITER_LOG_RULRESET_INFO = "debug.com.sun.portal.rewriter.rulesetinfo";
    public static final String REWRITER_LOG_URI_INFO = "debug.com.sun.portal.rewriter.uriinfo";
    public static final String REWRITER_LOG_ORIGINAL_PAGES = "debug.com.sun.portal.rewriter.original";
    public static final String REWRITER_LOG_REWRITTEN_PAGES = "debug.com.sun.portal.rewriter.rewritten";
    public static final String REWRITER_LOG_UNAFFECTED_PAGES = "debug.com.sun.portal.rewriter.unaffected";
    public static final String RESOURCE_HOME = "/resources";
    public static final String RESOURCE_RULESET_TEMPLATE_LOCATION = "/resources/RuleSetTemplate.xml";
    public static final String RULESET_TEMPLATE_ID = "ruleset_template";
    public static final String RESOURCE_GENERIC_RULESET_LOCATION = "/resources/GenericRuleSet.xml";
    public static final String GENRIC_RULESET_ID = "generic_ruleset";
    public static final String RESOURCE_DEFAULT_RULESET_LOCATION = "/resources/DefaultRuleSet.xml";
    public static final String DEFAULT_RULESET_ID = "default_ruleset";
    public static final String[][] PORTAL_RULESET_SPEC = new String[][]{{"/resources/GenericRuleSet.xml", "generic_ruleset"}, {"/resources/RuleSetTemplate.xml", "ruleset_template"}};
    public static final String RESOURCE_RULESET_DTD_LOCATION = "/resources/RuleSet.dtd";
    public static final String RESOURCE_RULESET_V62_DTD_LOCATION = "/resources/RuleSetV62.dtd";
    public static final String RESOURCE_CONVERT_EXPRESSTION_FUNCTION_LOCATION = "/resources/ConvertExpression.js";
    public static final String RESOURCE_URI_UTILS_LOCATION = "/resources/URIUtils.js";
    public static final String RESOURCE_CONVERT_SYSTEM_FUNCTION_LOCATION = "/resources/ConvertSystem.js";
    public static final String RESOURCE_RWCLIPROPS_LOCATION = "/resources/RuleSetCLI.properties";
    public static final String RESOURCE_RWCLISPEC_LOCATION = "/resources/RuleSetCLISpec.xml";
    public static final String RESOURCE_RWCLISPEC_DTD_LOCATION = "/resources/CLISpec.dtd";
    public static final String RESOURCE_EXT_2_MIME_MAPPING_LOCATION = "/resources/Ext2MimeMapping.properties";
    public static final String RESOURCE_JAVA_2_IANA_ENCODING_MAPPING_LOCATION = "/resources/Java2IANAEncodingMappings.properties";
    public static final String RESOURCE_REWRITER_MODULE_PROPERTIES_LOCATION = "/resources/RewriterModule.properties";
    public static final String PROPERTY_MIME_MAP_LOCATION = "MIME_MAP_LOCATION";
    public static final String PROPERTY_ENCODING_MAP_LOCATION = "ENCODING_MAP_LOCATION";

    public static void init(Properties aDataServiceProps, Properties aConfigProps, Properties aI18NProps) {
        ConfigManager.init(RewriterModule.mergeProperties(aConfigProps, RewriterModule.getConfigProps()));
        RewriterModule.init(DataServiceFactory.create(aDataServiceProps), aConfigProps, aI18NProps);
    }

    public static void init(DataService aDataService, Properties aConfigProps, Properties aI18NProps) {
        ConfigManager.init(RewriterModule.mergeProperties(aConfigProps, RewriterModule.getConfigProps()));
        if (aI18NProps == null) {
            aI18NProps = RewriterModule.getMIMEAndEncodingProps();
        }
        MIMEHelper.init(aI18NProps.getProperty(PROPERTY_MIME_MAP_LOCATION));
        EncodingHelper.init(aI18NProps.getProperty(PROPERTY_ENCODING_MAP_LOCATION));
        new RewriterPool(new RuleSetManager(aDataService));
    }

    private static Properties getConfigProps() {
        return ConfigManager.readProps(RESOURCE_REWRITER_MODULE_PROPERTIES_LOCATION);
    }

    private static Properties getMIMEAndEncodingProps() {
        Properties lResult = new Properties();
        lResult.put(PROPERTY_MIME_MAP_LOCATION, RESOURCE_EXT_2_MIME_MAPPING_LOCATION);
        lResult.put(PROPERTY_ENCODING_MAP_LOCATION, RESOURCE_JAVA_2_IANA_ENCODING_MAPPING_LOCATION);
        return lResult;
    }

    private static Properties mergeProperties(Properties aCustomProps, Properties aDefaultProps) {
        if (aCustomProps == null) {
            return aDefaultProps;
        }
        aDefaultProps.putAll((Map<?, ?>)aCustomProps);
        return aDefaultProps;
    }

    public static void initIDS() {
        RewriterModule.init(DataServiceHelper.getDefaultIDSProps(), null, null);
    }

    public static synchronized void initIDSAME() {
        if (RuleSetManager.getDefault() == null) {
            RewriterModule.init(DataServiceHelper.getDefaultIDSAMEProps(), null, null);
        }
    }

    public static void initIDSAME(String aUserName, String aPassword) {
        RewriterModule.init(DataServiceHelper.getIDSAMEProps(aUserName, aPassword), null, null);
    }

    public static void initFile() {
        RewriterModule.init(DataServiceHelper.getDefaultFileProps(), null, null);
    }

    public static void initFile(String logLocation, String logLevel) {
        Properties logProps = new Properties();
        logProps.put("LOG_LOCATION", logLocation);
        logProps.put("LOG_LEVEL", logLevel);
        RewriterModule.init(DataServiceHelper.getDefaultFileProps(), logProps, null);
    }
}

