/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter;

import com.sun.portal.rewriter.AbsoluteJSFunctionSpec;
import com.sun.portal.rewriter.JSFunctionSpec;
import com.sun.portal.rewriter.LookAheadInfo;
import com.sun.portal.rewriter.Translator;
import com.sun.portal.rewriter.TranslatorHelper;
import com.sun.portal.rewriter.util.ConfigManager;
import com.sun.portal.rewriter.util.Debug;
import com.sun.portal.rewriter.util.StringHelper;
import com.sun.portal.rewriter.util.uri.DecoratedURI;
import com.sun.portal.rewriter.util.uri.PageSpec;

public abstract class AbstractTranslator
implements Translator {
    public static final String PROPERTY_IS_ADD_SCRIPT_REFERRER = "IS_ADD_SCRIPT_REFERRER";
    private static final boolean IS_ADD_SCRIPT_REFERRER = ConfigManager.getBoolean("IS_ADD_SCRIPT_REFERRER");
    private static final String JAR_PROTOCOL = "jar:";
    private final LookAheadInfo lookAheadInfo = new LookAheadInfo();
    private final PageSpec pageSpec;
    private final JSFunctionSpec jsFunctionSpec;

    protected AbstractTranslator(PageSpec aPageSpec) {
        this(aPageSpec, AbsoluteJSFunctionSpec.getDefault());
    }

    protected AbstractTranslator(PageSpec aPageSpec, JSFunctionSpec aJSFunctionSpec) {
        this.pageSpec = aPageSpec;
        this.jsFunctionSpec = aJSFunctionSpec;
    }

    public PageSpec getPageSpec() {
        return this.pageSpec;
    }

    public JSFunctionSpec getJSFunctionSpec() {
        this.lookAheadInfo.enableContentChanged();
        return this.jsFunctionSpec;
    }

    public final LookAheadInfo getLookAheadInfo() {
        return this.lookAheadInfo;
    }

    public final String translate(String aOrgURL) {
        this.lookAheadInfo.enableContentChanged();
        PageSpec lPageSpec = this.lookAheadInfo.isAppletCodeBaseExists() ? this.lookAheadInfo.getAppletCodeBase() : this.getPageSpec();
        return AbstractTranslator.doTranslate(aOrgURL, lPageSpec, this);
    }

    static final String doTranslate(String aOrgURL, PageSpec aResolveSpec, Translator aTranslator) {
        if (!aResolveSpec.isValid()) {
            if (Debug.isWarningEnabled()) {
                Object[] param = new Object[]{aOrgURL};
                Debug.recordURIWarning("PSRW_CSPR_0001", param);
            }
            return aOrgURL;
        }
        String[] parts = StringHelper.regExpSplit(aOrgURL, "^([(\\\\\")\\s\"'])+|([(\\\\\")\\s\"'])+$");
        if (parts.length != 3 || parts[1].length() == 0) {
            if (Debug.isWarningEnabled()) {
                Object[] param = new Object[]{aOrgURL};
                Debug.recordURIWarning("PSRW_CSPR_0002", param);
            }
            return aOrgURL;
        }
        String urlPart = parts[1];
        if (urlPart.equals("#") || urlPart.equals("?") || urlPart.startsWith("+")) {
            if (Debug.isWarningEnabled()) {
                Object[] param = new Object[]{aOrgURL};
                Debug.recordURIWarning("PSRW_CSPR_0003", param);
            }
            return aOrgURL;
        }
        if (urlPart.startsWith("\\")) {
            urlPart = "/" + urlPart.substring(1);
        }
        if (StringHelper.startsWithIgnoreCase(urlPart, JAR_PROTOCOL)) {
            parts[0] = parts[0] + urlPart.substring(0, JAR_PROTOCOL.length());
            urlPart = urlPart.substring(JAR_PROTOCOL.length());
        }
        try {
            StringBuffer sb = new StringBuffer(Math.round((float)aOrgURL.length() * 1.25f));
            sb.append(parts[0]);
            DecoratedURI lAbsoluteURI = aResolveSpec.getBaseURI().resolve(urlPart);
            if (aTranslator != null) {
                DecoratedURI lWithScriptReffer = lAbsoluteURI;
                if (IS_ADD_SCRIPT_REFERRER && aTranslator.getLookAheadInfo().getTagContext().isScriptSRC()) {
                    lWithScriptReffer = TranslatorHelper.handleScriptSRC(aResolveSpec, lAbsoluteURI);
                }
                String hookTranslatedURI = aTranslator.hook4Translate(lAbsoluteURI, lWithScriptReffer);
                sb.append(hookTranslatedURI);
                AbstractTranslator.recordURI(aTranslator.getPageSpec(), aResolveSpec, aOrgURL, lAbsoluteURI, hookTranslatedURI);
            } else {
                sb.append(lAbsoluteURI.toExternalForm());
                AbstractTranslator.recordURI(aResolveSpec, aResolveSpec, aOrgURL, lAbsoluteURI, "Asked for conversion to absolute URI only");
            }
            sb.append(parts[2]);
            return sb.toString();
        }
        catch (Exception e) {
            if (Debug.isWarningEnabled()) {
                if (Debug.isMessageEnabled() && e.getMessage().startsWith("mailto")) {
                    Object[] param0 = new Object[]{aResolveSpec};
                    Object[] param1 = new Object[]{aOrgURL};
                    Debug.recordURIMessage("PSRW_CSPR_0004");
                    Debug.recordURIMessage("PSRW_CSPR_0005", param0);
                    Debug.recordURIMessage("PSRW_CSPR_0006", param1);
                } else {
                    Object[] param0 = new Object[]{aResolveSpec};
                    Object[] param1 = new Object[]{aOrgURL};
                    Debug.recordURIWarning("PSRW_CSPR_0007");
                    Debug.recordURIWarning("PSRW_CSPR_0005", param0);
                    Debug.recordURIWarning("PSRW_CSPR_0006", param1);
                }
            }
            return aOrgURL;
        }
    }

    private static void recordURI(PageSpec aPageSpec, PageSpec aResolveSpec, String aOrgURL, DecoratedURI aAbsoluteURI, String aHookTranslatedURI) {
        if (Debug.isMessageEnabled()) {
            Object[] param0 = new Object[]{aPageSpec != aResolveSpec ? aResolveSpec.getBaseURI().toExternalForm() : ""};
            Object[] param1 = new Object[]{aOrgURL};
            Object[] param2 = new Object[]{aAbsoluteURI.toExternalForm()};
            Object[] param3 = new Object[]{aHookTranslatedURI};
            Debug.recordURIMessage("PSRW_CSPR_0008");
            Debug.recordURIMessage("PSRW_CSPR_0009", param0);
            Debug.recordURIMessage("PSRW_CSPR_0010", param1);
            Debug.recordURIMessage("PSRW_CSPR_0011", param2);
            Debug.recordURIMessage("PSRW_CSPR_0012", param3);
        }
    }
}

