/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;

public abstract class XMLGregorianCalendar
implements Cloneable {
    public abstract int getDay();

    public abstract int getHour();

    public int getMillisecond() {
        BigDecimal fractionalSeconds = this.getFractionalSecond();
        if (fractionalSeconds == null) {
            return Integer.MIN_VALUE;
        }
        return this.getFractionalSecond().movePointRight(3).intValue();
    }

    public abstract int getMinute();

    public abstract int getMonth();

    public abstract int getSecond();

    public abstract int getTimezone();

    public abstract int getYear();

    public int hashCode() {
        int timezone = this.getTimezone();
        if (timezone == Integer.MIN_VALUE) {
            timezone = 0;
        }
        XMLGregorianCalendar gc = this;
        if (timezone != 0) {
            gc = this.normalize();
        }
        return gc.getYear() + gc.getMonth() + gc.getDay() + gc.getHour() + gc.getMinute() + gc.getSecond();
    }

    public abstract void clear();

    public abstract void reset();

    public abstract boolean isValid();

    public abstract void setDay(int var1);

    public abstract void setHour(int var1);

    public abstract void setMillisecond(int var1);

    public abstract void setMinute(int var1);

    public abstract void setMonth(int var1);

    public abstract void setSecond(int var1);

    public abstract void setTimezone(int var1);

    public abstract void setYear(int var1);

    public void setTime(int hour, int minute, int second) {
        this.setTime(hour, minute, second, null);
    }

    public void setTime(int hour, int minute, int second, int millisecond) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(millisecond);
    }

    public abstract Object clone();

    public boolean equals(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Cannot test null for equality with this XMLGregorianCalendar");
        }
        boolean result = false;
        if (obj instanceof XMLGregorianCalendar) {
            result = this.compare((XMLGregorianCalendar)obj) == 0;
        }
        return result;
    }

    public String toString() {
        return this.toXMLFormat();
    }

    public abstract String toXMLFormat();

    public abstract BigDecimal getFractionalSecond();

    public void setTime(int hour, int minute, int second, BigDecimal fractional) {
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setFractionalSecond(fractional);
    }

    public abstract void setFractionalSecond(BigDecimal var1);

    public abstract BigInteger getEon();

    public abstract BigInteger getEonAndYear();

    public abstract void setYear(BigInteger var1);

    public abstract GregorianCalendar toGregorianCalendar();

    public abstract TimeZone getTimeZone(int var1);

    public abstract void add(Duration var1);

    public abstract XMLGregorianCalendar normalize();

    public abstract int compare(XMLGregorianCalendar var1);

    public abstract QName getXMLSchemaType();

    public abstract GregorianCalendar toGregorianCalendar(TimeZone var1, Locale var2, XMLGregorianCalendar var3);
}

