/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.crypt.jsse;

import com.sun.portal.proxylet.crypt.jsse.NetletDataRepository;
import com.sun.portal.proxylet.crypt.jsse.NetletJSSEAuthContext;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.net.ssl.X509KeyManager;

public class NetletKeyManager
implements X509KeyManager {
    NetletJSSEAuthContext authContext = null;
    NetletDataRepository repos = null;
    KeyStore ks = null;
    String alias = null;

    public NetletKeyManager(NetletJSSEAuthContext authContext) {
        this.authContext = authContext;
        this.repos = NetletDataRepository.getInstance();
    }

    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        this.setContext();
        try {
            if (this.ks == null) {
                this.ks = KeyStore.getInstance(this.repos.getKeyStoreType().toString(), this.repos.getKeyStoreType().getProvider());
                if (this.repos.getKeyStoreStream() != null) {
                    this.ks.load(this.repos.getKeyStoreStream(), this.repos.getKeyStorePassphrase());
                } else {
                    this.ks.load(new FileInputStream(this.repos.getKeyStorePath()), this.repos.getKeyStorePassphrase());
                }
            }
            this.alias = this.ks.aliases().nextElement();
            return this.alias;
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (NoSuchProviderException ne) {
            throw new IllegalArgumentException(ne.getMessage());
        }
        catch (Exception na) {
            throw new IllegalArgumentException(na.getMessage());
        }
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return null;
    }

    public X509Certificate[] getCertificateChain(String a) {
        this.alias = this.chooseClientAlias(null, null, null);
        try {
            Certificate[] certs = this.ks.getCertificateChain(this.alias);
            Vector<Certificate> temp = new Vector<Certificate>(certs.length);
            int i = 0;
            while (i < certs.length) {
                temp.add(certs[i]);
                ++i;
            }
            return temp.toArray(new X509Certificate[0]);
        }
        catch (KeyStoreException e) {
            return null;
        }
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] temp = new String[1];
        if (this.alias == null) {
            temp[0] = this.alias = this.chooseClientAlias(null, null, null);
        }
        return temp;
    }

    public PrivateKey getPrivateKey(String a) {
        this.alias = this.chooseClientAlias(null, null, null);
        try {
            return (PrivateKey)this.ks.getKey(this.alias, this.repos.getKeyStorePassphrase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return null;
    }

    private void setContext() {
        if (this.repos.getKeyStorePassphrase() == null) {
            this.repos.setKeyStoreStream(this.authContext.OnsetKeyStoreStream());
            this.repos.setKeyStorePath(this.authContext.OnsetKeyStorePath());
            this.repos.setKeyStorePassphrase(this.authContext.OnsetKeyStorePassword());
            this.repos.setKeyStoreType(this.authContext.OnsetKeyStoreType());
        }
    }
}

