/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.crypt.jsse;

import com.sun.portal.proxylet.crypt.jsse.NetletJSSEAuthContext;
import com.sun.portal.proxylet.crypt.jsse.NetletKeyManager;
import com.sun.portal.proxylet.crypt.jsse.NetletTrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class NetletJSSEWrapper {
    private int port = -1;
    private String host = null;
    private SSLContext sslContext = null;
    private Socket tunnelSocket = null;
    private SSLSocket sslSocket = null;
    private NetletJSSEAuthContext authContext = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean handshake = false;
    private SSLSocketFactory sf = null;

    public NetletJSSEWrapper(NetletJSSEAuthContext authContext) throws Exception {
        this.authContext = authContext;
        this.init();
    }

    public void init() throws GeneralSecurityException, IOException {
        this.setupSSLContext();
        this.sf = this.sslContext.getSocketFactory();
    }

    public InputStream getInputStream() throws IOException {
        return this.sslSocket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.sslSocket.getOutputStream();
    }

    private void setupSSLContext() throws GeneralSecurityException, IOException {
        NetletTrustManager tm = new NetletTrustManager();
        NetletKeyManager km = new NetletKeyManager(this.authContext);
        KeyManager[] kmg = new KeyManager[]{km};
        TrustManager[] tmg = new TrustManager[]{tm};
        this.sslContext = SSLContext.getInstance("SSL");
        this.sslContext.init(kmg, tmg, null);
    }

    public SSLSocket connect(String host, int port, Socket ts) throws Exception {
        this.host = host;
        this.port = port;
        this.tunnelSocket = ts;
        SSLSocket socket = null;
        if (this.tunnelSocket != null) {
            socket = (SSLSocket)this.sf.createSocket(this.tunnelSocket, host, port, false);
        } else {
            socket = (SSLSocket)this.sf.createSocket(host, port);
        }
        return socket;
    }
}

