/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.jnlp;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.ValidateSession;
import com.sun.portal.proxylet.client.common.browser.BrowserType;
import com.sun.portal.proxylet.client.common.browser.MozillaEventHandler_JNLP;
import com.sun.portal.proxylet.client.common.browser.RegistryEventHandler;
import com.sun.portal.proxylet.client.common.server.Cookie;
import com.sun.portal.proxylet.client.common.ui.AbstractEventHandler;
import com.sun.portal.proxylet.client.common.ui.ProxyletUI;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class JnlpMain {
    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                System.out.println("Missing Arguments");
                System.out.println("Expects the following arguments GW_URL followed by SERVLET_URL");
                System.exit(1);
            }
            int i = 0;
            while (i < args.length) {
                System.out.println("arg[" + i + "] = " + args[i]);
                ++i;
            }
            String gwURL = args[0];
            String servletURL = args[1];
            String cookie = args[2];
            String browser = args[3];
            String bindPort = args[4];
            String bindIP = args[5];
            String gatewayHost = args[6];
            String gatewayPort = args[7];
            String gatewaymode = args[8];
            String rules = args[9];
            String debuglevel = args[10];
            String width = args[11];
            String height = args[12];
            String platformLoginURL = args[13];
            String sessionIdleTimeout = args[14];
            String propertyfile = args[15];
            if (debuglevel != null && debuglevel.equals("1")) {
                Log.setloglevel_JavaConsole(true);
            }
            Param.setGatewayUrl(gwURL);
            Param.setServletUrl(servletURL);
            Param.setRawCookie(cookie);
            Cookie c = new Cookie(cookie, Cookie.APPLETPARAM_COOKIE_FORMAT);
            Param.setCookie(c);
            Param.setBrowserType(BrowserType.getType(browser));
            Param.setBindPort(bindPort);
            Param.setBindIP(bindIP);
            Param.setGatewayHost(gatewayHost);
            Param.setGatewayPort(gatewayPort);
            Param.setGatewayMode(gatewaymode);
            Param.setRules(rules);
            Param.setVMVersion();
            Param.setVendor();
            Param.setSSLProvider();
            Param.setPacfileLoc();
            Param.setSource("App");
            Param.setWindowDimension(Integer.parseInt(width), Integer.parseInt(height));
            Param.setPlatformLoginURL(platformLoginURL);
            Param.setSessionIdleTimeout(sessionIdleTimeout);
            Param.setPropertyFile(propertyfile);
            if (Param.isProxyletRunning()) {
                try {
                    Param.sendMsgtoServlet("?command=setJWSLoaded", false, false, null);
                }
                catch (Exception e) {
                    Log.debugu("Unable to update session with JWS status " + e.getMessage());
                }
                Log.info(Param.getString("pinfo.7", "Detected another instance of proxylet on this machine \\n Quitting"));
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.exit(1);
            }
            if (Param.getRules() != null && Param.getRules().equals("$RULES")) {
                Param.loadPacContent();
            }
            try {
                Param.sendMsgtoServlet("?command=setJWSLoaded", true, false, null);
            }
            catch (Exception e) {
                Log.debugu("Unable to update session with JWS status " + e.getMessage());
                return;
            }
            try {
                Param.loadResourceBundle(true);
            }
            catch (Exception ignore) {
                Log.info(Param.getString("pexcp.1", "Failed to get resource bundle for locale. Defaulting to en_US"));
            }
            Param.cleanupPreviousMess();
            AbstractEventHandler abstractEventHandler = null;
            if (Param.getBrowserType().equals(BrowserType.IE)) {
                abstractEventHandler = new RegistryEventHandler();
            } else if (Param.getBrowserType().equals(BrowserType.Netscape)) {
                System.out.println("Mozilla eventhandler going to be called ");
                abstractEventHandler = new MozillaEventHandler_JNLP();
            }
            new JnlpMain().launchUI(abstractEventHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void launchUI(final AbstractEventHandler abstractEventHandler) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ProxyletUI.createAndShowGUI(abstractEventHandler);
                }
            });
        }
        catch (InterruptedException e) {
            Log.debug(Param.getString("perr.9", "ERR: Problem in displaying UI. Unknown error."));
            return;
        }
        catch (InvocationTargetException e) {
            Log.debug(Param.getString("perr.9", "ERR: Problem in displaying UI. Unknown error."));
            return;
        }
        abstractEventHandler.handleStart(true);
        ValidateSession validateSession = new ValidateSession(abstractEventHandler);
    }
}

