/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server.util;

import com.sun.portal.proxylet.client.common.server.util.Cleanable;
import com.sun.portal.proxylet.client.common.server.util.ReusableThread;
import java.util.Enumeration;
import java.util.Vector;

public class ThreadPool
implements Cleanable {
    private String name;
    private Vector pool = new Vector();

    public ThreadPool(String name) {
        this.name = name;
    }

    public synchronized ReusableThread get() {
        ReusableThread rt = null;
        if (this.pool.size() > 0) {
            rt = (ReusableThread)this.pool.firstElement();
            this.pool.removeElement(rt);
        }
        if (rt == null) {
            rt = new ReusableThread(this);
            rt.start();
        }
        return rt;
    }

    public synchronized void put(ReusableThread rt) {
        this.pool.addElement(rt);
    }

    public synchronized void clean() {
        long now = System.currentTimeMillis();
        Enumeration e = this.pool.elements();
        while (e.hasMoreElements()) {
            ReusableThread rt = (ReusableThread)e.nextElement();
            if (now - rt.getLastRunTime() < 30000L) continue;
            rt.terminate();
            this.pool.removeElement(rt);
        }
    }
}

