/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.server.Http;
import com.sun.portal.proxylet.client.common.server.ssl.AbstractSSLProvider;
import com.sun.portal.proxylet.client.common.server.ssl.SSLProviderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import sun.net.www.protocol.http.HttpURLConnection;

public class sslwrapper
extends Http {
    String host;
    int port;
    boolean proxy = false;
    AbstractSSLProvider gwConnection = null;

    sslwrapper(String host, int port) throws IOException {
        this(host, port, false);
    }

    sslwrapper(String host, int port, boolean isProxy) throws IOException {
        super(host, port);
        this.host = host;
        this.port = port;
        this.proxy = isProxy;
        try {
            if (Param.getGatewayMode().equals("secure")) {
                Socket tunnelSocket = null;
                if (isProxy) {
                    tunnelSocket = this.createTunnelSocket();
                }
                this.gwConnection = SSLProviderFactory.createFactory(Param.getSSLProvider());
                this.gwConnection.connect(Param.getGatewayHost(), Param.getGatewayPort(), tunnelSocket);
            }
        }
        catch (Exception e) {}
    }

    private Socket createTunnelSocket() throws IOException {
        String replyStr;
        byte[] b;
        Socket tunnel = null;
        try {
            tunnel = new Socket(Param.getClientProxyHost(), Param.getClientProxyPort());
        }
        catch (Exception e) {
            throw new IOException("Could not establish a connection with proxy");
        }
        OutputStream out = tunnel.getOutputStream();
        String msg = "CONNECT " + Param.getGatewayHost() + ":" + Param.getGatewayPort() + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (Exception ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        boolean error = false;
        InputStream in = tunnel.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (Exception ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (replyStr.toLowerCase().indexOf("200 connection established") == -1) {
            throw new IOException("Unable to tunnel through " + Param.getClientProxyHost() + ":" + Param.getClientProxyPort() + ".  Proxy returns \"" + replyStr + "\"");
        }
        return tunnel;
    }

    public InputStream getInputStream() {
        try {
            return this.gwConnection.getInputStream();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.gwConnection.getOutputStream();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public void close() {
        super.close();
        try {
            if (this.gwConnection != null) {
                this.gwConnection.close();
            }
        }
        catch (Exception e) {}
    }
}

