/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server.io;

import com.sun.portal.proxylet.client.common.server.io.InputObjectStream;
import java.io.IOException;

public class OutputObjectStream {
    protected InputObjectStream in = null;
    protected boolean connected = false;

    public OutputObjectStream(InputObjectStream in) throws IOException {
        this.connect(in);
    }

    public OutputObjectStream() {
    }

    public void connect(InputObjectStream in) throws IOException {
        if (this.connected) {
            throw new IOException("Output side already connected");
        }
        if (in.connected) {
            throw new IOException("Input side already connected");
        }
        this.in = in;
        in.closed = false;
        in.objects.removeAllElements();
        this.connected = true;
    }

    public void write(Object obj) throws IOException {
        this.in.append(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        if (this.in != null) {
            InputObjectStream inputObjectStream = this.in;
            synchronized (inputObjectStream) {
                this.in.notify();
            }
        }
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.done();
        }
    }
}

