/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArray {
    public byte[] bytes;
    public int offset = 0;

    public ByteArray() {
        this(512);
    }

    public ByteArray(int size) {
        this.bytes = new byte[size];
    }

    public ByteArray(String s) {
        this(s.length());
        this.append(s);
    }

    public ByteArray(byte[] b) {
        this(b.length);
        this.append(b);
    }

    public void append(byte ch) {
        if (this.offset == this.bytes.length) {
            byte[] tmpbytes = this.bytes;
            this.bytes = new byte[tmpbytes.length * 2];
            System.arraycopy(tmpbytes, 0, this.bytes, 0, this.offset);
        }
        this.bytes[this.offset++] = ch;
    }

    public void append(ByteArray b) {
        if (this.bytes.length - this.offset < b.length()) {
            byte[] tmpbytes = this.bytes;
            this.bytes = new byte[tmpbytes.length + b.length()];
            System.arraycopy(tmpbytes, 0, this.bytes, 0, this.offset);
        }
        System.arraycopy(b.bytes, 0, this.bytes, this.offset, b.length());
        this.offset += b.length();
    }

    public void append(byte[] b) {
        if (this.bytes.length - this.offset < b.length) {
            byte[] tmpbytes = this.bytes;
            this.bytes = new byte[tmpbytes.length + b.length];
            System.arraycopy(tmpbytes, 0, this.bytes, 0, this.offset);
        }
        System.arraycopy(b, 0, this.bytes, this.offset, b.length);
        this.offset += b.length;
    }

    public void append(String s) {
        this.append(s.getBytes());
    }

    public String toString() {
        return new String(this.bytes, 0, this.offset);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.bytes, 0, this.offset);
    }

    public byte get(int i) {
        return this.bytes[i];
    }

    public int length() {
        return this.offset;
    }

    public void erase() {
        this.offset = 0;
    }

    public void chop() {
        this.chop(1);
    }

    public void chop(int i) {
        this.offset -= i;
        if (this.offset < 0) {
            this.offset = 0;
        }
    }

    public static void main(String[] args) {
        ByteArray b = new ByteArray(3);
        b.append("foo");
        b.append("bar");
        b.append("joe");
        ByteArray tmp = new ByteArray(1);
        tmp.append("test");
        b.append(tmp);
    }
}

