/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.server.Handler;
import com.sun.portal.proxylet.client.common.server.HttpError;
import com.sun.portal.proxylet.client.common.server.util.ReusableThread;
import com.sun.portal.proxylet.client.common.server.util.ThreadPool;
import com.sun.portal.proxylet.client.common.ui.AbstractEventHandler;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class Server
implements Runnable {
    ServerSocket server = null;
    static ThreadPool pool;
    public static int running;
    protected AbstractEventHandler handler;

    public Server(int port) {
        try {
            String bindaddr = null;
            bindaddr = Param.getBindIP();
            if (bindaddr != null && bindaddr.length() > 0) {
                System.out.println(InetAddress.getByName(bindaddr));
                this.server = new ServerSocket(port, 10, InetAddress.getByName(bindaddr));
            } else {
                Log.info("Server starting on port " + port);
                this.server = new ServerSocket(port, 10);
            }
            pool = new ThreadPool("Proxylet Threads");
            running = 1;
        }
        catch (IOException e) {
            Log.debug(e.getMessage());
            System.exit(0);
        }
    }

    public Server(int port, AbstractEventHandler handler) {
        this(port);
        this.handler = handler;
    }

    public synchronized void suspend() {
        running = 0;
    }

    public synchronized void resume() {
        System.out.println("Resuming server operation " + running);
        running = 1;
    }

    public synchronized void stop() {
        try {
            this.server.close();
            running = -1;
        }
        catch (IOException e) {
            System.out.println("Msg " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread.currentThread().setName("Proxylet Server");
        running = 1;
        while (true) {
            Socket socket;
            try {
                if (this.server.isClosed()) {
                    System.out.println("Server closed...");
                    break;
                }
                socket = this.server.accept();
            }
            catch (IOException e) {
                Log.debug(e.getMessage());
                continue;
            }
            Server server = this;
            synchronized (server) {
                if (running == 1) {
                    Handler h = new Handler(socket, this);
                    ReusableThread rt = Server.getThread();
                    rt.setRunnable(h);
                } else {
                    this.error(socket, 503, "Proxylet proxy service is suspended.");
                }
            }
        }
    }

    void error(Socket socket, int code, String message) {
        try {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeBytes(new HttpError(code, message).toString());
            out.close();
            socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ReusableThread getThread() {
        return pool.get();
    }

    public int getLocalPort() {
        return this.server.getLocalPort();
    }

    public static void main(String[] args) {
        Server _s = new Server(8080);
        _s.run();
    }

    static {
        running = -1;
    }
}

