/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.server.Client;
import com.sun.portal.proxylet.client.common.server.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Request
extends Message {
    private String command = null;
    private String url = null;
    private String protocol = null;
    private byte[] data = null;
    private Client client = null;
    private Hashtable log;
    private Vector logHeaders;

    Request(Client c) {
        this.client = c;
    }

    void read(InputStream in) throws IOException {
        block5: {
            this.statusLine = this.readLine(in);
            System.out.println("statusLine = " + this.statusLine);
            if (this.statusLine == null || this.statusLine.length() == 0) {
                throw new IOException("Empty request");
            }
            StringTokenizer st = new StringTokenizer(this.statusLine);
            this.command = st.nextToken();
            this.url = st.nextToken();
            this.protocol = st.nextToken();
            this.readHeaders(in);
            if (!"POST".equals(this.command) && !"PUT".equals(this.command)) break block5;
            try {
                int n = Integer.parseInt(this.getHeaderField("Content-length"));
                this.data = new byte[n];
                int offset = 0;
                while (offset < this.data.length) {
                    n = in.read(this.data, offset, this.data.length - offset);
                    if (n < 0) {
                        throw new IOException("Not enough " + this.command + " data");
                    }
                    offset += n;
                }
            }
            catch (NumberFormatException e) {
                Log.debugu("Malformed or missing " + this.command + " Content-length");
            }
        }
    }

    public void write(OutputStream out) throws IOException {
        super.write(out);
        if (this.data != null) {
            out.write(this.data);
            out.flush();
        }
    }

    public String getRequest() {
        return this.statusLine;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        String url = this.getURL();
        String s = url.startsWith("http://") ? url.substring(7, url.indexOf(47, 7)) : url;
        int at = s.indexOf(64);
        if (at != -1) {
            s = s.substring(at + 1);
        }
        if (s.indexOf(58) != -1) {
            return s.substring(0, s.indexOf(58));
        }
        return s;
    }

    public int getPort() {
        int port;
        block3: {
            port = 80;
            String url = this.getURL();
            String s = url.startsWith("http://") ? url.substring(7, url.indexOf(47, 7)) : url;
            int at = s.indexOf(64);
            if (at != -1) {
                s = s.substring(at + 1);
            }
            if (s.indexOf(58) == -1) break block3;
            try {
                port = Integer.parseInt(s.substring(s.indexOf(58) + 1));
            }
            catch (NumberFormatException e) {
                Log.debugu("Invalid port in " + url);
            }
        }
        return port;
    }

    public String getData() {
        if (this.data == null) {
            return null;
        }
        return new String(this.data);
    }

    public String getPath() {
        String str = this.getURL();
        int pos = 0;
        int i = 0;
        while (i < 3) {
            pos = str.indexOf(47, pos);
            ++pos;
            ++i;
        }
        return str.substring(--pos);
    }

    public String getDocument() {
        String path = this.getPath();
        int n = path.lastIndexOf(47);
        if (n == path.length() - 1) {
            n = path.lastIndexOf(47, n - 1);
        }
        if (n < 0) {
            return "/";
        }
        return path.substring(n + 1);
    }

    public Client getClient() {
        return this.client;
    }

    public String getQueryString() {
        String path = this.getPath();
        int n = path.indexOf(63);
        if (n < 0) {
            return null;
        }
        return path.substring(n + 1);
    }

    public synchronized void addLogEntry(String header, String message) {
        if (this.log == null) {
            this.log = new Hashtable();
            this.logHeaders = new Vector();
        }
        Vector<String> v = (Vector<String>)this.log.get(header);
        if (this.log.get(header) == null) {
            v = new Vector<String>();
            this.log.put(header, v);
            this.logHeaders.addElement(header);
        }
        v.addElement(message);
    }

    public Enumeration getLogHeaders() {
        return this.logHeaders != null ? this.logHeaders.elements() : null;
    }

    public Enumeration getLogEntries(String header) {
        return this.log != null ? ((Vector)this.log.get(header)).elements() : null;
    }
}

