/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.SessionTimeoutException;
import com.sun.portal.proxylet.client.common.server.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.StringBufferInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Reply
extends Message {
    InputStream in = null;
    int statusCode = -1;

    public Reply() {
    }

    public Reply(InputStream in) {
        this.setContent(in);
    }

    public void setContent(InputStream in) {
        this.in = in;
    }

    public InputStream getContent() {
        return this.in;
    }

    void read() throws IOException, SessionTimeoutException {
        if (this.in != null) {
            this.read(this.in);
        }
    }

    void read(InputStream in) throws IOException, SessionTimeoutException {
        this.statusLine = this.readLine(in);
        if (this.statusLine == null || this.statusLine.length() == 0) {
            throw new IOException("Missing HTTP status line");
        }
        if (!this.statusLine.startsWith("HTTP")) {
            if (this.in != null) {
                String putback = new String(this.statusLine + "\n");
                this.in = new SequenceInputStream(new StringBufferInputStream(putback), in);
            }
            this.statusLine = "HTTP/1.0 200 OK";
            return;
        }
        this.readHeaders(in);
        int code = this.getStatusCode();
        switch (code) {
            case 302: {
                if (!this.containsHeaderField("Location")) break;
                String location = this.getHeaderField("Location");
                System.out.println("In reply " + location);
                if (location.indexOf(Param.getPlatformLoginURL()) == -1) break;
                throw new SessionTimeoutException("Session Expired. Please login again.");
            }
            case 204: 
            case 304: {
                int n;
                if (!this.containsHeaderField("Content-length")) break;
                Log.debugu("RFC 2068: Ignoring message-body from " + code + " response - " + this.getHeaderField("Server"));
                int contentLength = 0;
                try {
                    contentLength = Integer.parseInt(this.getHeaderField("Content-length"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                byte[] buffer = new byte[8192];
                while ((n = in.read(buffer, 0, buffer.length)) > 0) {
                }
                this.removeHeaderField("Content-length");
            }
        }
    }

    public boolean hasContent() {
        switch (this.getStatusCode()) {
            case 204: 
            case 304: {
                return false;
            }
        }
        return true;
    }

    public String getProtocol() {
        StringTokenizer st = new StringTokenizer(this.statusLine);
        String protocol = st.nextToken();
        return protocol;
    }

    public int getStatusCode() {
        block2: {
            if (this.statusCode != -1) break block2;
            StringTokenizer st = new StringTokenizer(this.statusLine);
            String protocol = st.nextToken();
            String status = st.nextToken();
            try {
                this.statusCode = Integer.parseInt(status);
            }
            catch (NumberFormatException e) {
                Log.debugu("Malformed or missing status code");
                this.statusCode = 0;
            }
        }
        return this.statusCode;
    }

    private Hashtable headerParser(String header) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        String type = this.getHeaderField(header);
        if (type == null) {
            return table;
        }
        StringTokenizer st = new StringTokenizer(type, ";");
        int count = 0;
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String token = st.nextToken();
            int i = (token = token.trim()).indexOf(61);
            if (i != -1) {
                name = token.substring(0, i);
                value = token.substring(i + 1);
            } else {
                name = token;
                value = "";
            }
            if (count == 0) {
                table.put(header, name);
            } else {
                table.put(name, value);
            }
            ++count;
        }
        return table;
    }

    public String getContentType() {
        Hashtable table = this.headerParser("Content-type");
        return (String)table.get("Content-type");
    }

    public String getBoundary() {
        Hashtable table = this.headerParser("Content-type");
        return (String)table.get("boundary");
    }

    public String getTransferEncoding() {
        Hashtable table = this.headerParser("Transfer-Encoding");
        return (String)table.get("Transfer-Encoding");
    }

    public int getChunkSize(InputStream in) throws IOException {
        String line = this.readLine(in);
        line = line.trim();
        int size = -1;
        try {
            size = Integer.valueOf(line, 16);
        }
        catch (NumberFormatException e) {
            Log.debug(e.getMessage());
        }
        return size;
    }

    public void getChunkedFooter(InputStream in) throws IOException {
        int i;
        String line;
        while ((line = this.readLine(in)) != null && (i = line.indexOf(58)) != -1) {
        }
    }

    public void setStatusLine(String line) {
        this.statusLine = line;
    }

    public static Reply createRedirect(String url) {
        Reply r = new Reply();
        r.setStatusLine("HTTP/1.0 302 Moved Temporarily");
        r.setHeaderField("Location", url);
        return r;
    }
}

