/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.server.Key;
import com.sun.portal.proxylet.client.common.server.io.ByteArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Message {
    private Hashtable headers = new Hashtable(33);
    String statusLine = null;
    private static final byte[] COLON_SPACE = ": ".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();

    public String readLine(InputStream in) throws IOException {
        int ch;
        char[] buf = new char[128];
        int offset = 0;
        while ((ch = in.read()) != -1 && ch != 10) {
            if (ch == 13) {
                int tmpch = in.read();
                if (tmpch == 10) break;
                if (!(in instanceof PushbackInputStream)) {
                    in = new PushbackInputStream(in);
                }
                ((PushbackInputStream)in).unread(tmpch);
                break;
            }
            if (offset == buf.length) {
                char[] tmpbuf = buf;
                buf = new char[tmpbuf.length * 2];
                System.arraycopy(tmpbuf, 0, buf, 0, offset);
            }
            buf[offset++] = (char)ch;
        }
        return String.copyValueOf(buf, 0, offset);
    }

    void readHeaders(InputStream in) throws IOException {
        String s;
        Key key = null;
        while ((s = this.readLine(in)) != null) {
            int i = s.indexOf(58);
            if (i == -1) {
                if (s.length() == 0) break;
                if (key == null || !s.startsWith(" ") && !s.startsWith("\t")) continue;
                int index = this.getHeaderValueCount(key.toString());
                Vector v = (Vector)this.headers.get(key);
                v.setElementAt(v.elementAt(--index) + "\n" + s, index);
                continue;
            }
            key = new Key(s.substring(0, i));
            Vector v = this.headers.containsKey(key) ? (Vector)this.headers.get(key) : new Vector();
            v.addElement(s.substring(i + 1).trim());
            this.headers.put(key, v);
        }
    }

    public int headerCount() {
        return this.headers.size();
    }

    public void setStatusLine(String l) {
        this.statusLine = l;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public int getHeaderValueCount(String name) {
        Vector v = (Vector)this.headers.get(new Key(name));
        return v.size();
    }

    public String getHeaderField(String name) {
        return this.getHeaderField(name, 0);
    }

    public String getHeaderField(String name, int index) {
        Vector v = (Vector)this.headers.get(new Key(name));
        if (v == null) {
            return null;
        }
        return (String)v.elementAt(index);
    }

    public void setHeaderField(String name, String value) {
        this.setHeaderField(name, value, 0);
    }

    public void setHeaderField(String name, String value, int index) {
        Vector v;
        Key key = new Key(name);
        if (this.headers.containsKey(key)) {
            v = (Vector)this.headers.get(key);
        } else {
            v = new Vector();
            if (index == 0) {
                v.addElement("");
            }
            this.headers.put(key, v);
        }
        v.setElementAt(value, index);
    }

    public void setHeaderField(String name, int value) {
        this.setHeaderField(name, value, 0);
    }

    public void setHeaderField(String name, int value, int index) {
        this.setHeaderField(name, new Integer(value).toString(), index);
    }

    public void setHeaderFields(String name, String value) {
        Key key = new Key(name);
        Vector v = (Vector)this.headers.get(key);
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                v.setElementAt(value, i);
                ++i;
            }
        }
    }

    public void appendHeaderField(String name, String value) {
        this.appendHeaderField(name, value, 0);
    }

    public void appendHeaderField(String name, String value, int index) {
        this.setHeaderField(name, this.getHeaderField(name, index) + value, index);
    }

    public void removeHeaderField(String name) {
        this.headers.remove(new Key(name));
    }

    public boolean containsHeaderField(String name) {
        return this.headers.containsKey(new Key(name));
    }

    public Enumeration getHeaders() {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.headers.keys();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement().toString());
        }
        return v.elements();
    }

    private ByteArray toByteArray(byte[] sep) {
        ByteArray buf = new ByteArray();
        int i = 0;
        buf.append(this.statusLine);
        buf.append(sep);
        Enumeration e = this.headers.keys();
        while (e.hasMoreElements()) {
            Key key = (Key)e.nextElement();
            Vector v = (Vector)this.headers.get(key);
            i = 0;
            while (i < v.size()) {
                buf.append(key.toString());
                buf.append(COLON_SPACE);
                buf.append(v.elementAt(i).toString());
                buf.append(sep);
                ++i;
            }
        }
        buf.append(sep);
        return buf;
    }

    private ByteArray toByteArray() {
        return this.toByteArray(CRLF);
    }

    private ByteArray toByteArray(String sep) {
        return this.toByteArray(sep.getBytes());
    }

    public String toString() {
        return this.toByteArray().toString();
    }

    public String toString(String sep) {
        return this.toByteArray(sep).toString();
    }

    public void write(OutputStream out) throws IOException {
        this.toByteArray().writeTo(out);
        out.flush();
    }
}

