/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.SessionTimeoutException;
import com.sun.portal.proxylet.client.common.server.HttpConnection;
import com.sun.portal.proxylet.client.common.server.Reply;
import com.sun.portal.proxylet.client.common.server.Request;
import com.sun.portal.proxylet.client.common.server.RetryRequestException;
import com.sun.portal.proxylet.client.common.server.ssl.AbstractSSLProvider;
import com.sun.portal.proxylet.client.common.server.ssl.SSLProviderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Https
extends HttpConnection {
    boolean proxy = false;
    AbstractSSLProvider gwConnection = null;

    Https(String host, int port) throws IOException {
        super(host, port);
    }

    Https(String host, int port, boolean isProxy) throws IOException {
        this(host, port);
        this.proxy = isProxy;
    }

    public void sendRequest(Request request) throws IOException, RetryRequestException {
        if (this.proxy) {
            super.sendRequest(request);
        }
        try {
            this.sendSpecialHandshakeRequest(request);
        }
        catch (Exception e) {}
    }

    public Reply recvReply(Request request) throws IOException, RetryRequestException, SessionTimeoutException {
        Reply reply = new Reply(this.getInputStream());
        if (this.proxy) {
            reply.read();
        } else {
            reply.statusLine = "HTTP/1.0 200 Connection established";
            reply.setHeaderField("Proxy-agent", "Proxylet");
        }
        return reply;
    }

    private int sendSpecialHandshakeRequest(Request request) throws Exception {
        int result = -1;
        OutputStream out = this.getOutputStream();
        InputStream in = this.getInputStream();
        this.gwConnection = SSLProviderFactory.createFactory(Param.getSSLProvider());
        System.out.println(Param.getSSLProvider());
        this.gwConnection.connect(Param.getGatewayHost(), Param.getGatewayPort(), this.getSocket());
        InputStream gatewayIn = this.gwConnection.getInputStream();
        OutputStream gatewayOut = this.gwConnection.getOutputStream();
        String spcConnectMsg = Https.getConnectString(request.getHost(), request.getPort());
        Log.debugu("SPC CONNECT MSG " + spcConnectMsg);
        if (gatewayOut == null) {
            System.out.println("GATEWAYOUT IS NULL");
        }
        gatewayOut.write(spcConnectMsg.getBytes());
        System.out.println("special connect message sent to gateway");
        gatewayOut.flush();
        String resp = this.readResponse(gatewayIn);
        Log.debugu("SPC CONNECT RSP " + resp);
        if (resp.indexOf("200") >= 0) {
            String ack = "FP1.0\r\n\r\n";
            out.write(ack.getBytes());
            resp = this.readResponse(in);
            Log.debugu("Received FP1.0 RESP " + resp);
        }
        return result;
    }

    private String readResponse(InputStream in) throws IOException {
        byte[] reply = new byte[100];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        reply[replyLen++] = 0;
        return new String(reply);
    }

    public static String getConnectString(String host, int port) {
        String reqHeader = "PP1.0CONNECT " + host + ":" + port + "\n" + Param.getCookie().getValue() + "\n";
        return reqHeader;
    }

    public void close() {
        super.close();
        try {
            this.gwConnection.close();
        }
        catch (Exception e) {}
    }
}

