/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.server.Reply;

class HttpError {
    StringBuffer content = null;
    Reply reply = null;

    HttpError(int code, String message) {
        String error;
        switch (code) {
            case 400: {
                error = Param.getString("perr.400", "Bad Request");
                break;
            }
            case 403: {
                error = Param.getString("perr.403", "Forbidden");
                break;
            }
            case 404: {
                error = Param.getString("perr.404", "Not Found");
                break;
            }
            case 503: {
                error = Param.getString("perr.503", "Gateway Service Unavailable");
                break;
            }
            case 100: {
                error = Param.getString("perr.100", "Session expired.");
                break;
            }
            default: {
                error = "Error";
            }
        }
        this.reply = new Reply();
        this.reply.statusLine = "HTTP/1.0 " + code + " " + error;
        this.reply.setHeaderField("Content-type", "text/html");
        this.reply.setHeaderField("Server", "Proxylet/1.0");
        this.content = new StringBuffer();
        this.content.append(HttpError.head(error));
        this.content.append(message);
        this.content.append(HttpError.tail());
        this.reply.setHeaderField("Content-Length", this.content.toString().length());
    }

    static String head(String title) {
        StringBuffer html = new StringBuffer();
        html.append("<html>\n");
        html.append("<title>" + title + "</title><body>\n");
        html.append("<h1>" + title + "</h1>\n");
        html.append("<hr size=4 noshade>\n");
        return html.toString();
    }

    static String tail() {
        StringBuffer html = new StringBuffer();
        html.append("<p><hr size=4 noshade>\n");
        html.append("</body>\n");
        html.append("</html>\n");
        return html.toString();
    }

    static String getGenerated() {
        StringBuffer buf = new StringBuffer();
        buf.append("<a href=\"http://www.sun.com\">");
        buf.append("<i><img border=0 alt=\"\" src=\"http://www.sun.com/images/error.jpg\">");
        buf.append("Generated by Proxylet 1.0</a></i>");
        buf.append("</a>\n");
        return buf.toString();
    }

    Reply getReply() {
        return this.reply;
    }

    String getContent() {
        if (this.content == null) {
            return null;
        }
        return this.content.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.reply != null) {
            buf.append(this.reply.toString());
        }
        if (this.content != null) {
            buf.append(this.content.toString());
        }
        return buf.toString();
    }
}

