/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.SessionTimeoutException;
import com.sun.portal.proxylet.client.common.server.HttpConnection;
import com.sun.portal.proxylet.client.common.server.Reply;
import com.sun.portal.proxylet.client.common.server.Request;
import com.sun.portal.proxylet.client.common.server.RetryRequestException;
import com.sun.portal.proxylet.client.common.server.sslwrapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Http
extends HttpConnection {
    static final boolean DEBUG = true;
    static final int MAX_PENDING_REQUESTS = 1;
    static Hashtable cache = new Hashtable(33);
    private static Object httpLock = new Object();
    String host;
    int port;
    boolean proxy = false;
    boolean persistent = false;
    boolean closed = false;
    long idle = 0L;
    Vector queue = new Vector();

    Http(String host, int port) throws IOException {
        this(host, port, false);
    }

    Http(String host, int port, boolean isProxy) throws IOException {
        super(host, port);
        this.host = host;
        this.port = port;
        this.proxy = isProxy;
    }

    public synchronized void sendRequest(Request request) throws IOException, RetryRequestException {
        this.queue.addElement(request);
        try {
            this.send(request);
        }
        catch (IOException e) {
            if (this.persistent) {
                this.persistent = false;
                Log.debugu("RETRY SEND " + request.getURL());
                throw new RetryRequestException();
            }
            throw e;
        }
    }

    public synchronized Reply recvReply(Request request) throws IOException, RetryRequestException, SessionTimeoutException {
        while (this.queue.firstElement() != request) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.closed) {
            Log.debugu("RETRY CLOSED " + request.getURL());
            throw new RetryRequestException();
        }
        try {
            return this.recv();
        }
        catch (IOException e) {
            if (this.persistent) {
                this.persistent = false;
                Log.debugu("RETRY RECV " + request.getURL());
                throw new RetryRequestException();
            }
            throw e;
        }
    }

    public void reallyClose() {
        this.persistent = false;
        Log.debugu("REALLY CLOSE " + this);
        this.close();
    }

    public synchronized void close() {
        if (this.persistent) {
            this.idle = System.currentTimeMillis();
        } else {
            Http.cacheRemove(this.host, this.port, this);
            super.close();
            this.closed = true;
        }
        if (this.queue.size() > 0) {
            this.queue.removeElementAt(0);
            if (this.persistent) {
                Log.debugu("DONE " + this);
            } else {
                Log.debugu("CLOSE " + this);
            }
            this.notify();
        }
    }

    private void send(Request request) throws IOException {
        Log.debugu("SEND " + request.getURL());
        request.removeHeaderField("fProxy-Connection");
        request.setHeaderField("Connection", "open");
        String _iplanetCookie = "; " + Param.getCookie().getName() + "=" + Param.getCookie().getValue();
        if (request.getHeaderField("Cookie") == null) {
            request.setHeaderField("Cookie", _iplanetCookie);
        } else {
            request.appendHeaderField("Cookie", _iplanetCookie);
        }
        request.setHeaderField("PS-Proxylet", "RT-Proxylet=true");
        String _gwURL = "";
        if (Param.getUseClientProxy() && !Param.getGatewayMode().equalsIgnoreCase("secure")) {
            _gwURL = "http://" + Param.getGatewayHost() + ":" + Param.getGatewayPort();
        }
        StringBuffer head = new StringBuffer();
        head.append(request.getCommand());
        head.append(" ");
        head.append(_gwURL);
        head.append("/");
        head.append(request.getURL());
        head.append(" ");
        head.append(request.getProtocol());
        request.statusLine = head.toString();
        if (!request.containsHeaderField("Host")) {
            request.setHeaderField("Host", request.getHost());
        }
        request.write(this.getOutputStream());
    }

    private Reply recv() throws IOException, SessionTimeoutException {
        Reply reply = new Reply(this.getInputStream());
        reply.read();
        String conn = reply.getHeaderField("Connection");
        Log.debugu("RECV " + reply.statusLine);
        this.persistent = reply.containsHeaderField("Connection") && reply.getHeaderField("Connection").equals("close") ? false : reply.getProtocol().equals("HTTP/1.1");
        if (reply.getStatusCode() == 100) {
            reply = this.recv();
        }
        return reply;
    }

    private boolean isBusy() {
        return this.queue.size() >= 1;
    }

    private boolean isPersistent() {
        return this.persistent;
    }

    private static String cacheKey(String host, int port) {
        return host.toLowerCase() + ":" + port;
    }

    private static Vector cacheLookup(String host, int port) {
        Vector v = (Vector)cache.get(Http.cacheKey(host, port));
        return v;
    }

    private static boolean cacheContains(Http http) {
        Vector v = (Vector)cache.get(Http.cacheKey(http.host, http.port));
        return v != null ? v.contains(http) : false;
    }

    private static void cacheInsert(String host, int port, Http http) {
        String key = Http.cacheKey(host, port);
        Vector<Http> v = (Vector<Http>)cache.get(key);
        if (v == null) {
            v = new Vector<Http>();
        }
        v.addElement(http);
        cache.put(key, v);
    }

    private static void cacheRemove(String host, int port, Http http) {
        Vector v = (Vector)cache.get(Http.cacheKey(host, port));
        if (v != null) {
            v.removeElement(http);
            if (v.isEmpty()) {
                cache.remove(Http.cacheKey(host, port));
            }
        }
    }

    private static void cacheClean() {
        long now = System.currentTimeMillis();
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            Vector v = (Vector)cache.get(e.nextElement());
            int i = 0;
            while (i < v.size()) {
                Http http = (Http)v.elementAt(i);
                if (http.idle > 0L && now - http.idle > 30000L) {
                    Log.debugu("IDLE " + http);
                    http.persistent = false;
                    http.close();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Http open(String host, int port, boolean isProxy) throws IOException {
        Http http = null;
        Object object = httpLock;
        synchronized (object) {
            Vector v = Http.cacheLookup(host, port);
            if (v != null) {
                int i = 0;
                while (i < v.size()) {
                    Http pick = (Http)v.elementAt(i);
                    if (pick.isPersistent() && !pick.isBusy()) {
                        http = pick;
                        break;
                    }
                    ++i;
                }
                if (http != null) {
                    http.idle = 0L;
                    Log.debugu("REUSE " + http);
                }
            }
        }
        if (http == null) {
            Log.debugu("OPENING " + host + ":" + port);
            http = Param.getGatewayMode().equals("secure") ? new sslwrapper(host, port, isProxy) : new Http(host, port, isProxy);
            Log.debugu("OPENED " + http);
            Http.cacheInsert(host, port, http);
        }
        return http;
    }

    static Http open(String host, int port) throws IOException {
        return Http.open(host, port, false);
    }

    static Enumeration enumerate() {
        Vector list = new Vector();
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            Vector v = (Vector)cache.get(e.nextElement());
            int i = 0;
            while (i < v.size()) {
                list.addElement(v.elementAt(i));
                ++i;
            }
        }
        return list.elements();
    }

    static synchronized void clean() {
        Http.cacheClean();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("SERVER ");
        buf.append(super.toString());
        if (this.isPersistent()) {
            buf.append(" - ");
            if (this.queue.size() > 0) {
                buf.append(this.queue.size());
                buf.append(" pending");
            } else {
                buf.append("idle " + (double)(System.currentTimeMillis() - this.idle) / 1000.0 + " sec");
            }
        }
        return buf.toString();
    }
}

