/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.server;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.SessionTimeoutException;
import com.sun.portal.proxylet.client.common.server.Client;
import com.sun.portal.proxylet.client.common.server.Cookie;
import com.sun.portal.proxylet.client.common.server.Copy;
import com.sun.portal.proxylet.client.common.server.Http;
import com.sun.portal.proxylet.client.common.server.HttpError;
import com.sun.portal.proxylet.client.common.server.HttpRelay;
import com.sun.portal.proxylet.client.common.server.Https;
import com.sun.portal.proxylet.client.common.server.Reply;
import com.sun.portal.proxylet.client.common.server.Request;
import com.sun.portal.proxylet.client.common.server.RetryRequestException;
import com.sun.portal.proxylet.client.common.server.Server;
import com.sun.portal.proxylet.client.common.server.io.ByteArray;
import com.sun.portal.proxylet.client.common.server.io.InputObjectStream;
import com.sun.portal.proxylet.client.common.server.util.ReusableThread;
import com.sun.portal.proxylet.client.common.ui.ProxyletUI;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.GZIPInputStream;

class Handler
implements Runnable {
    static final boolean DEBUG = true;
    Client client = null;
    Socket socket = null;
    Server server = null;
    Request request = null;
    Reply reply = null;
    HttpRelay http = null;
    int currentLength = -1;
    int contentLength = -1;
    long idle = 0L;
    double bytesPerSecond = 0.0;

    Handler(Socket socket, Server server) {
        this.socket = socket;
        this.server = server;
    }

    synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        if (this.http != null) {
            this.http.close();
            this.http = null;
        }
    }

    void flush() {
        block2: {
            if (this.client == null) break block2;
            try {
                this.client.getOutputStream().flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean keepAlive = false;
        Exception reason = null;
        Thread.currentThread().setName("Handler(" + this.socket.getInetAddress().getHostAddress() + ")");
        try {
            this.client = new Client(this.socket);
            this.client.setTimeout(new Integer("60000"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            do {
                this.request = null;
                this.reply = null;
                this.idle = System.currentTimeMillis();
                try {
                    this.request = this.client.read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
                this.idle = 0L;
                try {
                    keepAlive = this.processRequest();
                }
                catch (IOException ioe) {
                    reason = ioe;
                    keepAlive = false;
                }
                catch (SessionTimeoutException se) {
                    reason = se;
                    keepAlive = false;
                }
            } while (keepAlive);
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            throw throwable;
        }
        if (reason != null && reason.getMessage().indexOf("Broken pipe") == -1) {
            if (this.client != null && this.request != null) {
                this.error(this.client.getOutputStream(), reason, this.request);
            }
            if (reason instanceof SessionTimeoutException) {
                System.out.println("reason instance of SessionTimeoutException");
                this.close();
                ProxyletUI.setText(Param.getString("perr.100", "Your session has timed out."));
                ProxyletUI.setText(Param.getString("pinfo.22", "Session expired. Proxylet Console will close in few seconds..."));
                ProxyletUI.progressIndicator.setString("");
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.server.handler.handleStop();
                return;
            }
        }
        this.close();
    }

    boolean wantKeepAlive() {
        return false;
    }

    boolean processRequest() throws IOException, SessionTimeoutException {
        boolean keepAlive = false;
        while (this.reply == null) {
            String url;
            boolean secure = false;
            boolean uncompress = false;
            System.out.println("Request URL " + this.request.getURL());
            if (this.request.getCommand().equals("CONNECT")) {
                secure = true;
            } else {
                if (this.request.getCommand().equals("CLOSESOCKET")) {
                    this.server.stop();
                    return false;
                }
                if (this.request.getURL().indexOf("ASSIGNCOOKIE") != -1) {
                    String data = this.request.getData();
                    System.out.println("Data " + data);
                    Param.setRawCookie(data);
                    Cookie c = new Cookie(data, Cookie.APPLETPARAM_COOKIE_FORMAT);
                    Param.setCookie(c);
                    return false;
                }
                if (this.request.getURL().indexOf("PROXYLETCLOSE") != -1) {
                    this.server.handler.handleStop();
                    return false;
                }
                if (this.request.getURL().startsWith("https://")) {
                    Log.debugu("Netscape keep-alive bug: " + this.request.getURL());
                    return false;
                }
                if (!this.request.getURL().startsWith("http://") && !Param.getSource().equals("DownloadMgr")) {
                    Log.debugu("Unknown URL   -: " + this.request.getURL());
                    return false;
                }
            }
            if (this.wantKeepAlive()) {
                keepAlive = this.request.containsHeaderField("Proxy-Connection") && this.request.getHeaderField("Proxy-Connection").equals("Keep-Alive");
            }
            this.http = secure ? this.createHttpsRelay() : this.createHttpRelay();
            try {
                this.http.sendRequest(this.request);
                if (this.http instanceof Http) {
                    ((Http)this.http).setTimeout(new Integer("90000"));
                }
                this.reply = this.http.recvReply(this.request);
            }
            catch (SessionTimeoutException se) {
                throw se;
            }
            catch (RetryRequestException e) {
                this.http.close();
                this.http = null;
                continue;
            }
            if (this.reply.headerCount() == 0 && ((url = this.request.getURL()).endsWith("/") || url.endsWith(".html") || url.endsWith(".htm"))) {
                this.reply.setHeaderField("Content-type", "text/html");
            }
            this.reply.removeHeaderField("Proxy-Connection");
            if (keepAlive && this.reply.containsHeaderField("Content-length")) {
                this.reply.setHeaderField("Proxy-Connection", "Keep-Alive");
            } else {
                keepAlive = false;
            }
            this.currentLength = -1;
            this.contentLength = -1;
            try {
                this.contentLength = Integer.parseInt(this.reply.getHeaderField("Content-length"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (secure) {
                Https https = (Https)this.http;
                int timeout = new Integer("90000");
                this.client.write(this.reply);
                try {
                    this.client.setTimeout(timeout);
                    https.setTimeout(timeout);
                    Copy cp = new Copy(this.client.getInputStream(), https.getOutputStream());
                    ReusableThread thread = Server.getThread();
                    thread.setRunnable(cp);
                    this.flushCopy(https.getInputStream(), this.client.getOutputStream(), -1, false);
                    this.client.close();
                }
                catch (InterruptedIOException iioe) {}
            } else if (this.reply.hasContent()) {
                try {
                    this.processContent(uncompress);
                }
                catch (IOException e) {
                    if (this.http instanceof Http) {
                        ((Http)this.http).reallyClose();
                    } else {
                        this.http.close();
                    }
                    this.http = null;
                    this.client.close();
                    this.client = null;
                    throw e;
                }
                if (this.contentLength == 0) {
                    this.client.close();
                }
            } else {
                this.client.write(this.reply);
            }
            this.http.close();
        }
        return keepAlive;
    }

    boolean useHttpsProxy() {
        return Param.getUseClientProxy();
    }

    boolean useHttpProxy() {
        return Param.getUseClientProxy();
    }

    HttpRelay createHttpsRelay() throws IOException {
        Https http = this.useHttpsProxy() ? new Https(Param.getClientProxyHost(), Param.getClientProxyPort(), true) : new Https(Param.getGatewayHost(), Param.getGatewayPort());
        return http;
    }

    HttpRelay createHttpRelay() throws IOException {
        Http http;
        if (this.useHttpProxy()) {
            Log.debugu("Using http proxy " + Param.getClientProxyHost());
            http = Http.open(Param.getClientProxyHost(), Param.getClientProxyPort(), true);
        } else {
            Log.debugu("No Proxy configured");
            http = Http.open(Param.getGatewayHost(), Param.getGatewayPort());
        }
        return http;
    }

    InputStream readChunkedTransfer(InputStream in) throws IOException {
        ByteArrayOutputStream chunks = new ByteArrayOutputStream(8192);
        int size = 0;
        this.contentLength = 0;
        while ((size = this.reply.getChunkSize(in)) > 0) {
            this.contentLength += size;
            this.copy(in, chunks, size, true);
            this.reply.readLine(in);
        }
        this.reply.getChunkedFooter(in);
        this.reply.removeHeaderField("Transfer-Encoding");
        this.reply.setHeaderField("Content-length", this.contentLength);
        return new ByteArrayInputStream(chunks.toByteArray());
    }

    void processContent(boolean uncompress) throws IOException {
        InputStream in;
        boolean chunked = false;
        if (this.reply.containsHeaderField("Transfer-Encoding") && this.reply.getTransferEncoding().equals("chunked")) {
            in = this.readChunkedTransfer(this.reply.getContent());
            chunked = true;
        } else {
            in = this.reply.getContent();
        }
        if (in == null) {
            return;
        }
        if (uncompress) {
            in = new GZIPInputStream(in);
        }
        this.client.write(this.reply);
        this.copy(in, this.client.getOutputStream(), this.contentLength, true);
    }

    int getTotalBytes() {
        return this.contentLength > 0 ? this.contentLength : 0;
    }

    int getCurrentBytes() {
        return this.currentLength > 0 ? this.currentLength : 0;
    }

    void error(OutputStream out, Exception e, Request r) {
        int errcode = 400;
        StringBuffer buf = new StringBuffer();
        buf.append("While trying to retrieve the URL: <a href=\"" + r.getURL() + "\">" + r.getURL() + "</a>\r\n");
        buf.append("<p>\r\nThe following error was encountered:\r\n<p>\r\n");
        buf.append("<ul><li>" + e.toString() + "</ul>\r\n");
        if (e.getMessage().indexOf("Connection refused") != -1) {
            errcode = 503;
        }
        if (e instanceof SessionTimeoutException) {
            System.out.println("e instance of SessionTimeoutException inside error");
            errcode = 100;
        }
        String s = new HttpError(errcode, buf.toString()).toString();
        try {
            out.write(s.getBytes(), 0, s.length());
            out.flush();
        }
        catch (Exception ex) {
            System.out.println("Error while printing error " + ex.getMessage());
        }
    }

    void copy(InputStream in, OutputStream out, int length, boolean monitored) throws IOException {
        if (length == 0) {
            return;
        }
        byte[] buffer = new byte[8192];
        long start = System.currentTimeMillis();
        long now = 0L;
        long then = start;
        this.bytesPerSecond = 0.0;
        if (monitored) {
            this.currentLength = 0;
        }
        while (true) {
            int n = length > 0 ? Math.min(length, buffer.length) : buffer.length;
            if ((n = in.read(buffer, 0, n)) < 0) break;
            out.write(buffer, 0, n);
            if (monitored) {
                this.currentLength += n;
            }
            now = System.currentTimeMillis();
            this.bytesPerSecond = (double)this.currentLength / ((double)(now - start) / 1000.0);
            if (now - then > 1000L) {
                out.flush();
            }
            if (length != -1 && (length -= n) == 0) break;
            then = now;
        }
        out.flush();
        Log.debugu(this.currentLength + " bytes processed in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds " + (int)this.bytesPerSecond / 1024 + " kB/s");
    }

    void flushCopy(InputStream in, OutputStream out, int length, boolean monitored) throws IOException {
        int n;
        if (length == 0) {
            return;
        }
        byte[] buffer = new byte[8192];
        long start = System.currentTimeMillis();
        this.bytesPerSecond = 0.0;
        if (monitored) {
            this.currentLength = 0;
        }
        do {
            n = length > 0 ? Math.min(length, buffer.length) : buffer.length;
            if ((n = in.read(buffer, 0, n)) < 0) break;
            out.write(buffer, 0, n);
            out.flush();
            this.bytesPerSecond = (double)this.currentLength / ((double)(System.currentTimeMillis() - start) / 1000.0);
        } while (length == -1 || (length -= n) != 0);
        out.flush();
        Log.debugu(this.currentLength + " bytes processed in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds " + (int)this.bytesPerSecond / 1024 + " kB/s");
    }

    void copy(InputObjectStream in, OutputStream out, boolean monitored) throws IOException {
        Object obj;
        long start = System.currentTimeMillis();
        long now = 0L;
        long then = start;
        this.bytesPerSecond = 0.0;
        if (monitored) {
            this.currentLength = 0;
        }
        while ((obj = in.read()) != null) {
            if (obj instanceof ByteArray) {
                ByteArray bytes = (ByteArray)obj;
                bytes.writeTo(out);
                this.currentLength += bytes.length();
            } else if (obj instanceof Byte) {
                Byte b = (Byte)obj;
                out.write(b.byteValue());
                ++this.currentLength;
            } else {
                Log.debugu("Unknown object: " + obj.toString());
            }
            now = System.currentTimeMillis();
            this.bytesPerSecond = (double)this.currentLength / ((double)(now - start) / 1000.0);
            if (now - then > 1000L) {
                out.flush();
            }
            then = now;
        }
        out.flush();
        Log.debugu(this.currentLength + " bytes filtered in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds " + (int)this.bytesPerSecond / 1024 + " kB/s");
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("CLIENT ");
        str.append(this.socket.getInetAddress().getHostAddress());
        str.append(":");
        str.append(this.socket.getPort());
        str.append(" - ");
        if (this.request == null) {
            str.append("idle " + (double)(System.currentTimeMillis() - this.idle) / 1000.0 + " sec");
        } else {
            if (this.reply != null && this.currentLength > 0) {
                str.append("(");
                str.append(this.currentLength);
                if (this.contentLength > 0) {
                    str.append("/");
                    str.append(this.contentLength);
                }
                str.append(" ");
                str.append((int)this.bytesPerSecond / 1024 + " kB/s");
                str.append(") ");
            }
            str.append(this.request.getURL());
        }
        return str.toString();
    }
}

