/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.browser;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.SessionTimeoutException;
import com.sun.portal.proxylet.client.common.browser.BrowserHelper;
import com.sun.portal.proxylet.client.common.server.Server;
import com.sun.portal.proxylet.client.common.ui.AbstractEventHandler;
import com.sun.portal.proxylet.client.common.ui.ProxyletUI;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import javax.swing.JFrame;

public class MozillaEventHandler_JNLP
extends AbstractEventHandler {
    private final String READ_PROXY_SETTINGS_COMMAND = "read_proxy_settings_command";
    private final String SET_PROXY_SETTINGS_COMMAND = "set_proxy_settings_command";
    private final String RESTORE_PROXY_SETTINGS_COMMAND = "restore_proxy_settings_command";
    private final String GET_PROXY_MODE_COMMAND = "get_proxy_mode_command";
    private final String GET_PROXY_MODE_INFO_COMMAND = "get_proxy_mode_info_command";
    private final String GET_AUTO_CONFIG_URL_COMMAND = "get_auto_config_url_command";
    private final String INVOKE_HELP_COMMAND = "invoke_help_command";
    private String configLocation;
    private Server connection;
    boolean stopped = false;
    private final String APPLET_MESSAGE_PREFIX = "pp1.0:";
    private final String CLOSE_MESSAGE = "close";

    public void handleStart(boolean firstTime) {
        ProxyletUI.setCursor(Cursor.getPredefinedCursor(3));
        ProxyletUI.progressIndicator.setString("");
        ProxyletUI.stopProxyletB.setEnabled(false);
        ProxyletUI.startProxyletB.setEnabled(false);
        Log.info(Param.getString("pinf.3", "Please wait while Proxylet configures your browser"));
        try {
            ProxyletUI.progressIndicator.setValue(10);
            ProxyletUI.progressIndicator.setString("10%");
            if (!firstTime) {
                try {
                    Param.loadResourceBundle(true);
                }
                catch (Exception ignore) {
                    Log.info(Param.getString("pexcp.1", "Failed to get resource bundle for locale. Defaulting to en_US"));
                }
            }
            ProxyletUI.progressIndicator.setValue(30);
            ProxyletUI.progressIndicator.setString("30%");
            this.readProxySetting();
            String proxyMode = this.getProxyMode();
            String proxyModeInfo = this.getProxyModeInfo();
            String autoConfigURL = this.getAutoConfigURL();
            Log.debugu("Connection Type" + proxyMode);
            Log.debugu("Proxy Info " + proxyModeInfo);
            Log.debugu("AutoConfig URL " + autoConfigURL);
            ProxyletUI.progressIndicator.setValue(50);
            ProxyletUI.progressIndicator.setString("50%");
            long proxyTypeProxy = 1L;
            long proxyTypeAutoProxyUrl = 2L;
            long proxyTypeAutoDetect = 4L;
            this.configLocation = BrowserHelper.processProxyInfo(proxyTypeProxy, proxyTypeAutoProxyUrl, proxyTypeAutoDetect, ProxyletUI.frame, proxyMode, autoConfigURL, proxyModeInfo);
            ProxyletUI.progressIndicator.setValue(70);
            ProxyletUI.progressIndicator.setString("70%");
            Log.debug("Config Location " + this.configLocation);
            this.setProxySetting();
            ProxyletUI.progressIndicator.setValue(80);
            ProxyletUI.progressIndicator.setString("80%");
            if (Server.running == -1) {
                System.out.println("Server not running..start it");
                this.connection = new Server(Param.getBindPort(), this);
                Thread t = new Thread(this.connection);
                t.start();
            } else {
                System.out.println("server running already..resume operations.");
                this.connection.resume();
            }
            ProxyletUI.progressIndicator.setValue(100);
            ProxyletUI.progressIndicator.setString("100%");
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug(e.getMessage());
        }
        ProxyletUI.startProxyletB.setEnabled(false);
        ProxyletUI.stopProxyletB.setEnabled(true);
        ProxyletUI.progressIndicator.setValue(0);
        ProxyletUI.progressIndicator.setString("0%");
        ProxyletUI.progressIndicator.setString(Param.getString("pinfo.23", "Proxylet Started Successfully"));
        ProxyletUI.setText(Param.getString("pinf.4", "Proxylet Initialized Successfully"));
        ProxyletUI.setText(Param.getString("pinf.5", "Please click on help if you are not sure how to proceed further"));
        ProxyletUI.setCursor(null);
    }

    public void handleSuspend() {
        ProxyletUI.setCursor(Cursor.getPredefinedCursor(3));
        ProxyletUI.startProxyletB.setEnabled(false);
        ProxyletUI.stopProxyletB.setEnabled(false);
        if (ProxyletUI.progressIndicator.isIndeterminate()) {
            ProxyletUI.progressIndicator.setIndeterminate(false);
        }
        ProxyletUI.progressIndicator.setString("");
        try {
            ProxyletUI.progressIndicator.setValue(10);
            ProxyletUI.progressIndicator.setString("10%");
            this.restoreProxySetting();
            ProxyletUI.progressIndicator.setValue(40);
            ProxyletUI.progressIndicator.setString("40%");
            Param.nullifyResource();
            ProxyletUI.progressIndicator.setValue(60);
            ProxyletUI.progressIndicator.setString("60%");
            this.connection.stop();
            ProxyletUI.progressIndicator.setValue(100);
            ProxyletUI.progressIndicator.setString("100%");
            String location = Param.getPacfileLocation();
            File f = new File(location);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            Log.debug(e.getMessage());
        }
        Log.info(Param.getString("pinfo.8", "Suspending Proxylet operations. You may restart Proxylet anytime.\nTo restart Proxylet, click on the Start button"));
        ProxyletUI.startProxyletB.setEnabled(true);
        ProxyletUI.progressIndicator.setValue(0);
        ProxyletUI.progressIndicator.setString("0%");
        ProxyletUI.setCursor(null);
        ProxyletUI.progressIndicator.setString(Param.getString("pinfo.24", "Proxylet Suspended Successfully"));
    }

    public void handleStop() {
        System.out.println("Stopping Proxylet...");
        if (this.stopped) {
            return;
        }
        ProxyletUI.setCursor(Cursor.getPredefinedCursor(3));
        ProxyletUI.progressIndicator.setString("");
        ProxyletUI.startProxyletB.setEnabled(false);
        ProxyletUI.stopProxyletB.setEnabled(false);
        if (ProxyletUI.progressIndicator.isIndeterminate()) {
            ProxyletUI.progressIndicator.setIndeterminate(false);
        }
        try {
            ProxyletUI.progressIndicator.setValue(10);
            ProxyletUI.progressIndicator.setString("10%");
            this.restoreProxySetting();
            this.closeServerSocket();
            ProxyletUI.progressIndicator.setValue(40);
            ProxyletUI.progressIndicator.setString("40%");
            Param.nullifyResource();
            ProxyletUI.progressIndicator.setValue(60);
            ProxyletUI.progressIndicator.setString("60%");
            this.connection.stop();
            ProxyletUI.progressIndicator.setValue(80);
            ProxyletUI.progressIndicator.setString("80%");
            try {
                Param.sendMsgtoServlet("?command=setJWSUnLoaded", false, false, null);
            }
            catch (SessionTimeoutException e) {
                // empty catch block
            }
            ProxyletUI.progressIndicator.setValue(100);
            ProxyletUI.progressIndicator.setString("100%");
            String location = Param.getPacfileLocation();
            File f = new File(location);
            if (f.exists()) {
                f.delete();
            }
            this.stopped = true;
            ProxyletUI.setCursor(null);
            if (ProxyletUI.frame instanceof JFrame) {
                ((JFrame)ProxyletUI.frame).dispose();
                ProxyletUI.frame.setVisible(false);
            }
        }
        catch (Exception e) {
            Log.debug(e.getMessage());
        }
    }

    public void handleHelp() {
        try {
            String lang = Param.getString("lang", "en");
            String helpFileName = "proxylet.htm";
            String servletURL = Param.getServletURL();
            int ls = servletURL.lastIndexOf("/", servletURL.length() - 2);
            String helpUrl = servletURL.substring(0, ls) + "/docs/" + lang + "/proxylet/" + helpFileName;
            this.invokeHelp(helpUrl);
        }
        catch (Exception e) {
            Log.debugu("could not launch help browser.");
        }
    }

    public void readProxySetting() {
        this.processCommand("read_proxy_settings_command");
    }

    protected void setProxySetting() {
        this.processCommand("set_proxy_settings_command?" + this.configLocation);
    }

    protected void restoreProxySetting() {
        this.processCommand("restore_proxy_settings_command");
    }

    protected String getProxyMode() {
        return this.processCommand("get_proxy_mode_command");
    }

    protected String getProxyModeInfo() {
        return this.processCommand("get_proxy_mode_info_command");
    }

    protected String getAutoConfigURL() {
        return this.processCommand("get_auto_config_url_command");
    }

    protected void invokeHelp(String helpUrl) {
        this.processCommand("invoke_help_command?" + helpUrl);
    }

    protected void closeServerSocket() {
        this.processCommand("close");
    }

    private String processCommand(String command) {
        String response = "";
        try {
            Socket connect = new Socket("localhost", 58084);
            OutputStream outputStream = connect.getOutputStream();
            PrintWriter out = new PrintWriter(outputStream);
            InputStream inputStream = connect.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            System.out.println("sent command = " + command);
            out.println("pp1.0:" + command);
            out.flush();
            System.out.println("Sent Message..Will wait for response now");
            while ((response = in.readLine()) == null) {
                System.out.println("Waiting for some response");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            System.out.println("response = " + response);
            in.close();
            out.close();
            connect.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug("could not process command - " + command);
            Log.debug(e.getMessage());
        }
        return response;
    }
}

