/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common.browser;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.StringUtil;
import com.sun.portal.proxylet.client.common.ui.ProxyletUI;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class BrowserHelper {
    public static void parsePacFile(String autoConfigURL) {
        boolean redirect = false;
        InputStream autoConfigURLInputStream = null;
        URLConnection conn = null;
        try {
            do {
                String contentType;
                redirect = false;
                URL configURL = new URL(BrowserHelper.getFormatedAutoConfigURL(autoConfigURL));
                conn = configURL.openConnection();
                if (autoConfigURL.trim().startsWith("http")) {
                    conn.setUseCaches(false);
                    conn.setDoInput(true);
                    conn.setAllowUserInteraction(false);
                    contentType = conn.getContentType();
                    autoConfigURLInputStream = conn.getInputStream();
                } else {
                    contentType = "file";
                }
                if (!contentType.equalsIgnoreCase("application/x-internet-signup") && !autoConfigURL.trim().toUpperCase().endsWith(".INS")) continue;
                PropertyResourceBundle insRes = null;
                String autoConfigJS = null;
                try {
                    DataInputStream in = new DataInputStream(autoConfigURLInputStream);
                    insRes = new PropertyResourceBundle(in);
                    autoConfigJS = insRes.getString("AutoConfigJSURL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (autoConfigJS != null && !autoConfigJS.trim().equals("")) {
                    autoConfigURL = autoConfigJS;
                    redirect = true;
                    continue;
                }
                String redirectAutoConfigURL = null;
                try {
                    redirectAutoConfigURL = insRes.getString("AutoConfigURL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (redirectAutoConfigURL != null && !redirectAutoConfigURL.trim().equals("")) {
                    if (!redirectAutoConfigURL.trim().equalsIgnoreCase(autoConfigURL.trim())) {
                        autoConfigURL = redirectAutoConfigURL;
                        redirect = true;
                        continue;
                    }
                    return;
                }
                return;
            } while (redirect);
            autoConfigURLInputStream = conn.getInputStream();
            DataInputStream in = new DataInputStream(autoConfigURLInputStream);
            byte[] data = null;
            byte[] buf = new byte[128];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            int numberOfBytes = 1;
            while (numberOfBytes > 0) {
                try {
                    numberOfBytes = in.read(buf);
                    if (numberOfBytes <= 0) continue;
                    dos.write(buf, 0, numberOfBytes);
                }
                catch (IOException ioe) {
                    numberOfBytes = 0;
                }
            }
            try {
                dos.flush();
                data = baos.toByteArray();
                in.close();
                dos.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String pacFileBody = new String(data);
            Param.setClientPACContent(pacFileBody);
            BrowserHelper.extractProxyServerFromPAC(pacFileBody);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void extractProxyServerFromPAC(String pacFileBody) throws Exception {
        pacFileBody = URLEncoder.encode(pacFileBody);
        Log.debugu(Param.getString("pinfo.12", "Reading PAC file contents"));
        Log.debug(pacFileBody);
        Log.debugu(Param.getString("pinfo.13", "Connecting to server ") + Param.getServletURL());
        String clientIP = "255.255.255.255";
        try {
            clientIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            // empty catch block
        }
        String qString = "?command=parsePacFile&clientIP=" + clientIP + "&serverURL=" + Param.getGatewayURL();
        String pacdata = "PacFileBody=" + pacFileBody;
        byte[] result = Param.sendMsgtoServlet(qString, false, true, pacdata.getBytes());
        String line = null;
        if (result != null) {
            line = new String(result);
        }
        line = line != null ? line.trim() : null;
        BrowserHelper.parseResult(line);
    }

    public static void parseResult(String proxyList) {
        if (proxyList == null || proxyList.equalsIgnoreCase("null")) {
            Param.setClientProxyInfo("DIRECT", null);
            return;
        }
        if (proxyList.startsWith("DIRECT")) {
            ProxyletUI.setText(Param.getString("pinfo.14", "Using Direct Connection "));
            Param.setClientProxyInfo("DIRECT", null);
            return;
        }
        StringTokenizer block = new StringTokenizer(proxyList, ";");
        Vector<String> temp = new Vector<String>();
        String host = "";
        String port = "-1";
        String proxyLine = null;
        while (block.hasMoreTokens()) {
            host = "";
            port = "-1";
            proxyLine = (String)block.nextElement();
            if (!proxyLine.startsWith("PROXY")) continue;
            int delim = proxyLine.indexOf(":");
            if (delim != -1) {
                host = proxyLine.substring(proxyLine.indexOf(" ") + 1, delim);
                port = proxyLine.substring(delim + 1, proxyLine.length());
            } else {
                host = proxyLine.substring(0, proxyLine.length());
            }
            temp.add(host + ":" + port);
        }
        if (temp.size() == 1) {
            proxyLine = (String)temp.get(0);
            Log.debug("Server returned  a single proxyline " + proxyLine);
            ProxyletUI.setText(Param.getString("pinfo.15", "Using Proxy ") + proxyLine);
            host = proxyLine.substring(0, proxyLine.indexOf(":") != -1 ? proxyLine.indexOf(":") : proxyLine.length());
            port = "-1";
            if (proxyLine.indexOf(":") != -1) {
                port = proxyLine.substring(proxyLine.indexOf(":") + 1, proxyLine.length());
            }
            Param.setClientProxy(host, port);
        } else {
            Param.setClientProxyList(temp);
        }
    }

    public static boolean validateProxy() {
        return true;
    }

    public static void generatePacContent(int port) {
        String clientPacFileBlock = null;
        System.out.println("inside generatePacContent");
        StringBuffer pacContent = new StringBuffer();
        pacContent.append("function FindProxyForURL(url, host) {\n    ");
        if (Param.getPacfileContent() != null) {
            pacContent.append("var hostb = \"\";\n");
            pacContent.append("    hostb = FindProxyForURL_server(url, host);\n");
            pacContent.append("    if (typeof hostb == \"undefined\") ");
            if (Param.getProxyMethod().equals("MANUAL")) {
                pacContent.append("    {");
            }
            pacContent.append(BrowserHelper.generateClientPacBlock((clientPacFileBlock = Param.getClientPACContent()) != null));
            if (Param.getProxyMethod().equals("MANUAL")) {
                pacContent.append("    }");
            }
            pacContent.append("    else {\n");
            pacContent.append("        return hostb;\n");
            pacContent.append("    }\n");
        } else {
            pacContent.append(BrowserHelper.generateGatewayPacBlock(port));
            clientPacFileBlock = Param.getClientPACContent();
            pacContent.append(BrowserHelper.generateClientPacBlock(clientPacFileBlock != null));
        }
        pacContent.append("}\n");
        if (clientPacFileBlock != null) {
            pacContent.append("\n\n");
            clientPacFileBlock = StringUtil.replaceFirst(clientPacFileBlock, "FindProxyForURL", "FindProxyForURL_client");
            pacContent.append(clientPacFileBlock);
        }
        if (Param.getPacfileContent() != null) {
            String pacBody = new String(Param.getPacfileContent());
            pacBody = StringUtil.replaceFirst(pacBody, "FindProxyForURL", "FindProxyForURL_server");
            pacBody = StringUtil.replaceAll(pacBody, "useproxy", Param.getClientProxyHost());
            pacBody = StringUtil.replaceAll(pacBody, "useproxyport", new Integer(Param.getClientProxyPort()).toString());
            pacBody = StringUtil.replaceAll(pacBody, "proxylethost", Param.getBindIP());
            pacBody = StringUtil.replaceAll(pacBody, "proxyletport", new Integer(Param.getBindPort()).toString());
            pacContent.append("\n\n");
            pacContent.append(pacBody);
        }
        Param.setNewPACContent(pacContent.toString());
    }

    private static String generateGatewayPacBlock(int port) {
        System.out.println("inside generateGatewayPacBlock");
        StringBuffer condition = new StringBuffer();
        condition.append(BrowserHelper.getRuleSet());
        return condition.toString();
    }

    private static String generateClientPacBlock(boolean existClientPac) {
        StringBuffer condition = new StringBuffer();
        if (existClientPac) {
            condition.append("{\n");
            condition.append("        var hosta= FindProxyForURL_client(url, host);\n");
            condition.append("        return hosta;\n");
            condition.append("    }\n");
        } else {
            if (Param.getProxyMethod().equals("MANUAL")) {
                condition.append(BrowserHelper.codeManualProxyInfo());
            }
            condition.append("{\n");
            condition.append("        return \"DIRECT\";\n");
            condition.append("    }\n");
        }
        return condition.toString();
    }

    private static String codeManualProxyInfo() {
        StringBuffer conditions = new StringBuffer();
        if (Param.getClientProxyHostHTTP() != null) {
            conditions.append(BrowserHelper.getManualCondition("http", Param.getClientProxyHostHTTP(), Param.getClientProxyPortHTTP()));
        }
        if (Param.getClientProxyHostFTP() != null) {
            conditions.append(BrowserHelper.getManualCondition("ftp", Param.getClientProxyHostFTP(), Param.getClientProxyPortFTP()));
        }
        if (Param.getClientProxyHostGopher() != null) {
            conditions.append(BrowserHelper.getManualCondition("gopher", Param.getClientProxyHostGopher(), Param.getClientProxyPortGopher()));
        }
        if (Param.getClientProxyHostSSL() != null) {
            conditions.append(BrowserHelper.getManualCondition("https", Param.getClientProxyHostSSL(), Param.getClientProxyPortSSL()));
        }
        return conditions.toString();
    }

    public static boolean checkPACFileSetting(String autoConfigURL) {
        if (autoConfigURL == null) {
            return false;
        }
        BrowserHelper.parsePacFile(autoConfigURL);
        Param.setProxyMethod("PAC");
        return BrowserHelper.validateProxy();
    }

    private static String getPacRule(String protocol, String domains, String ip, String port) {
        StringBuffer condition = new StringBuffer();
        condition.append("if (");
        String[] domain = domains.split("\\,");
        String host = null;
        String iport = null;
        String url = null;
        int i = 0;
        while (i < domain.length) {
            if (domain[i].indexOf("/") != -1) {
                host = domain[i].substring(0, domain[i].indexOf("/"));
                url = domain[i].substring(domain[i].indexOf("/") + 1, domain[i].length());
                System.out.println("URL " + url);
            } else {
                host = domain[i];
            }
            int npos = host.indexOf("#");
            if (npos != -1) {
                iport = host.substring(npos + 1, host.length());
                host = host.substring(0, npos);
                System.out.println("port " + iport);
            }
            condition.append("dnsDomainIs(host, ");
            if (!host.trim().startsWith(".")) {
                host = "." + host;
            }
            condition.append("\"" + host + "\") || ");
            ++i;
        }
        condition = condition.delete(condition.length() - 3, condition.length());
        condition.append(") {\n");
        if (ip != null && ip.equals("DIRECT")) {
            condition.append("        return \"DIRECT\"; \n");
        } else if (ip.equals("useproxy")) {
            if (Param.getClientProxyHost() != null) {
                condition.append("        return \"PROXY " + Param.getClientProxyHost() + ":" + Param.getClientProxyPort() + "\";\n");
            } else {
                condition.append("        return \"DIRECT\"; \n");
            }
        } else if (ip.equals("proxylethost")) {
            condition.append("        return \"PROXY " + Param.getBindIP() + ":" + Param.getBindPort() + "\";\n");
        } else {
            condition.append("        return \"PROXY " + ip + ":" + port + "\";\n");
        }
        condition.append("    } else ");
        return condition.toString();
    }

    private static String getRuleSet() {
        System.out.println("inside getRuleset");
        String rules = Param.getRules();
        String[] rule = rules.split("\\|");
        StringBuffer ruleConditions = new StringBuffer();
        int i = 0;
        while (i < rule.length) {
            String[] ruleValues = rule[i].split("\\:");
            if (ruleValues.length == 4) {
                ruleConditions.append(BrowserHelper.getPacRule(ruleValues[0], ruleValues[1], ruleValues[2], ruleValues[3]));
            } else if (ruleValues.length == 3) {
                ruleConditions.append(BrowserHelper.getPacRule("*", ruleValues[0], ruleValues[1], ruleValues[2]));
            }
            ++i;
        }
        System.out.println("rulecondition " + ruleConditions.toString());
        return ruleConditions.toString();
    }

    private static String getManualCondition(String protocol, String host, int port) {
        StringBuffer condition = new StringBuffer();
        condition.append("if (url.substring(0," + (protocol.length() + 1) + ") == \"" + protocol + ":\") {\n");
        condition.append("        return \"PROXY " + host + ":" + port + "\";\n");
        condition.append("    } else ");
        return condition.toString();
    }

    private static String getFormatedAutoConfigURL(String autoConfigURL) {
        if (-1 == autoConfigURL.indexOf("file:///") && -1 != autoConfigURL.indexOf("file://")) {
            return autoConfigURL.replaceFirst("file://", "file:///");
        }
        return autoConfigURL;
    }

    public static boolean checkManualSetting(String configList) {
        if (configList == null) {
            return false;
        }
        configList = StringUtil.replaceAll(configList, "=", "://");
        Param.setClientProxyInfo("MANUAL", configList);
        Param.setProxyMethod("MANUAL");
        return BrowserHelper.validateProxy();
    }

    public static String getNewfileLocation(Component comp) {
        String location = null;
        JOptionPane.showMessageDialog(comp, Param.getString("pinfo.25", "Please choose a directory"));
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(comp);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            location = file.getPath();
        }
        return location;
    }

    public static String checkLocation(String location, Component comp) {
        System.out.println("check location " + location);
        int index = location.lastIndexOf(47);
        System.out.println("looking for a forward slah  " + index);
        if (-1 == index) {
            System.out.println("looking for a backward double slash  " + index);
            index = location.lastIndexOf(92);
        }
        if (-1 == index) {
            location = System.getProperty("user.dir") + File.separator + location;
            System.out.println("location " + location);
        } else {
            String tmpDir = Param.createTemporaryDirectory();
            if (!new File(tmpDir).isDirectory()) {
                System.out.println("Not a valid directory");
                location = BrowserHelper.getNewfileLocation(comp);
            }
        }
        return location;
    }

    public static String writePacFile(String pacfileLocation, Component comp) {
        System.out.println("writepacfile " + pacfileLocation);
        String location = BrowserHelper.checkLocation(pacfileLocation, comp);
        try {
            FileOutputStream fout = new FileOutputStream(location);
            fout.write(Param.getNewPACContent().getBytes());
            fout.flush();
            fout.close();
        }
        catch (Exception ex) {}
        return location;
    }

    public static String processProxyInfo(long proxyTypeProxy, long proxyTypeAutoProxyUrl, long proxyTypeAutoDetect, Component context, String mode, String autoconfigurl, String manaulinfo) {
        boolean handled = false;
        long lproxyMode = Long.valueOf(mode);
        System.out.println("proxy mode " + lproxyMode);
        String clientHost = "http://localhost:";
        String fileProtocol = "file://";
        if ((lproxyMode & proxyTypeAutoDetect) == proxyTypeAutoDetect) {
            System.out.println("Proxy Setting detected : AutoDetect");
            ProxyletUI.setText(Param.getString("pinfo.16", "Proxy Setting detected : AutoDetect"));
            handled = BrowserHelper.checkAutoDetectSetting();
        }
        if ((lproxyMode & proxyTypeAutoProxyUrl) == proxyTypeAutoProxyUrl) {
            System.out.println("Autoconfig URL set");
            handled = BrowserHelper.checkPACFileSetting(autoconfigurl);
        }
        System.out.println("Autoconfig URL handled " + handled);
        if (!handled && (lproxyMode & proxyTypeProxy) == proxyTypeProxy) {
            handled = BrowserHelper.checkManualSetting(manaulinfo);
        }
        System.out.println("Manual URL handled " + handled);
        if (!handled) {
            System.out.println("Direct " + handled);
            Param.setClientProxyInfo("DIRECT", null);
        }
        BrowserHelper.generatePacContent(Param.getBindPort());
        String configLocation = null;
        if (Param.isPacfileNeedToStore()) {
            String pacfileLocation = BrowserHelper.writePacFile(Param.getPacfileLocation(), context);
            Param.setPacfileLocation(pacfileLocation);
            pacfileLocation = pacfileLocation.replace('\\', '/');
            configLocation = fileProtocol + pacfileLocation;
        } else {
            configLocation = clientHost + Param.getBindPort() + "/proxy.pac";
        }
        return configLocation;
    }

    static boolean checkAutoDetectSetting() {
        try {
            byte[] pacContent = WPAD.getPacContent();
            String pacFileBody = new String(pacContent);
            Param.setClientPACContent(pacFileBody);
            BrowserHelper.extractProxyServerFromPAC(pacFileBody);
        }
        catch (Exception e) {
            ProxyletUI.setText(e.getMessage());
            return false;
        }
        return true;
    }

    static class WPAD {
        WPAD() {
        }

        static byte[] getPacContent() throws Exception {
            StringBuffer proxysettings = new StringBuffer();
            InetAddress ia = InetAddress.getLocalHost();
            String hostName = ia.getHostName();
            Log.debug("hostname = " + hostName);
            String ipAddr = ia.getHostAddress();
            Log.debug("ip = " + ipAddr);
            hostName = InetAddress.getByName(ipAddr).getHostName();
            Log.debug("FQDN hostname = " + hostName);
            String[] domainlist = hostName.split("\\.");
            int len = domainlist.length;
            boolean found = false;
            String wpadhost = "";
            int i = 1;
            while (i < len - 1) {
                wpadhost = "wpad";
                int j = i;
                while (j < len) {
                    wpadhost = wpadhost + "." + domainlist[j];
                    ++j;
                }
                Log.debug("WPAD - " + wpadhost);
                ProxyletUI.setText(Param.getString("pinfo.17", "WPAD: Trying host ") + wpadhost);
                try {
                    ia = InetAddress.getByName(wpadhost);
                    found = true;
                    break;
                }
                catch (UnknownHostException uhe) {
                    ++i;
                }
            }
            if (found) {
                ProxyletUI.setText(Param.getString("pinfo.13", "Connecting to server ") + " " + wpadhost);
                Log.debug("Found WPAD dns name - " + wpadhost);
                try {
                    URL u = new URL("http://" + wpadhost + "/wpad.dat");
                    HttpURLConnection huc = (HttpURLConnection)u.openConnection();
                    HttpURLConnection.setFollowRedirects(true);
                    huc.setRequestMethod("GET");
                    huc.connect();
                    int code = huc.getResponseCode();
                    Log.debug("HTTP Return Code = " + code);
                    if (code >= 200 && code < 300) {
                        BufferedReader inStream = new BufferedReader(new InputStreamReader(huc.getInputStream()));
                        String response = "";
                        while ((response = inStream.readLine()) != null) {
                            proxysettings.append(response + "\n");
                        }
                        Log.debug("----------------------pac file begin---------------------");
                        Log.debug(proxysettings.toString());
                        Log.debug("-----------------------pac file end----------------------");
                        ProxyletUI.setText(Param.getString("pinfo.18", "----------------------pac file begin---------------------"));
                        ProxyletUI.setText(proxysettings.toString());
                        ProxyletUI.setText(Param.getString("pinfo.19", "----------------------pac file end---------------------"));
                    } else {
                        Log.debug("Error to retreive proxy pac file, http response code = " + code);
                    }
                    huc.disconnect();
                }
                catch (IOException e) {
                    Log.debug("Exception - " + e);
                    throw e;
                }
            } else {
                Log.debug("could not find wpad host");
                ProxyletUI.setText(Param.getString("pinfo.20", "Cannot find WPAD host"));
            }
            return proxysettings != null ? proxysettings.toString().getBytes() : null;
        }
    }
}

