/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.proxylet.client.common;

import com.sun.portal.proxylet.client.common.Log;
import com.sun.portal.proxylet.client.common.Param;
import com.sun.portal.proxylet.client.common.browser.BrowserHelper;
import com.sun.portal.proxylet.client.common.ui.ProxyletUI;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RegReader {
    public static final int ERROR_FILE_NOT_FOUND = 2;
    private String tempDirectory;
    public static boolean dllLoaded = false;
    boolean binit = false;
    private static final RegReader THEINSTANCE = new RegReader();
    static /* synthetic */ Class class$com$sun$portal$proxylet$client$common$RegReader;

    public native String getJWSVersion();

    public native String getBrowserInstallPath(String var1, String var2);

    private RegReader() {
    }

    public static synchronized RegReader getInstance() {
        if (!RegReader.THEINSTANCE.binit) {
            try {
                THEINSTANCE.init();
            }
            catch (Exception e) {
                e.printStackTrace();
                String location = null;
                location = BrowserHelper.getNewfileLocation(ProxyletUI.frame);
                THEINSTANCE.setTempDirectory(location);
            }
            RegReader.THEINSTANCE.binit = true;
        }
        return THEINSTANCE;
    }

    void init() throws Exception {
        try {
            if (!dllLoaded) {
                Log.debug("Loading library explicitly");
                this.loadExplicitly();
            }
            if (this.tempDirectory != null && new File(this.tempDirectory).isDirectory()) {
                return;
            }
            File f = File.createTempFile("abcdd", ".sunxyz");
            this.tempDirectory = f.getPath();
            this.tempDirectory = this.tempDirectory.substring(0, this.tempDirectory.lastIndexOf("\\") + 1);
            Log.debugu(" tempDirectory = " + this.tempDirectory);
            f.delete();
        }
        catch (IOException e) {
            System.out.println("Unable to create temp file");
            ProxyletUI.setText(Param.getString("perr.8", "ERR: Unable to write to disk"));
            throw e;
        }
    }

    public void loadExplicitly() throws Exception {
        System.out.println("In loadExplicityly");
        String location = this.extractResource("RegReader.dll");
        Log.debugu("RegReader.dll file location = " + location);
        System.out.println("RegReader.dll file location = " + location);
        try {
            System.load(location);
            dllLoaded = true;
            Log.debugu("loaded library 'RegReader.dll' explicitly");
            System.out.println("loaded library 'RegReader.dll' explicitly");
        }
        catch (Exception e) {
            System.out.println("Exception occured in loadExplicityly");
            dllLoaded = false;
            throw e;
        }
    }

    public String extractResource(String resourceName) throws Exception {
        String tempDirectory = this.getTempDirectory();
        File registryReaderDLLFile = new File(tempDirectory + resourceName);
        ClassLoader c1 = (class$com$sun$portal$proxylet$client$common$RegReader == null ? (class$com$sun$portal$proxylet$client$common$RegReader = RegReader.class$("com.sun.portal.proxylet.client.common.RegReader")) : class$com$sun$portal$proxylet$client$common$RegReader).getClassLoader();
        InputStream is = c1.getResourceAsStream(resourceName);
        if (is != null) {
            BufferedOutputStream ostream = null;
            try {
                ostream = new BufferedOutputStream(new FileOutputStream(registryReaderDLLFile));
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
            if (ostream != null) {
                BufferedInputStream istream = new BufferedInputStream(is);
                if (registryReaderDLLFile.exists()) {
                    registryReaderDLLFile.delete();
                    registryReaderDLLFile.createNewFile();
                }
                Log.debugu("Extracting resource " + resourceName + " to directory " + tempDirectory);
                int bsize = 2048;
                int n = 0;
                byte[] buffer = new byte[bsize];
                while ((n = istream.read(buffer, 0, bsize)) != -1) {
                    ostream.write(buffer, 0, n);
                }
                istream.close();
                ostream.close();
            }
        }
        registryReaderDLLFile.deleteOnExit();
        Log.debugu("dllFilePath = " + registryReaderDLLFile.getAbsolutePath());
        System.out.println("dllFilePath = " + registryReaderDLLFile.getAbsolutePath());
        return registryReaderDLLFile.getAbsolutePath();
    }

    public String getTempDirectory() {
        block2: {
            if (this.tempDirectory != null && this.tempDirectory.trim().length() == 0) break block2;
            try {
                File f = File.createTempFile("abcdd", ".sunxyz");
                this.tempDirectory = f.getPath();
                this.tempDirectory = this.tempDirectory.substring(0, this.tempDirectory.lastIndexOf("\\") + 1);
                f.delete();
            }
            catch (IOException e) {
                ProxyletUI.setText(Param.getString("perr.2", "ERR: installing dll."));
                e.printStackTrace();
            }
        }
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDir) {
        this.tempDirectory = tempDir;
    }

    public String getBrowserLaunchCommand(String browserName, String browserVersion) {
        System.out.println("Inside getBrowserlaunchcommand");
        String brName = browserName.trim().toLowerCase();
        System.out.println("browser name " + brName);
        System.out.println("browser version " + browserVersion);
        String command = this.getBrowserInstallPath(this.getBrowserRegistryKeyName(brName), browserVersion.trim());
        System.out.println("launch url " + command);
        if (brName.indexOf("msie") != -1) {
            command = command + "\\iexplore.exe";
        }
        return command;
    }

    private String getBrowserRegistryKeyName(String browserName) {
        if ((browserName = browserName.trim().toLowerCase()).equals("mozilla")) {
            return "mozilla.org";
        }
        if (browserName.indexOf("firefox") != -1) {
            return "mozilla";
        }
        if (browserName.indexOf("netscape") != -1) {
            return "netscape";
        }
        return browserName;
    }

    public boolean detectJWSInstallation() {
        String value = this.getJWSVersion();
        System.out.println("detect jws installation " + value);
        float jwsVer = 0.0f;
        jwsVer = new Float(value.substring(0, 3)).floatValue();
        return new Float(jwsVer).compareTo(new Float(1.4)) >= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Log.debugu("trying to load library... ");
            System.loadLibrary("RegReader");
            Log.debugu("loaded library..");
            dllLoaded = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            dllLoaded = false;
        }
    }
}

