/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.impl;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.PortletPreferencesUtility;
import com.sun.portal.portletcontainercommon.PreferencesValidatorSetter;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;

public class DPPortletPreferencesImpl
implements PortletPreferences,
PreferencesValidatorSetter {
    protected String _channel;
    private ProviderContext _pc;
    protected PreferencesValidator _pv;
    protected HttpServletRequest _req;
    private boolean _readOnly;
    protected Map _prefPropertiesMap;
    protected Map _additionalPrefMap;
    protected boolean _additionalPrefModified;
    protected Map _predefinedPrefMap;
    protected Set _modifiedList;
    protected static final String PORTLET_PREFERENCE_PREFIX = "__Portlet__";
    protected static final String ADDITIONAL_PREFERENCE = "__Portlet__AdditionalPreferences";
    protected static final String PORTLET_PREFERENCE_PROPS = "__Portlet__PreferenceProperties";
    public static final String CURRENT_ACTION = "javax.portlet.currentAction";
    protected static final String ALLOW_SAVE_PREF = "allowSavePref";
    protected static final String PREFERENCE_READONLY = "isReadOnly";
    protected static final String PREFERENCE_DEFAULT = "default";
    protected static String[] EMPTY_STRING_ARRAY = new String[0];
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$portlet$impl$DPPortletPreferencesImpl == null ? (class$com$sun$portal$portlet$impl$DPPortletPreferencesImpl = DPPortletPreferencesImpl.class$("com.sun.portal.portlet.impl.DPPortletPreferencesImpl")) : class$com$sun$portal$portlet$impl$DPPortletPreferencesImpl));
    static /* synthetic */ Class class$com$sun$portal$portlet$impl$DPPortletPreferencesImpl;

    public DPPortletPreferencesImpl(HttpServletRequest req, String channel, boolean readOnly, Logger logger) {
        this._channel = channel;
        this._req = req;
        this._readOnly = readOnly;
    }

    public DPPortletPreferencesImpl(HttpServletRequest req, ProviderContext pc, String channel, boolean readOnly, Logger logger) {
        this._channel = channel;
        this._req = req;
        this._pc = pc;
        try {
            this._prefPropertiesMap = this._pc.getCollectionProperty(this._channel, PORTLET_PREFERENCE_PROPS);
        }
        catch (ProviderContextException pce) {
            debugLogger.log(Level.SEVERE, "PSPL_PCCSPPCI0001" + (Object)((Object)pce));
        }
        if (this._prefPropertiesMap == null) {
            debugLogger.severe("PSPL_PCCSPPCI0002");
            this._prefPropertiesMap = new HashMap();
        }
        this._predefinedPrefMap = new HashMap();
        this._modifiedList = new HashSet();
        this._additionalPrefModified = false;
        this._readOnly = readOnly;
    }

    public DPPortletPreferencesImpl(HttpServletRequest req, ProviderContext pc, String channel, Logger logger) {
        this(req, pc, channel, false, logger);
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.getIsReadOnly(key);
    }

    public String getValue(String key, String def) {
        String[] defs = new String[]{def};
        String[] values = this.getValues(key, defs);
        if (values == null || values.length == 0) {
            return def;
        }
        return values[0];
    }

    public String[] getValues(String key, String[] def) {
        String value = this.getPrefValue(key, this.arrayToString(def));
        String[] prefs = this.stringToArray(value);
        if (prefs == null || prefs.length == 0) {
            return def;
        }
        return prefs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this._readOnly) {
            throw new ReadOnlyException("");
        }
        if (this.getIsPredefined(key)) {
            if (this.getIsReadOnly(key)) throw new ReadOnlyException("");
            this._predefinedPrefMap.put(key, value);
            this._modifiedList.add(key);
            return;
        } else {
            this.loadAdditionalPrefMap();
            this._additionalPrefMap.put(key, value);
            this._additionalPrefModified = true;
        }
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        this.setValue(key, this.arrayToString(values));
    }

    public Enumeration getNames() {
        Map prefMap = (Map)this._prefPropertiesMap.get(PREFERENCE_DEFAULT);
        Set names = prefMap.keySet();
        HashSet cloneNames = new HashSet(names);
        this.loadAdditionalPrefMap();
        cloneNames.addAll(this._additionalPrefMap.keySet());
        Vector v = new Vector(cloneNames);
        return v.elements();
    }

    public Map getMap() {
        HashMap<String, String[]> prefMap = new HashMap<String, String[]>();
        Enumeration names = this.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            prefMap.put(name, this.getValues(name, null));
        }
        if (prefMap.size() > 0) {
            return prefMap;
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset(String key) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.getIsPredefined(key)) {
            if (this.getIsReadOnly(key)) throw new ReadOnlyException("");
            this._predefinedPrefMap.put(key, this.getDefault(key));
            this._modifiedList.add(key);
            return;
        } else {
            this.loadAdditionalPrefMap();
            this._additionalPrefMap.remove(key);
            this._additionalPrefModified = true;
        }
    }

    public void store() throws IOException, ValidatorException {
        boolean savePref = false;
        try {
            savePref = this._pc.getBooleanProperty(this._channel, ALLOW_SAVE_PREF);
        }
        catch (ProviderContextException pce) {
            // empty catch block
        }
        String currentAction = (String)this._req.getAttribute(CURRENT_ACTION);
        if (!currentAction.equals("RENDER") || savePref) {
            if (this._pv != null) {
                this._pv.validate((PortletPreferences)this);
            }
        } else {
            throw new IllegalStateException();
        }
        this.saveAdditionalPrefMap();
        this.savePredefinedPrefMap();
    }

    public void setPreferencesValidator(PreferencesValidator pv) {
        this._pv = pv;
    }

    private String getPrefValue(String key, String def) {
        String pref = null;
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (this.getIsPredefined(key)) {
            this.loadPredefinedPref(key, def);
            if (this._predefinedPrefMap.containsKey(key)) {
                return (String)this._predefinedPrefMap.get(key);
            }
            return def;
        }
        this.loadAdditionalPrefMap();
        pref = (String)this._additionalPrefMap.get(key);
        if (pref != null) {
            return pref;
        }
        return def;
    }

    private String[] stringToArray(String value) {
        List valueArray = PortletPreferencesUtility.getPreferenceValues((String)value);
        return valueArray.toArray(EMPTY_STRING_ARRAY);
    }

    private String arrayToString(String[] values) {
        return PortletPreferencesUtility.getPreferenceString((String[])values);
    }

    protected HashMap cloneMap(Map original) {
        HashMap clone = null;
        if (original instanceof HashMap) {
            return (HashMap)((HashMap)original).clone();
        }
        clone = new HashMap();
        Iterator names = original.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            clone.put(name, original.get(name));
        }
        return clone;
    }

    protected void loadAdditionalPrefMap() {
        if (this._additionalPrefMap == null) {
            this._additionalPrefMap = new HashMap();
            try {
                if (this._pc.existsCollectionProperty(this._channel, ADDITIONAL_PREFERENCE)) {
                    Map prefMap = this._pc.getCollectionProperty(this._channel, ADDITIONAL_PREFERENCE);
                    if (prefMap != null) {
                        this._additionalPrefMap = this.cloneMap(prefMap);
                    }
                } else {
                    debugLogger.warning("PSPL_PCCSPPCI0003");
                }
            }
            catch (ProviderContextException pce) {
                debugLogger.log(Level.SEVERE, "PSPL_PCCSPPCI0001" + (Object)((Object)pce));
            }
            this._additionalPrefModified = false;
        }
    }

    protected void loadPredefinedPref(String prefName, String def) {
        if (!this._predefinedPrefMap.containsKey(prefName)) {
            try {
                String pref = this._pc.getStringProperty(this._channel, PORTLET_PREFERENCE_PREFIX + prefName, def);
                debugLogger.log(Level.INFO, "PSPL_PCCSPPCI0004", new Object[]{PORTLET_PREFERENCE_PREFIX + prefName, pref});
                this._predefinedPrefMap.put(prefName, pref);
            }
            catch (ProviderContextException pce) {
                debugLogger.log(Level.SEVERE, "PSPL_PCCSPPCI0001" + (Object)((Object)pce));
            }
        }
    }

    protected void saveAdditionalPrefMap() {
        if (this._additionalPrefModified) {
            try {
                this._pc.setCollectionProperty(this._channel, ADDITIONAL_PREFERENCE, (Map)this.cloneMap(this._additionalPrefMap));
            }
            catch (ProviderContextException pce) {
                debugLogger.log(Level.SEVERE, "PSPL_PCCSPPCI0001" + (Object)((Object)pce));
            }
            this._additionalPrefModified = false;
        }
    }

    protected void savePredefinedPrefMap() {
        Iterator iter = this._modifiedList.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)this._predefinedPrefMap.get(key);
            debugLogger.log(Level.INFO, "PSPL_PCCSPPCI0005", new Object[]{key, value});
            try {
                this._pc.setStringProperty(this._channel, PORTLET_PREFERENCE_PREFIX + key, value);
            }
            catch (ProviderContextException pce) {
                debugLogger.log(Level.SEVERE, "PSPL_PCCSPPCI0001" + (Object)((Object)pce));
            }
        }
        this._modifiedList.clear();
    }

    private boolean getIsReadOnly(String key) {
        Boolean isReadOnly;
        boolean retval = false;
        Map isReadOnlyMap = (Map)this._prefPropertiesMap.get(PREFERENCE_READONLY);
        if (isReadOnlyMap != null && (isReadOnly = (Boolean)isReadOnlyMap.get(key)) != null) {
            retval = isReadOnly;
        }
        return retval;
    }

    private String getDefault(String key) {
        String def = null;
        Map defaultMap = (Map)this._prefPropertiesMap.get(PREFERENCE_DEFAULT);
        if (defaultMap != null) {
            def = (String)defaultMap.get(key);
        }
        return def;
    }

    private boolean getIsPredefined(String key) {
        Map prefMap = (Map)this._prefPropertiesMap.get(PREFERENCE_READONLY);
        return prefMap.containsKey(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

