/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.portlet.impl;

import com.iplanet.sso.SSOToken;
import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerResponse;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.ExecuteEventRequest;
import com.sun.portal.container.ExecuteEventResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.GetResourceRequest;
import com.sun.portal.container.GetResourceResponse;
import com.sun.portal.container.impl.ExecuteEventRequestImpl;
import com.sun.portal.container.impl.ExecuteEventResponseImpl;
import com.sun.portal.container.portlet.CacheManager;
import com.sun.portal.container.portlet.PortletCacheEntry;
import com.sun.portal.container.portlet.PreferenceManager;
import com.sun.portal.container.portlet.impl.DispatcherState;
import com.sun.portal.container.portlet.impl.IPCHelper;
import com.sun.portal.container.portlet.impl.PAERequestWrapper;
import com.sun.portal.container.portlet.impl.PortletContainerUtility;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerErrorCode;
import com.sun.portal.portletcontainercommon.PortletContainerEventRequest;
import com.sun.portal.portletcontainercommon.PortletContainerEventResponse;
import com.sun.portal.portletcontainercommon.PortletContainerRenderRequest;
import com.sun.portal.portletcontainercommon.PortletContainerRenderResponse;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import com.sun.portal.providers.context.LocalePropertiesFilter;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletPreferences;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PortletContainer
implements Container {
    private PreferenceManager preferenceManager;
    private CacheManager cacheManager;
    private ServletContext sctx;
    private boolean serializeAll;
    private String sessionInvalid;
    private static final String SESSION_INVALID = "javax.portlet.session_invalid";
    private static ArrayList actionList;
    private static ArrayList renderList;
    private static ArrayList eventList;
    private static final String PAE_NAME = "/servlet/PortletAppEngineServlet";
    private static final String DISPATCHER_STATE = "__dispatcherState__";
    private static String HTTP_SESSION_ID;
    private static final String FIRST_THREAD = "javax.portlet.pc.first_thread";
    private static final String APPSERVER = "Sun-Java-System/Application-Server";
    private static final String SUN = "Sun";
    private static final String SESSION_ENABLED = "sessionEnabled";
    private static int MAX_EVENT_GENERATION;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static Logger debugLogger;
    private boolean isAS = false;
    private String portletRenderModeParallel;
    static /* synthetic */ Class class$com$sun$portal$container$portlet$impl$PortletContainer;

    void init(ServletContext sc) {
        this.preferenceManager = (PreferenceManager)sc.getAttribute("preference_manager");
        this.cacheManager = (CacheManager)sc.getAttribute("cache_manager");
        this.sctx = sc;
        String serverInfo = sc.getServerInfo();
        if (serverInfo != null && serverInfo.indexOf(SUN) >= 0) {
            this.serializeAll = false;
            if (serverInfo.equalsIgnoreCase(APPSERVER)) {
                this.isAS = true;
            }
            this.sessionInvalid = TRUE;
        } else {
            this.serializeAll = true;
            this.sessionInvalid = FALSE;
        }
    }

    public void getMarkup(GetMarkupRequest request, GetMarkupResponse response) throws ContainerException, ContentException {
        ContentException contentException;
        block13: {
            String entityID = request.getEntityID();
            PortletContainerRenderResponse pcr = null;
            contentException = null;
            boolean authlessUser = request.getUserID() == null;
            boolean isInViewMode = request.getChannelMode().equals((Object)ChannelMode.VIEW);
            PortletCacheEntry pce = null;
            if (!authlessUser && isInViewMode) {
                if (request.getIsTarget()) {
                    this.cacheManager.removeCachedPortlet((ContainerRequest)request);
                } else {
                    pce = this.cacheManager.getCachedPortlet((ContainerRequest)request);
                }
            }
            try {
                if (pce == null) {
                    HttpServletRequest req = request.getHttpServletRequest();
                    PortletContainerErrorCode errorCode = null;
                    ProviderContext pc = this.getProviderContext((ContainerRequest)request);
                    String channel = PortletContainerUtility.getChannelNameFromEntityID(entityID);
                    String title = null;
                    Locale locale = req.getLocale();
                    try {
                        List pflist = LocalePropertiesFilter.getLocalePropertiesFilters((Locale)locale, (boolean)true);
                        title = pc.getStringProperty(channel, "title", pflist);
                    }
                    catch (ProviderContextException e) {
                        e.printStackTrace();
                    }
                    if (title != null && title.length() > 0) {
                        req.setAttribute("com.sun.portal.portlet." + entityID + ".DPTITLE", (Object)title);
                    }
                    if ((errorCode = (pcr = (PortletContainerRenderResponse)this.invokePAE("RENDER", (ContainerRequest)request, (ContainerResponse)response)).getErrorCode()).equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                        int expiration_cache;
                        if (!authlessUser && isInViewMode && ((expiration_cache = pcr.getExpiration()) > 0 || expiration_cache == -1)) {
                            pce = new PortletCacheEntry(1, pcr.getMarkup(), pcr.getTitle(), expiration_cache);
                            this.cacheManager.putCachedPortlet((ContainerRequest)request, pce);
                        }
                    } else {
                        debugLogger.log(Level.SEVERE, "PSPL_PCCSPCPCI0001", new Object[]{entityID, errorCode});
                        contentException = new ContentException("PortletContainer.getMarkup(): Exception thrown from render() of " + entityID, (ErrorCode)errorCode);
                    }
                    break block13;
                }
                response.setMarkup(pce.getCachedContent());
                response.setTitle(pce.getTitleResource());
            }
            catch (Exception e) {
                throw new ContainerException("PortletContainer.getMarkup():getting content ", (Throwable)e);
            }
        }
        if (contentException != null) {
            throw contentException;
        }
    }

    private void sendFailureEvent(ContainerRequest request, ContainerResponse response) throws ContainerException {
        HttpServletRequest hreq = request.getHttpServletRequest();
        hreq.setAttribute("event_name", (Object)"eventHandlingFailed");
        hreq.setAttribute("event_data", null);
        Set portlets = (Set)this.getProviderContext(request).getSessionProperty("portlets_on_tab");
        Iterator iter = portlets.iterator();
        while (iter.hasNext()) {
            String portletEntityId = (String)iter.next();
            request.setEntityID(portletEntityId);
            try {
                PortletContainerResponse pcres = this.invokePAE("EVENT", request, response);
                PortletContainerErrorCode errorCode = pcres.getErrorCode();
                if (!errorCode.equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                    debugLogger.log(Level.SEVERE, "PSPL_PCCSPCPCI0001", new Object[]{portletEntityId, errorCode});
                    continue;
                }
                this.setRenderParameters((ExecuteEventRequest)((ExecuteEventRequestImpl)request), (ExecuteEventResponse)((ExecuteEventResponseImpl)response));
            }
            catch (Exception e) {
                throw new ContainerException("PortletContainer.executeAction(): ", (Throwable)e);
            }
        }
    }

    public void sendEvent(ContainerRequest request, ContainerResponse response) throws ContainerException {
        int gen;
        HttpServletRequest hreq = request.getHttpServletRequest();
        this.cacheManager.removeCachedPortlet(request);
        PortletContainerResponse pcres = null;
        MAX_EVENT_GENERATION = (Integer)this.getProviderContext(request).getSessionProperty("MAX_EVENT_GENERATIONS");
        for (gen = 0; gen < MAX_EVENT_GENERATION; ++gen) {
            LinkedHashMap eventMap = (LinkedHashMap)hreq.getAttribute("event_map");
            IPCHelper ipch = new IPCHelper();
            LinkedHashMap regEvtMap = ipch.getEventPortletMap(this.getProviderContext(request));
            if (eventMap == null || eventMap.isEmpty()) {
                return;
            }
            LinkedHashMap events = new LinkedHashMap();
            events.putAll(eventMap);
            hreq.removeAttribute("event_map");
            Set keys = events.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Set portletSet;
                String eventName = (String)iter.next();
                byte[] serializedData = (byte[])events.get(eventName);
                hreq.setAttribute("event_name", (Object)eventName);
                hreq.setAttribute("event_data", (Object)serializedData);
                if (regEvtMap.containsKey(eventName) && (portletSet = (Set)regEvtMap.get(eventName)) != null && portletSet.size() > 0) {
                    Iterator iterPortlets = portletSet.iterator();
                    while (iterPortlets.hasNext()) {
                        String portletEntityId = (String)iterPortlets.next();
                        request.setEntityID(portletEntityId);
                        try {
                            pcres = this.invokePAE("EVENT", request, response);
                            PortletContainerErrorCode errorCode = pcres.getErrorCode();
                            if (!errorCode.equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                                debugLogger.log(Level.SEVERE, "PSPL_PCCSPCPCI0001", new Object[]{portletEntityId, errorCode});
                                continue;
                            }
                            this.setRenderParameters((ExecuteEventRequest)((ExecuteEventRequestImpl)request), (ExecuteEventResponse)((ExecuteEventResponseImpl)response));
                        }
                        catch (Exception e) {
                            throw new ContainerException("PortletContainer.executeAction(): ", (Throwable)e);
                        }
                    }
                }
                iter.remove();
            }
        }
        if (gen > MAX_EVENT_GENERATION) {
            this.sendFailureEvent(request, response);
        }
    }

    private void setRenderParameters(ExecuteEventRequest request, ExecuteEventResponse cres) {
        Map renderParms = ((ExecuteEventResponseImpl)cres).getRenderParameters();
        boolean authless = this.getProviderContext((ContainerRequest)request).isAuthless(request.getHttpServletRequest());
        if (authless) {
            if (renderParms != null) {
                String parm = this.getProviderContext((ContainerRequest)request).getClientProperty("dt.windowProvider.renderParams." + request.getEntityID());
                if (parm != null && parm.length() > 0) {
                    Map parmMap = IPCHelper.getMapFromString(parm);
                    if (parmMap != null && !parmMap.isEmpty()) {
                        parmMap.putAll(renderParms);
                        this.getProviderContext((ContainerRequest)request).setClientProperty("dt.windowProvider.renderParams." + request.getEntityID(), IPCHelper.getStringFromMap(parmMap));
                    }
                } else {
                    this.getProviderContext((ContainerRequest)request).setClientProperty("dt.windowProvider.renderParams." + request.getEntityID(), IPCHelper.getStringFromMap(renderParms));
                }
            }
        } else if (renderParms != null) {
            Map parmMap = (Map)this.getProviderContext((ContainerRequest)request).getSessionProperty("dt.windowProvider.renderParams." + request.getEntityID());
            if (parmMap != null && !parmMap.isEmpty()) {
                parmMap.putAll(renderParms);
                this.getProviderContext((ContainerRequest)request).setSessionProperty("dt.windowProvider.renderParams." + request.getEntityID(), (Object)parmMap);
            } else {
                this.getProviderContext((ContainerRequest)request).setSessionProperty("dt.windowProvider.renderParams." + request.getEntityID(), (Object)renderParms);
            }
        }
    }

    private Map getRenderParameters(ContainerRequest request) {
        Map renderParms = null;
        boolean authless = this.getProviderContext(request).isAuthless(request.getHttpServletRequest());
        if (authless) {
            String parm = this.getProviderContext(request).getClientProperty("dt.windowProvider.renderParams." + request.getEntityID());
            if (parm != null) {
                renderParms = IPCHelper.getMapFromString(parm);
            }
        } else {
            Object parm = this.getProviderContext(request).getSessionProperty("dt.windowProvider.renderParams." + request.getEntityID());
            if (parm != null) {
                if (parm instanceof Map) {
                    return (Map)parm;
                }
                if (parm instanceof String) {
                    renderParms = IPCHelper.getMapFromString((String)parm);
                }
            }
        }
        return renderParms;
    }

    public void executeAction(ExecuteActionRequest request, ExecuteActionResponse response) throws ContainerException, ContentException {
        String entityID = request.getEntityID();
        PortletContainerActionResponse pcres = null;
        ContentException contentException = null;
        this.cacheManager.removeCachedPortlet((ContainerRequest)request);
        try {
            LinkedHashMap eventMap;
            pcres = (PortletContainerActionResponse)this.invokePAE("ACTION", (ContainerRequest)request, (ContainerResponse)response);
            PortletContainerErrorCode errorCode = pcres.getErrorCode();
            if (!errorCode.equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                debugLogger.log(Level.SEVERE, "PSPL_PCCSPCPCI0001", new Object[]{entityID, errorCode});
                contentException = new ContentException("PortletContainer.executeAction(): Exception thrown from processAction() of " + entityID, (ErrorCode)errorCode);
            }
            if ((eventMap = (LinkedHashMap)request.getHttpServletRequest().getAttribute("event_map")) != null && !eventMap.isEmpty()) {
                ExecuteEventRequest eereq = (ExecuteEventRequest)this.getEventRequest((ContainerRequest)request);
                ExecuteEventResponse eeres = (ExecuteEventResponse)this.getEventResponse((ContainerResponse)response);
                this.sendEvent((ContainerRequest)eereq, (ContainerResponse)eeres);
                response.setRenderParameters(this.getRenderParameters((ContainerRequest)request));
            }
        }
        catch (Exception e) {
            throw new ContainerException("PortletContainer.executeAction(): ", (Throwable)e);
        }
        if (contentException != null) {
            throw contentException;
        }
    }

    public void getResources(GetResourceRequest request, GetResourceResponse response) throws ContainerException {
        String entityID = request.getEntityID();
        String appName = PortletContainerUtility.getAppNameFromEntityID(entityID);
        String portletName = PortletContainerUtility.getPortletNameFromEntityID(entityID);
        ServletContext context = this.sctx.getContext(appName);
        try {
            Map resources = (Map)context.getAttribute("portlet_resources");
            ResourceBundle bundle = this.getResourceBundle(resources, portletName, request.getLocale());
            response.setResource(bundle);
        }
        catch (Exception e) {
            throw new ContainerException("PortletContainer.getResources(): ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletContainerResponse invokePAE(String action, ContainerRequest request, ContainerResponse response) throws IOException, ServletException {
        HttpServletRequest req = request.getHttpServletRequest();
        HttpServletResponse res = response.getHttpServletResponse();
        String entityID = request.getEntityID();
        String appName = PortletContainerUtility.getAppNameFromEntityID(entityID);
        String portletName = PortletContainerUtility.getPortletNameFromEntityID(entityID);
        if (debugLogger.isLoggable(Level.INFO)) {
            StringBuffer sb = new StringBuffer("PortletContainer.invokePAE(): invoking:\n");
            sb.append("app name ");
            sb.append(appName);
            sb.append("\nportlet name ");
            sb.append(portletName);
            sb.append("\naction ");
            sb.append(action);
            debugLogger.log(Level.INFO, "PSPL_PCCSPCPCI0002", sb.toString());
        }
        PortletPreferences pp = this.preferenceManager.getPortletPreferences(request);
        PortletContainerRenderRequest pcreq = null;
        PortletContainerRenderResponse pcres = null;
        if (action.equals("RENDER")) {
            pcreq = new PortletContainerRenderRequest((GetMarkupRequest)request);
            pcres = new PortletContainerRenderResponse((GetMarkupResponse)response);
            pcreq.setActions((List)renderList);
        } else if (action.equals("ACTION")) {
            pcreq = new PortletContainerActionRequest((ExecuteActionRequest)request);
            pcres = new PortletContainerActionResponse((ExecuteActionResponse)response);
            pcreq.setActions((List)actionList);
        } else if (action.equals("EVENT")) {
            pcreq = new PortletContainerEventRequest((ExecuteEventRequest)request);
            pcres = new PortletContainerEventResponse((ExecuteEventResponse)response);
            pcreq.setActions((List)eventList);
        }
        ProviderContext pc = this.getProviderContext(request);
        SSOToken token = (SSOToken)req.getAttribute("sso_token");
        pcreq.setSSOToken(token);
        pcreq.setResponseContentType(pc.getContentType());
        pcreq.setPortletPreferences(pp);
        pcreq.setPortletName(portletName);
        pcreq.setLocale(pc.getLocale());
        PAERequestWrapper reqWrapper = new PAERequestWrapper(req);
        reqWrapper.setAttribute("portlet_container_request", pcreq);
        reqWrapper.setAttribute("portlet_container_response", pcres);
        DispatcherState ds = null;
        boolean sessionEnabled = true;
        String channel = PortletContainerUtility.getChannelNameFromEntityID(entityID);
        if (this.isAS && this.portletRenderModeParallel == null) {
            DesktopAppContext desktopAppContext = DesktopAppContextThreadLocalizer.get();
            this.portletRenderModeParallel = desktopAppContext.getPortletRenderModeParallel().trim();
            if (FALSE.equalsIgnoreCase(this.portletRenderModeParallel)) {
                this.serializeAll = true;
            } else if (TRUE.equalsIgnoreCase(this.portletRenderModeParallel)) {
                this.serializeAll = false;
            }
        }
        try {
            sessionEnabled = pc.getBooleanProperty(channel, SESSION_ENABLED);
            if (this.isAS && !this.serializeAll) {
                sessionEnabled = false;
            }
        }
        catch (ProviderContextException pce) {
            // empty catch block
        }
        boolean authlessUser = request.getUserID() == null;
        while (true) {
            HttpServletRequest httpServletRequest = req;
            synchronized (httpServletRequest) {
                ds = (DispatcherState)req.getAttribute(DISPATCHER_STATE);
                if (ds == null) {
                    ds = new DispatcherState();
                    req.setAttribute(DISPATCHER_STATE, (Object)ds);
                }
                if (!ds.canEnter(appName, sessionEnabled, this.serializeAll)) {
                    try {
                        req.wait();
                    }
                    catch (InterruptedException e) {}
                } else {
                    this.handleSession(request, authlessUser);
                    reqWrapper.setAttribute(HTTP_SESSION_ID, this.getSessionId(pc, authlessUser));
                    break;
                }
            }
        }
        ServletContext context = this.sctx.getContext(appName);
        RequestDispatcher rd = context.getRequestDispatcher(PAE_NAME);
        rd.include((ServletRequest)reqWrapper, (ServletResponse)res);
        HttpServletRequest httpServletRequest = req;
        synchronized (httpServletRequest) {
            if (ds.exit()) {
                req.notifyAll();
            }
        }
        return pcres;
    }

    private void handleSession(ContainerRequest request, boolean authlessUser) {
        HttpServletRequest req = request.getHttpServletRequest();
        req.setAttribute(SESSION_INVALID, (Object)this.sessionInvalid);
        ProviderContext pc = this.getProviderContext(request);
        HttpSession hs = null;
        if (!this.isSessionIdExist(pc, authlessUser) && (hs = req.getSession(false)) != null) {
            hs.invalidate();
            req.setAttribute(SESSION_INVALID, (Object)TRUE);
        }
        if (req.getAttribute(FIRST_THREAD) == null) {
            hs = req.getSession(true);
            this.setSessionId(pc, authlessUser, hs.getId());
            req.setAttribute(FIRST_THREAD, (Object)Boolean.TRUE);
        } else {
            hs = req.getSession(false);
        }
    }

    private boolean isSessionIdExist(ProviderContext pc, boolean authlessUser) {
        boolean retValue = pc.getClientProperty(HTTP_SESSION_ID) != null;
        return retValue;
    }

    private void setSessionId(ProviderContext pc, boolean authlessUser, String sessionID) {
        pc.setClientProperty(HTTP_SESSION_ID, sessionID);
    }

    private String getSessionId(ProviderContext pc, boolean authlessUser) {
        return pc.getClientProperty(HTTP_SESSION_ID);
    }

    protected ProviderContext getProviderContext(ContainerRequest request) {
        HttpServletRequest req = request.getHttpServletRequest();
        return (ProviderContext)req.getAttribute("provider_context");
    }

    private ResourceBundle getResourceBundle(Map resourceMap, String portlet, Locale locale) {
        ResourceBundle retval = null;
        if (resourceMap != null && portlet != null) {
            Map resBundleMap;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((resBundleMap = (Map)resourceMap.get(portlet)) != null) {
                retval = (ResourceBundle)resBundleMap.get(locale.toString());
            }
        }
        return retval;
    }

    private ContainerRequest getEventRequest(ContainerRequest creq) {
        HttpServletRequest req = creq.getHttpServletRequest();
        ExecuteEventRequestImpl eer = new ExecuteEventRequestImpl();
        eer.setHttpServletRequest(req);
        ProviderContext pc = (ProviderContext)req.getAttribute("provider_context");
        String contentType = pc.getContentType();
        ArrayList<String> allowableContentTypes = new ArrayList<String>();
        allowableContentTypes.add(contentType);
        eer.setAllowableContentType(allowableContentTypes);
        String userID = null;
        if (!pc.isAuthless(req)) {
            userID = pc.getUserID();
        }
        eer.setUserID(userID);
        eer.setChannelMode(creq.getChannelMode());
        eer.setWindowState(creq.getWindowState());
        eer.setChannelURLFactory(creq.getChannelURLFactory());
        eer.setAllowableWindowState(creq.getAllowableWindowState());
        eer.setAllowableChannelMode(creq.getAllowableChannelMode());
        eer.setChannelURLFactory(creq.getChannelURLFactory());
        eer.setRoles(creq.getRoles());
        eer.setUserInfo(creq.getUserInfo());
        return eer;
    }

    private ContainerResponse getEventResponse(ContainerResponse cres) {
        ExecuteEventResponseImpl eeri = new ExecuteEventResponseImpl();
        eeri.setHttpServletResponse(cres.getHttpServletResponse());
        return eeri;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HTTP_SESSION_ID = "javax.portlet.http_session_id";
        MAX_EVENT_GENERATION = -1;
        debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$container$portlet$impl$PortletContainer == null ? (class$com$sun$portal$container$portlet$impl$PortletContainer = PortletContainer.class$("com.sun.portal.container.portlet.impl.PortletContainer")) : class$com$sun$portal$container$portlet$impl$PortletContainer));
        actionList = new ArrayList();
        renderList = new ArrayList();
        eventList = new ArrayList();
        actionList.add("ACTION");
        renderList.add("RENDER");
        eventList.add("EVENT");
    }
}

