/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.portlet.impl;

import com.sun.portal.desktop.ServletContextThreadLocalizer;
import com.sun.portal.providers.context.ProviderContext;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

public class IPCHelper {
    private static final String DELIMITER = "|";
    private static final String PARAM_DELIMITER = "|";
    private static final String KEY_DELIMITER = "=";
    private static final String ARRAY_DELIMITER = ";";

    public LinkedHashMap getEventPortletMap(ProviderContext pc) {
        Set entityIDs = (Set)pc.getSessionProperty("portlets_on_tab");
        Set evtSet = this.createEventSet(entityIDs);
        return this.setPortletEventMap(evtSet, entityIDs);
    }

    private Set createEventSet(Set entityIDs) {
        ServletContext sc = ServletContextThreadLocalizer.get();
        TreeSet evtSet = new TreeSet();
        Iterator iter = entityIDs.iterator();
        while (iter.hasNext()) {
            Set tmpSet;
            String entityID = (String)iter.next();
            String appName = this.getAppNameFromEntityID(entityID);
            ServletContext context = sc.getContext(appName);
            LinkedHashMap evtGeneratedMap = (LinkedHashMap)context.getAttribute("generate_event_list");
            if (evtGeneratedMap == null || evtGeneratedMap.size() <= 0 || (tmpSet = evtGeneratedMap.keySet()) == null || tmpSet.size() <= 0) continue;
            Iterator iterPort = tmpSet.iterator();
            while (iterPort.hasNext()) {
                String portlet = (String)iterPort.next();
                ArrayList events = (ArrayList)evtGeneratedMap.get(portlet);
                for (int i = 0; i < events.size(); ++i) {
                    evtSet.add(events.get(i));
                }
            }
        }
        return evtSet;
    }

    private LinkedHashMap setPortletEventMap(Set evtSet, Set entityIDs) {
        ServletContext sc = ServletContextThreadLocalizer.get();
        Iterator iter = entityIDs.iterator();
        LinkedHashMap evtMap = new LinkedHashMap();
        block0: while (iter.hasNext()) {
            ArrayList events;
            String entityID = (String)iter.next();
            String appName = this.getAppNameFromEntityID(entityID);
            String portletName = this.getPortletNameFromEntityID(entityID);
            ServletContext context = sc.getContext(appName);
            LinkedHashMap evtConsumedMap = (LinkedHashMap)context.getAttribute("consume_event_list");
            if (evtConsumedMap == null || evtConsumedMap.size() <= 0 || (events = (ArrayList)evtConsumedMap.get(portletName)) == null || events.size() <= 0) continue;
            Iterator iterEvents = events.iterator();
            while (iterEvents.hasNext()) {
                String evtName = (String)iterEvents.next();
                if (evtName.equals("*")) {
                    this.subscribeAll(entityID, evtMap, evtSet);
                    continue block0;
                }
                if (evtSet.contains(evtName)) {
                    this.subscribe(entityID, evtMap, evtName);
                    continue;
                }
                this.regExpMatch(evtName, evtMap, evtSet, entityID);
            }
        }
        return evtMap;
    }

    private void regExpMatch(String eventName, LinkedHashMap evtMap, Set evtSet, String portletName) {
        Iterator events = evtSet.iterator();
        while (events.hasNext()) {
            String event = (String)events.next();
            if (!Pattern.matches(eventName, event)) continue;
            this.subscribe(portletName, evtMap, event);
        }
    }

    private void subscribeAll(String portletName, LinkedHashMap evtMap, Set evtSet) {
        Iterator iter = evtSet.iterator();
        while (iter.hasNext()) {
            String eventName = (String)iter.next();
            this.subscribe(portletName, evtMap, eventName);
        }
    }

    private void subscribe(String portletName, LinkedHashMap evtMap, String eventName) {
        Set keySet = evtMap.keySet();
        if (keySet.contains(eventName)) {
            Set portlets = (Set)evtMap.get(eventName);
            portlets.add(portletName);
            evtMap.put(eventName, portlets);
        } else {
            TreeSet<String> portlets = new TreeSet<String>();
            portlets.add(portletName);
            evtMap.put(eventName, portlets);
        }
    }

    private String getPortletNameFromEntityID(String entityID) {
        String realEntityID = this.stripInstanceKey(entityID);
        return entityID.substring(realEntityID.indexOf("|") + 1, realEntityID.lastIndexOf("|"));
    }

    private String getAppNameFromEntityID(String entityID) {
        String realEntityID = this.stripInstanceKey(entityID);
        return "/" + realEntityID.substring(0, realEntityID.indexOf("|"));
    }

    private String stripInstanceKey(String entityID) {
        int numDelimiter = 0;
        int startIndex = 0;
        while ((startIndex = entityID.indexOf("|", startIndex + 1)) != -1) {
            ++numDelimiter;
        }
        if (numDelimiter > 2) {
            return entityID.substring(0, entityID.lastIndexOf("|"));
        }
        return entityID;
    }

    public static String getStringFromMap(Map paramMap) {
        String paramString = "";
        StringBuffer sb = new StringBuffer();
        Iterator i = paramMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            sb.append(key).append(KEY_DELIMITER);
            try {
                String[] value = (String[])paramMap.get(key);
                for (int j = 0; j < value.length; ++j) {
                    sb.append(URLEncoder.encode(value[j]));
                    if (j + 1 >= value.length) continue;
                    sb.append(ARRAY_DELIMITER);
                }
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
            if (!i.hasNext()) continue;
            sb.append("|");
        }
        paramString = sb.toString();
        return paramString;
    }

    public static Map getMapFromString(String paramString) {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        StringTokenizer paramtokenizer = new StringTokenizer(paramString, "|");
        while (paramtokenizer.hasMoreTokens()) {
            String keyValue = paramtokenizer.nextToken();
            StringTokenizer keyTokenizer = new StringTokenizer(keyValue, KEY_DELIMITER);
            if (keyTokenizer.countTokens() != 2) continue;
            String key = keyTokenizer.nextToken();
            String value = keyTokenizer.nextToken();
            StringTokenizer valueTokenizer = new StringTokenizer(value, ARRAY_DELIMITER);
            int noTokens = valueTokenizer.countTokens();
            String[] valueArray = new String[noTokens];
            for (int i = 0; i < noTokens; ++i) {
                valueArray[i] = URLDecoder.decode(valueTokenizer.nextToken());
            }
            paramMap.put(key, valueArray);
        }
        return paramMap;
    }
}

