/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils.synthetic.reflection;

import com.sun.org.apache.xml.internal.utils.synthetic.Class;
import com.sun.org.apache.xml.internal.utils.synthetic.SynthesisException;
import com.sun.org.apache.xml.internal.utils.synthetic.reflection.Constructor;
import com.sun.org.apache.xml.internal.utils.synthetic.reflection.Member;
import com.sun.org.apache.xml.internal.utils.synthetic.reflection.Method;
import java.lang.reflect.Modifier;

public abstract class EntryPoint
implements Member {
    protected Object realep;
    private Class declaringclass = null;
    protected Class returntype = null;
    private String[] parameternames = new String[0];
    private Class[] parametertypes = new Class[0];
    private Class[] exceptiontypes = new Class[0];
    private int modifiers;
    protected String name = null;
    private StringBuffer body = null;
    private String language = null;
    java.lang.Class[] realE;
    java.lang.Class[] realP;

    public int getModifiers() {
        return this.modifiers;
    }

    public abstract int hashCode();

    public void setModifiers(int modifiers) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.modifiers = modifiers;
    }

    public Class getDeclaringClass() {
        return this.declaringclass;
    }

    public Class getReturnType() {
        return this.returntype;
    }

    public Class[] getExceptionTypes() {
        if (this.realep != null && this.exceptiontypes == null) {
            this.exceptiontypes = new Class[this.realE.length];
            int i = 0;
            while (i < this.realE.length) {
                this.exceptiontypes[i] = Class.forClass(this.realE[i]);
                ++i;
            }
            this.realE = null;
        }
        return this.exceptiontypes;
    }

    public Class[] getParameterTypes() {
        if (this.realep != null && this.parametertypes == null) {
            this.parametertypes = new Class[this.realP.length];
            int i = 0;
            while (i < this.realP.length) {
                this.parametertypes[i] = Class.forClass(this.realP[i]);
                ++i;
            }
            this.realP = null;
        }
        return this.parametertypes;
    }

    public EntryPoint(Class declaringclass) {
        this.declaringclass = declaringclass;
    }

    public void addExceptionType(Class exception) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        Class[] e = new Class[this.exceptiontypes.length + 1];
        System.arraycopy(this.exceptiontypes, 0, e, 0, this.exceptiontypes.length);
        e[this.exceptiontypes.length] = exception;
        this.exceptiontypes = e;
    }

    public void setDeclaringClass(Class declaringClass) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.declaringclass = declaringClass;
    }

    protected EntryPoint(Object ep) throws IllegalArgumentException {
        this(ep, null);
    }

    public boolean equals(Object obj) {
        EntryPoint otherep = null;
        if (obj instanceof EntryPoint) {
            otherep = (EntryPoint)obj;
        } else if (obj instanceof java.lang.reflect.Constructor || obj instanceof java.lang.reflect.Method) {
            otherep = (EntryPoint)obj;
        }
        return otherep != null && (this instanceof Constructor && otherep instanceof Constructor || this instanceof Method && otherep instanceof Method && this.getName().equals(otherep.getName())) && otherep.getDeclaringClass().equals(this.declaringclass) && otherep.getParameterTypes().equals(this.parametertypes);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getName() {
        if (this instanceof Constructor) {
            return this.declaringclass.getShortName();
        }
        return this.name;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(Modifier.toString(this.getModifiers()));
        if (this instanceof Method) {
            sb.append(' ').append(this.getReturnType()).append(this.getDeclaringClass().getName()).append('.').append(this.getName());
        } else {
            sb.append(this.getDeclaringClass().getName());
        }
        sb.append('(');
        Class[] p = this.getParameterTypes();
        if (p != null && p.length > 0) {
            sb.append(p[0].getName());
            i = 1;
            while (i < p.length) {
                sb.append(',').append(p[i].getName());
                ++i;
            }
        }
        sb.append(')');
        if (this instanceof Method && (p = this.getExceptionTypes()) != null && p.length > 0) {
            sb.append(" throws ").append(p[0].getName());
            i = 1;
            while (i < p.length) {
                sb.append(',').append(p[i].getName());
                ++i;
            }
        }
        return sb.toString();
    }

    public String[] getParameterNames() {
        return this.parameternames;
    }

    public void setName(String name) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.name = name;
    }

    public StringBuffer getBody() {
        if (this.body == null) {
            this.body = new StringBuffer();
        }
        return this.body;
    }

    protected EntryPoint(Object ep, Class declaringclass) throws IllegalArgumentException {
        this.realep = ep;
        this.declaringclass = declaringclass;
        if (ep instanceof java.lang.reflect.Method) {
            java.lang.reflect.Method m = (java.lang.reflect.Method)ep;
            if (declaringclass == null) {
                declaringclass = Class.forClass(m.getDeclaringClass());
            }
            this.name = m.getName();
            this.modifiers = m.getModifiers();
            this.returntype = Class.forClass(m.getReturnType());
            this.realP = m.getParameterTypes();
            this.realE = m.getExceptionTypes();
        } else if (ep instanceof java.lang.reflect.Constructor) {
            java.lang.reflect.Constructor c = (java.lang.reflect.Constructor)ep;
            if (declaringclass == null) {
                declaringclass = Class.forClass(c.getDeclaringClass());
            }
            this.name = declaringclass.getShortName();
            this.modifiers = c.getModifiers();
            this.returntype = declaringclass;
            this.realP = c.getParameterTypes();
            this.realE = c.getExceptionTypes();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void addParameter(Class type, String name) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        Class[] types = new Class[this.parametertypes.length + 1];
        System.arraycopy(this.parametertypes, 0, types, 0, this.parametertypes.length);
        types[this.parametertypes.length] = type;
        this.parametertypes = types;
        String[] names = new String[this.parameternames.length + 1];
        System.arraycopy(this.parameternames, 0, names, 0, this.parameternames.length);
        names[this.parameternames.length] = name;
        this.parameternames = names;
    }

    public String toSource(String basetab) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(basetab).append(Modifier.toString(this.getModifiers()));
        if (this instanceof Method) {
            if (this.returntype != null) {
                sb.append(" ").append(this.getReturnType().getJavaName());
            } else {
                sb.append(" void");
            }
        }
        sb.append(" ").append(this.getName()).append("(");
        Class[] types = this.getParameterTypes();
        if (types != null & types.length > 0) {
            sb.append(types[0].getJavaName());
            if (this.parameternames != null) {
                sb.append(' ').append(this.parameternames[0]);
            }
            i = 1;
            while (i < types.length) {
                sb.append(',').append(types[i].getJavaName());
                if (this.parameternames != null) {
                    sb.append(' ').append(this.parameternames[i]);
                }
                ++i;
            }
        }
        sb.append(')');
        types = this.getExceptionTypes();
        if (types != null & types.length > 0) {
            sb.append(" throws ").append(types[0].getJavaName());
            i = 1;
            while (i < types.length) {
                sb.append(',').append(types[i].getJavaName());
                ++i;
            }
        }
        if (this.body == null) {
            sb.append("; // No method body available\n");
        } else {
            sb.append("\n" + basetab + "{\n");
            if (this.language == null || "java".equals(this.language)) {
                sb.append(basetab + "// ***** Should prettyprint this code...\n");
                sb.append(basetab + this.body + "\n");
            } else {
                sb.append(basetab + "// ***** Generate BSF invocation!?\n");
            }
            sb.append(basetab + "}\n");
        }
        return sb.toString();
    }

    public void setBody(String language, StringBuffer body) throws SynthesisException {
        if (this.realep != null) {
            throw new SynthesisException(2);
        }
        this.language = language;
        this.body = body;
    }
}

