/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.dtm.ref;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMDOMException;
import com.sun.org.apache.xml.internal.dtm.ref.DTMChildIterNodeList;
import com.sun.org.apache.xml.internal.dtm.ref.DTMNamedNodeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DTMNodeProxy
implements Node,
Document,
Text,
Element,
Attr,
ProcessingInstruction,
Comment,
DocumentFragment {
    public DTM dtm;
    int node;
    static final DOMImplementation implementation = new DTMNodeProxyImplementation();
    protected String fDocumentURI;
    protected String actualEncoding;
    private String xmlEncoding;
    private boolean xmlStandalone;
    private String xmlVersion;

    public final int getDTMNodeNumber() {
        return this.node;
    }

    public final int getLength() {
        return this.dtm.getNodeValue(this.node).length();
    }

    public final short getNodeType() {
        return this.dtm.getNodeType(this.node);
    }

    public final void normalize() {
        throw new DTMDOMException(9);
    }

    public void normalizeDocument() {
    }

    public final boolean getSpecified() {
        return true;
    }

    public boolean getStandalone() {
        throw new DTMDOMException(9);
    }

    public boolean getStrictErrorChecking() {
        throw new DTMDOMException(9);
    }

    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    public boolean hasAttributes() {
        return -1 != this.dtm.getFirstAttribute(this.node);
    }

    public final boolean hasChildNodes() {
        return -1 != this.dtm.getFirstChild(this.node);
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public boolean isId() {
        return false;
    }

    public final void deleteData(int offset, int count) throws DOMException {
        throw new DTMDOMException(9);
    }

    public void setIdAttribute(boolean id) {
    }

    public void setStandalone(boolean standalone) {
        throw new DTMDOMException(9);
    }

    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new DTMDOMException(9);
    }

    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.xmlStandalone = xmlStandalone;
    }

    public final DTM getDTM() {
        return this.dtm;
    }

    public DTMNodeProxy(DTM dtm, int node) {
        this.dtm = dtm;
        this.node = node;
    }

    public final boolean equals(Object node) {
        try {
            return this.equals((Node)node);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public String getActualEncoding() {
        return this.actualEncoding;
    }

    public String getBaseURI() {
        return null;
    }

    public final String getData() throws DOMException {
        return this.dtm.getNodeValue(this.node);
    }

    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    public String getInputEncoding() {
        throw new DTMDOMException(9);
    }

    public final String getLocalName() {
        return this.dtm.getLocalName(this.node);
    }

    public final String getName() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getNamespaceURI() {
        return this.dtm.getNamespaceURI(this.node);
    }

    public final String getNodeName() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getNodeValue() throws DOMException {
        return this.dtm.getNodeValue(this.node);
    }

    public final String getPrefix() {
        return this.dtm.getPrefix(this.node);
    }

    public final String getStringValue() throws DOMException {
        return this.dtm.getStringValue(this.node).toString();
    }

    public final String getTagName() {
        return this.dtm.getNodeName(this.node);
    }

    public final String getTarget() {
        return this.dtm.getNodeName(this.node);
    }

    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    public final String getValue() {
        return this.dtm.getNodeValue(this.node);
    }

    public String getVersion() {
        throw new DTMDOMException(9);
    }

    public String getWholeText() {
        return null;
    }

    public String getXmlEncoding() {
        return this.xmlEncoding;
    }

    public String getXmlVersion() {
        return this.xmlVersion;
    }

    public final String substringData(int offset, int count) throws DOMException {
        return this.getData().substring(offset, offset + count);
    }

    public final void replaceData(int offset, int count, String arg) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void insertData(int offset, String arg) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void appendData(String arg) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void removeAttribute(String name) throws DOMException {
        throw new DTMDOMException(9);
    }

    public void setActualEncoding(String value) {
        this.actualEncoding = value;
    }

    public final void setData(String data) throws DOMException {
        throw new DTMDOMException(9);
    }

    public void setDocumentURI(String documentURI) {
        this.fDocumentURI = documentURI;
    }

    public void setEncoding(String encoding) {
        throw new DTMDOMException(9);
    }

    public final void setNodeValue(String nodeValue) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final void setPrefix(String prefix) throws DOMException {
        throw new DTMDOMException(7);
    }

    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    public final void setValue(String value) {
        throw new DTMDOMException(9);
    }

    public void setVersion(String version) {
        throw new DTMDOMException(9);
    }

    public void setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.xmlVersion = xmlVersion;
    }

    public boolean hasAttribute(String name) {
        return -1 != this.dtm.getAttributeNode(this.node, null, name);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public void setIdAttribute(String name, boolean makeId) {
    }

    public void setIdAttributeNode(Attr at, boolean makeId) {
    }

    public DOMConfiguration getDomConfig() {
        return null;
    }

    public final DOMImplementation getImplementation() {
        return implementation;
    }

    public final Document getOwnerDocument() {
        return (Document)this.dtm.getNode(this.dtm.getOwnerDocument(this.node));
    }

    public final DocumentFragment createDocumentFragment() {
        throw new DTMDOMException(9);
    }

    public final DocumentType getDoctype() {
        return null;
    }

    public final Element getDocumentElement() {
        int dochandle = this.dtm.getDocument();
        int elementhandle = -1;
        int kidhandle = this.dtm.getFirstChild(dochandle);
        while (kidhandle != -1) {
            switch (this.dtm.getNodeType(kidhandle)) {
                case 1: {
                    if (elementhandle != -1) {
                        elementhandle = -1;
                        kidhandle = this.dtm.getLastChild(dochandle);
                        break;
                    }
                    elementhandle = kidhandle;
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    elementhandle = -1;
                    kidhandle = this.dtm.getLastChild(dochandle);
                }
            }
            kidhandle = this.dtm.getNextSibling(kidhandle);
        }
        if (elementhandle == -1) {
            throw new DTMDOMException(9);
        }
        return (Element)this.dtm.getNode(elementhandle);
    }

    public final Element getOwnerElement() {
        if (this.getNodeType() != 2) {
            return null;
        }
        int newnode = this.dtm.getParent(this.node);
        return newnode == -1 ? null : (Element)this.dtm.getNode(newnode);
    }

    public final NamedNodeMap getAttributes() {
        return new DTMNamedNodeMap(this.dtm, this.node);
    }

    public final Node getFirstChild() {
        int newnode = this.dtm.getFirstChild(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getLastChild() {
        int newnode = this.dtm.getLastChild(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getNextSibling() {
        if (this.dtm.getNodeType(this.node) == 2) {
            return null;
        }
        int newnode = this.dtm.getNextSibling(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getOwnerNode() {
        int newnode = this.dtm.getParent(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getParentNode() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int newnode = this.dtm.getParent(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public final Node getPreviousSibling() {
        int newnode = this.dtm.getPreviousSibling(this.node);
        return newnode == -1 ? null : this.dtm.getNode(newnode);
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public final boolean equals(Node node) {
        try {
            DTMNodeProxy dtmp = (DTMNodeProxy)node;
            return dtmp.node == this.node && dtmp.dtm == this.dtm;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public boolean isEqualNode(Node arg) {
        if (arg == this) {
            return true;
        }
        if (arg.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null ? arg.getNodeName() != null : !this.getNodeName().equals(arg.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null ? arg.getLocalName() != null : !this.getLocalName().equals(arg.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null ? arg.getNamespaceURI() != null : !this.getNamespaceURI().equals(arg.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null ? arg.getPrefix() != null : !this.getPrefix().equals(arg.getPrefix())) {
            return false;
        }
        return !(this.getNodeValue() == null ? arg.getNodeValue() != null : !this.getNodeValue().equals(arg.getNodeValue()));
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public final boolean sameNodeAs(Node other) {
        if (!(other instanceof DTMNodeProxy)) {
            return false;
        }
        DTMNodeProxy that = (DTMNodeProxy)other;
        return this.dtm == that.dtm && this.node == that.node;
    }

    public final Node cloneNode(boolean deep) {
        throw new DTMDOMException(9);
    }

    public final NodeList getChildNodes() {
        return new DTMChildIterNodeList(this.dtm, this.node);
    }

    public final Text splitText(int offset) throws DOMException {
        throw new DTMDOMException(9);
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public Object getUserData(String key) {
        return this.getOwnerDocument().getUserData(key);
    }

    public final String getAttribute(String name) {
        DTMNamedNodeMap map = new DTMNamedNodeMap(this.dtm, this.node);
        Node node = map.getNamedItem(name);
        return null == node ? null : node.getNodeValue();
    }

    public String lookupNamespaceURI(String specifiedPrefix) {
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                String namespace = this.getNamespaceURI();
                String prefix = this.getPrefix();
                if (namespace != null) {
                    if (specifiedPrefix == null && prefix == specifiedPrefix) {
                        return namespace;
                    }
                    if (prefix != null && prefix.equals(specifiedPrefix)) {
                        return namespace;
                    }
                }
                if (this.hasAttributes()) {
                    NamedNodeMap map = this.getAttributes();
                    int length = map.getLength();
                    int i = 0;
                    while (i < length) {
                        Node attr = map.item(i);
                        String attrPrefix = attr.getPrefix();
                        String value = attr.getNodeValue();
                        namespace = attr.getNamespaceURI();
                        if (namespace != null && namespace.equals("http://www.w3.org/2000/xmlns/")) {
                            if (specifiedPrefix == null && attr.getNodeName().equals("xmlns")) {
                                return value;
                            }
                            if (attrPrefix != null && attrPrefix.equals("xmlns") && attr.getLocalName().equals(specifiedPrefix)) {
                                return value;
                            }
                        }
                        ++i;
                    }
                }
                return null;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.getOwnerElement().getNodeType() == 1) {
                    return this.getOwnerElement().lookupNamespaceURI(specifiedPrefix);
                }
                return null;
            }
        }
        return null;
    }

    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        short type = this.getNodeType();
        switch (type) {
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.getOwnerElement().getNodeType() == 1) {
                    return this.getOwnerElement().lookupPrefix(namespaceURI);
                }
                return null;
            }
        }
        return null;
    }

    public final void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void setAttribute(String name, String value) throws DOMException {
        throw new DTMDOMException(9);
    }

    public boolean hasAttributeNS(String name, String x) {
        return -1 != this.dtm.getAttributeNode(this.node, x, name);
    }

    public final boolean isSupported(String feature, String version) {
        return implementation.hasFeature(feature, version);
    }

    public final boolean supports(String feature, String version) {
        return implementation.hasFeature(feature, version);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean makeId) {
    }

    public final Attr createAttribute(String name) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr getAttributeNode(String name) {
        DTMNamedNodeMap map = new DTMNamedNodeMap(this.dtm, this.node);
        return (Attr)map.getNamedItem(name);
    }

    public final Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final CDATASection createCDATASection(String data) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Comment createComment(String data) {
        throw new DTMDOMException(9);
    }

    public final Element createElement(String tagName) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Element getElementById(String elementId) {
        throw new DTMDOMException(9);
    }

    public final EntityReference createEntityReference(String name) throws DOMException {
        throw new DTMDOMException(9);
    }

    public Node adoptNode(Node source) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Node appendChild(Node newChild) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node removeChild(Node oldChild) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final NodeList getElementsByTagName(String tagname) {
        throw new DTMDOMException(9);
    }

    public final Text createTextNode(String data) {
        throw new DTMDOMException(9);
    }

    public Text replaceWholeText(String content) throws DOMException {
        return null;
    }

    public Object getFeature(String feature, String version) {
        return this.isSupported(feature, version) ? this : null;
    }

    public final String getAttributeNS(String namespaceURI, String localName) {
        DTMNamedNodeMap map = new DTMNamedNodeMap(this.dtm, this.node);
        Node node = map.getNamedItemNS(namespaceURI, localName);
        return null == node ? null : node.getNodeValue();
    }

    public final void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr getAttributeNodeNS(String namespaceURI, String localName) {
        throw new DTMDOMException(9);
    }

    public final Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new DTMDOMException(9);
    }

    public final ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DTMDOMException(9);
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.getOwnerDocument().setUserData(key, data, handler);
    }

    public Node renameNode(Node n, String namespaceURI, String name) throws DOMException {
        return n;
    }

    static class DTMNodeProxyImplementation
    implements DOMImplementation {
        DTMNodeProxyImplementation() {
        }

        public boolean hasFeature(String feature, String version) {
            return !(!"CORE".equals(feature.toUpperCase()) && !"XML".equals(feature.toUpperCase()) || !"1.0".equals(version) && !"2.0".equals(version));
        }

        public Object getFeature(String feature, String version) {
            return null;
        }

        public Document createDocument(String namespaceURI, String qualfiedName, DocumentType doctype) {
            throw new DTMDOMException(9);
        }

        public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
            throw new DTMDOMException(9);
        }
    }
}

