/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.serialize;

import com.sun.org.apache.xalan.internal.serialize.DOMSerializer;
import com.sun.org.apache.xalan.internal.serialize.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public abstract class SerializerFactory {
    private SerializerFactory() {
    }

    public static Serializer getSerializer(Properties format) {
        com.sun.org.apache.xml.internal.serializer.Serializer ser = com.sun.org.apache.xml.internal.serializer.SerializerFactory.getSerializer(format);
        SerializerWrapper si = new SerializerWrapper(ser);
        return si;
    }

    private static class DOMSerializerWrapper
    implements DOMSerializer {
        private final com.sun.org.apache.xml.internal.serializer.DOMSerializer m_dom;

        DOMSerializerWrapper(com.sun.org.apache.xml.internal.serializer.DOMSerializer domser) {
            this.m_dom = domser;
        }

        public void serialize(Node node) throws IOException {
            this.m_dom.serialize(node);
        }
    }

    private static class SerializerWrapper
    implements Serializer {
        private final com.sun.org.apache.xml.internal.serializer.Serializer m_serializer;
        private DOMSerializer m_old_DOMSerializer;

        public boolean reset() {
            return this.m_serializer.reset();
        }

        public DOMSerializer asDOMSerializer() throws IOException {
            if (this.m_old_DOMSerializer == null) {
                this.m_old_DOMSerializer = new DOMSerializerWrapper(this.m_serializer.asDOMSerializer());
            }
            return this.m_old_DOMSerializer;
        }

        SerializerWrapper(com.sun.org.apache.xml.internal.serializer.Serializer ser) {
            this.m_serializer = ser;
        }

        public OutputStream getOutputStream() {
            return this.m_serializer.getOutputStream();
        }

        public void setOutputStream(OutputStream output) {
            this.m_serializer.setOutputStream(output);
        }

        public Writer getWriter() {
            return this.m_serializer.getWriter();
        }

        public void setWriter(Writer writer) {
            this.m_serializer.setWriter(writer);
        }

        public Properties getOutputFormat() {
            return this.m_serializer.getOutputFormat();
        }

        public void setOutputFormat(Properties format) {
            this.m_serializer.setOutputFormat(format);
        }

        public ContentHandler asContentHandler() throws IOException {
            return this.m_serializer.asContentHandler();
        }
    }
}

