/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.structurals;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.generic.AALOAD;
import com.sun.org.apache.bcel.internal.generic.AASTORE;
import com.sun.org.apache.bcel.internal.generic.ACONST_NULL;
import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ARETURN;
import com.sun.org.apache.bcel.internal.generic.ARRAYLENGTH;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ATHROW;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BALOAD;
import com.sun.org.apache.bcel.internal.generic.BASTORE;
import com.sun.org.apache.bcel.internal.generic.BIPUSH;
import com.sun.org.apache.bcel.internal.generic.CALOAD;
import com.sun.org.apache.bcel.internal.generic.CASTORE;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.D2F;
import com.sun.org.apache.bcel.internal.generic.D2I;
import com.sun.org.apache.bcel.internal.generic.D2L;
import com.sun.org.apache.bcel.internal.generic.DADD;
import com.sun.org.apache.bcel.internal.generic.DALOAD;
import com.sun.org.apache.bcel.internal.generic.DASTORE;
import com.sun.org.apache.bcel.internal.generic.DCMPG;
import com.sun.org.apache.bcel.internal.generic.DCMPL;
import com.sun.org.apache.bcel.internal.generic.DCONST;
import com.sun.org.apache.bcel.internal.generic.DDIV;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DMUL;
import com.sun.org.apache.bcel.internal.generic.DNEG;
import com.sun.org.apache.bcel.internal.generic.DREM;
import com.sun.org.apache.bcel.internal.generic.DRETURN;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.DSUB;
import com.sun.org.apache.bcel.internal.generic.DUP;
import com.sun.org.apache.bcel.internal.generic.DUP2;
import com.sun.org.apache.bcel.internal.generic.DUP2_X1;
import com.sun.org.apache.bcel.internal.generic.DUP2_X2;
import com.sun.org.apache.bcel.internal.generic.DUP_X1;
import com.sun.org.apache.bcel.internal.generic.DUP_X2;
import com.sun.org.apache.bcel.internal.generic.EmptyVisitor;
import com.sun.org.apache.bcel.internal.generic.F2D;
import com.sun.org.apache.bcel.internal.generic.F2I;
import com.sun.org.apache.bcel.internal.generic.F2L;
import com.sun.org.apache.bcel.internal.generic.FADD;
import com.sun.org.apache.bcel.internal.generic.FALOAD;
import com.sun.org.apache.bcel.internal.generic.FASTORE;
import com.sun.org.apache.bcel.internal.generic.FCMPG;
import com.sun.org.apache.bcel.internal.generic.FCMPL;
import com.sun.org.apache.bcel.internal.generic.FCONST;
import com.sun.org.apache.bcel.internal.generic.FDIV;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FMUL;
import com.sun.org.apache.bcel.internal.generic.FNEG;
import com.sun.org.apache.bcel.internal.generic.FREM;
import com.sun.org.apache.bcel.internal.generic.FRETURN;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.FSUB;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.GETSTATIC;
import com.sun.org.apache.bcel.internal.generic.GOTO;
import com.sun.org.apache.bcel.internal.generic.GOTO_W;
import com.sun.org.apache.bcel.internal.generic.I2B;
import com.sun.org.apache.bcel.internal.generic.I2C;
import com.sun.org.apache.bcel.internal.generic.I2D;
import com.sun.org.apache.bcel.internal.generic.I2F;
import com.sun.org.apache.bcel.internal.generic.I2L;
import com.sun.org.apache.bcel.internal.generic.I2S;
import com.sun.org.apache.bcel.internal.generic.IADD;
import com.sun.org.apache.bcel.internal.generic.IALOAD;
import com.sun.org.apache.bcel.internal.generic.IAND;
import com.sun.org.apache.bcel.internal.generic.IASTORE;
import com.sun.org.apache.bcel.internal.generic.ICONST;
import com.sun.org.apache.bcel.internal.generic.IDIV;
import com.sun.org.apache.bcel.internal.generic.IFEQ;
import com.sun.org.apache.bcel.internal.generic.IFGE;
import com.sun.org.apache.bcel.internal.generic.IFGT;
import com.sun.org.apache.bcel.internal.generic.IFLE;
import com.sun.org.apache.bcel.internal.generic.IFLT;
import com.sun.org.apache.bcel.internal.generic.IFNE;
import com.sun.org.apache.bcel.internal.generic.IFNONNULL;
import com.sun.org.apache.bcel.internal.generic.IFNULL;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPNE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPNE;
import com.sun.org.apache.bcel.internal.generic.IINC;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.IMUL;
import com.sun.org.apache.bcel.internal.generic.INEG;
import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.IOR;
import com.sun.org.apache.bcel.internal.generic.IREM;
import com.sun.org.apache.bcel.internal.generic.IRETURN;
import com.sun.org.apache.bcel.internal.generic.ISHL;
import com.sun.org.apache.bcel.internal.generic.ISHR;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.ISUB;
import com.sun.org.apache.bcel.internal.generic.IUSHR;
import com.sun.org.apache.bcel.internal.generic.IXOR;
import com.sun.org.apache.bcel.internal.generic.JSR;
import com.sun.org.apache.bcel.internal.generic.JSR_W;
import com.sun.org.apache.bcel.internal.generic.L2D;
import com.sun.org.apache.bcel.internal.generic.L2F;
import com.sun.org.apache.bcel.internal.generic.L2I;
import com.sun.org.apache.bcel.internal.generic.LADD;
import com.sun.org.apache.bcel.internal.generic.LALOAD;
import com.sun.org.apache.bcel.internal.generic.LAND;
import com.sun.org.apache.bcel.internal.generic.LASTORE;
import com.sun.org.apache.bcel.internal.generic.LCMP;
import com.sun.org.apache.bcel.internal.generic.LCONST;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LDC2_W;
import com.sun.org.apache.bcel.internal.generic.LDC_W;
import com.sun.org.apache.bcel.internal.generic.LDIV;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LMUL;
import com.sun.org.apache.bcel.internal.generic.LNEG;
import com.sun.org.apache.bcel.internal.generic.LOOKUPSWITCH;
import com.sun.org.apache.bcel.internal.generic.LOR;
import com.sun.org.apache.bcel.internal.generic.LREM;
import com.sun.org.apache.bcel.internal.generic.LRETURN;
import com.sun.org.apache.bcel.internal.generic.LSHL;
import com.sun.org.apache.bcel.internal.generic.LSHR;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.LSUB;
import com.sun.org.apache.bcel.internal.generic.LUSHR;
import com.sun.org.apache.bcel.internal.generic.LXOR;
import com.sun.org.apache.bcel.internal.generic.MONITORENTER;
import com.sun.org.apache.bcel.internal.generic.MONITOREXIT;
import com.sun.org.apache.bcel.internal.generic.MULTIANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.NOP;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.POP;
import com.sun.org.apache.bcel.internal.generic.POP2;
import com.sun.org.apache.bcel.internal.generic.PUTFIELD;
import com.sun.org.apache.bcel.internal.generic.PUTSTATIC;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.RETURN;
import com.sun.org.apache.bcel.internal.generic.ReturnaddressType;
import com.sun.org.apache.bcel.internal.generic.SALOAD;
import com.sun.org.apache.bcel.internal.generic.SASTORE;
import com.sun.org.apache.bcel.internal.generic.SIPUSH;
import com.sun.org.apache.bcel.internal.generic.SWAP;
import com.sun.org.apache.bcel.internal.generic.TABLESWITCH;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.verifier.structurals.Frame;
import com.sun.org.apache.bcel.internal.verifier.structurals.LocalVariables;
import com.sun.org.apache.bcel.internal.verifier.structurals.OperandStack;
import com.sun.org.apache.bcel.internal.verifier.structurals.UninitializedObjectType;

public class ExecutionVisitor
extends EmptyVisitor
implements Visitor {
    private Frame frame = null;
    private ConstantPoolGen cpg = null;

    public void visitAALOAD(AALOAD o) {
        this.stack().pop();
        Type t = this.stack().pop();
        if (t == Type.NULL) {
            this.stack().push(Type.NULL);
        } else {
            ArrayType at = (ArrayType)t;
            this.stack().push(at.getElementType());
        }
    }

    public void visitAASTORE(AASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitACONST_NULL(ACONST_NULL o) {
        this.stack().push(Type.NULL);
    }

    public void visitALOAD(ALOAD o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    public void visitANEWARRAY(ANEWARRAY o) {
        this.stack().pop();
        this.stack().push(new ArrayType(o.getType(this.cpg), 1));
    }

    public void visitARETURN(ARETURN o) {
        this.stack().pop();
    }

    public void visitARRAYLENGTH(ARRAYLENGTH o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitASTORE(ASTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    public void visitATHROW(ATHROW o) {
        Type t = this.stack().pop();
        this.stack().clear();
        if (t.equals(Type.NULL)) {
            this.stack().push(Type.getType("Ljava/lang/NullPointerException;"));
        } else {
            this.stack().push(t);
        }
    }

    public void visitBALOAD(BALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitBASTORE(BASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitBIPUSH(BIPUSH o) {
        this.stack().push(Type.INT);
    }

    public void visitCALOAD(CALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitCASTORE(CASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitCHECKCAST(CHECKCAST o) {
        this.stack().pop();
        this.stack().push(o.getType(this.cpg));
    }

    public void setConstantPoolGen(ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void visitD2F(D2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitD2I(D2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitD2L(D2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitDADD(DADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDALOAD(DALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDASTORE(DASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitDCMPG(DCMPG o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitDCMPL(DCMPL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitDCONST(DCONST o) {
        this.stack().push(Type.DOUBLE);
    }

    public void visitDDIV(DDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDLOAD(DLOAD o) {
        this.stack().push(Type.DOUBLE);
    }

    public void visitDMUL(DMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDNEG(DNEG o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDREM(DREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDRETURN(DRETURN o) {
        this.stack().pop();
    }

    public void visitDSTORE(DSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    public void visitDSUB(DSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitDUP(DUP o) {
        Type t = this.stack().pop();
        this.stack().push(t);
        this.stack().push(t);
    }

    public void visitDUP2(DUP2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            this.stack().push(t);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    public void visitDUP2_X1(DUP2_X1 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(v);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    public void visitDUP2_X2(DUP2_X2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            if (u.getSize() == 2) {
                this.stack().push(t);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type v = this.stack().pop();
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            if (v.getSize() == 2) {
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type w = this.stack().pop();
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(w);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        }
    }

    public void visitDUP_X1(DUP_X1 o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        this.stack().push(w1);
        this.stack().push(w2);
        this.stack().push(w1);
    }

    public void visitDUP_X2(DUP_X2 o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        if (w2.getSize() == 2) {
            this.stack().push(w1);
            this.stack().push(w2);
            this.stack().push(w1);
        } else {
            Type w3 = this.stack().pop();
            this.stack().push(w1);
            this.stack().push(w3);
            this.stack().push(w2);
            this.stack().push(w1);
        }
    }

    public void visitF2D(F2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitF2I(F2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitF2L(F2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitFADD(FADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFALOAD(FALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFASTORE(FASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitFCMPG(FCMPG o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitFCMPL(FCMPL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitFCONST(FCONST o) {
        this.stack().push(Type.FLOAT);
    }

    public void visitFDIV(FDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFLOAD(FLOAD o) {
        this.stack().push(Type.FLOAT);
    }

    public void visitFMUL(FMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFNEG(FNEG o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFREM(FREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitFRETURN(FRETURN o) {
        this.stack().pop();
    }

    public void visitFSTORE(FSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    public void visitFSUB(FSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitGETFIELD(GETFIELD o) {
        this.stack().pop();
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    public void visitGETSTATIC(GETSTATIC o) {
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    public void visitGOTO(GOTO o) {
    }

    public void visitGOTO_W(GOTO_W o) {
    }

    public void visitI2B(I2B o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitI2C(I2C o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitI2D(I2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitI2F(I2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitI2L(I2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitI2S(I2S o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIADD(IADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIALOAD(IALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIAND(IAND o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIASTORE(IASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitICONST(ICONST o) {
        this.stack().push(Type.INT);
    }

    public void visitIDIV(IDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIFEQ(IFEQ o) {
        this.stack().pop();
    }

    public void visitIFGE(IFGE o) {
        this.stack().pop();
    }

    public void visitIFGT(IFGT o) {
        this.stack().pop();
    }

    public void visitIFLE(IFLE o) {
        this.stack().pop();
    }

    public void visitIFLT(IFLT o) {
        this.stack().pop();
    }

    public void visitIFNE(IFNE o) {
        this.stack().pop();
    }

    public void visitIFNONNULL(IFNONNULL o) {
        this.stack().pop();
    }

    public void visitIFNULL(IFNULL o) {
        this.stack().pop();
    }

    public void visitIF_ACMPEQ(IF_ACMPEQ o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ACMPNE(IF_ACMPNE o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPEQ(IF_ICMPEQ o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPGE(IF_ICMPGE o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPGT(IF_ICMPGT o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPLE(IF_ICMPLE o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPLT(IF_ICMPLT o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIF_ICMPNE(IF_ICMPNE o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitIINC(IINC o) {
    }

    public void visitILOAD(ILOAD o) {
        this.stack().push(Type.INT);
    }

    public void visitIMUL(IMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitINEG(INEG o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitINSTANCEOF(INSTANCEOF o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitINVOKEINTERFACE(INVOKEINTERFACE o) {
        this.stack().pop();
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    public void visitINVOKESPECIAL(INVOKESPECIAL o) {
        if (o.getMethodName(this.cpg).equals("<init>")) {
            UninitializedObjectType t = (UninitializedObjectType)this.stack().peek(o.getArgumentTypes(this.cpg).length);
            if (t == Frame._this) {
                Frame._this = null;
            }
            this.stack().initializeObject(t);
            this.locals().initializeObject(t);
        }
        this.stack().pop();
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    public void visitINVOKESTATIC(INVOKESTATIC o) {
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL o) {
        this.stack().pop();
        int i = 0;
        while (i < o.getArgumentTypes(this.cpg).length) {
            this.stack().pop();
            ++i;
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    public void visitIOR(IOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIREM(IREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIRETURN(IRETURN o) {
        this.stack().pop();
    }

    public void visitISHL(ISHL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitISHR(ISHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitISTORE(ISTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    public void visitISUB(ISUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIUSHR(IUSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitIXOR(IXOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitJSR(JSR o) {
        this.stack().push(new ReturnaddressType(o.physicalSuccessor()));
    }

    public void visitJSR_W(JSR_W o) {
        this.stack().push(new ReturnaddressType(o.physicalSuccessor()));
    }

    public void visitL2D(L2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    public void visitL2F(L2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    public void visitL2I(L2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitLADD(LADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLALOAD(LALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLAND(LAND o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLASTORE(LASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitLCMP(LCMP o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitLCONST(LCONST o) {
        this.stack().push(Type.LONG);
    }

    public void visitLDC(LDC o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
    }

    public void visitLDC2_W(LDC2_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantLong) {
            this.stack().push(Type.LONG);
        }
        if (c instanceof ConstantDouble) {
            this.stack().push(Type.DOUBLE);
        }
    }

    public void visitLDC_W(LDC_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
    }

    public void visitLDIV(LDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLLOAD(LLOAD o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    public void visitLMUL(LMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLNEG(LNEG o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLOOKUPSWITCH(LOOKUPSWITCH o) {
        this.stack().pop();
    }

    public void visitLOR(LOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLREM(LREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLRETURN(LRETURN o) {
        this.stack().pop();
    }

    public void visitLSHL(LSHL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLSHR(LSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLSTORE(LSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    public void visitLSUB(LSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLUSHR(LUSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitLXOR(LXOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    public void visitMONITORENTER(MONITORENTER o) {
        this.stack().pop();
    }

    public void visitMONITOREXIT(MONITOREXIT o) {
        this.stack().pop();
    }

    public void visitMULTIANEWARRAY(MULTIANEWARRAY o) {
        int i = 0;
        while (i < o.getDimensions()) {
            this.stack().pop();
            ++i;
        }
        this.stack().push(o.getType(this.cpg));
    }

    public void visitNEW(NEW o) {
        this.stack().push(new UninitializedObjectType((ObjectType)o.getType(this.cpg)));
    }

    public void visitNEWARRAY(NEWARRAY o) {
        this.stack().pop();
        this.stack().push(o.getType());
    }

    public void visitNOP(NOP o) {
    }

    public void visitPOP(POP o) {
        this.stack().pop();
    }

    public void visitPOP2(POP2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 1) {
            this.stack().pop();
        }
    }

    public void visitPUTFIELD(PUTFIELD o) {
        this.stack().pop();
        this.stack().pop();
    }

    public void visitPUTSTATIC(PUTSTATIC o) {
        this.stack().pop();
    }

    public void visitRET(RET o) {
    }

    public void visitRETURN(RETURN o) {
    }

    public void visitSALOAD(SALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    public void visitSASTORE(SASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    public void visitSIPUSH(SIPUSH o) {
        this.stack().push(Type.INT);
    }

    public void visitSWAP(SWAP o) {
        Type t = this.stack().pop();
        Type u = this.stack().pop();
        this.stack().push(t);
        this.stack().push(u);
    }

    public void visitTABLESWITCH(TABLESWITCH o) {
        this.stack().pop();
    }

    public void setFrame(Frame f) {
        this.frame = f;
    }

    private LocalVariables locals() {
        return this.frame.getLocals();
    }

    private OperandStack stack() {
        return this.frame.getStack();
    }
}

