/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;

public class LineNumberGen
implements InstructionTargeter,
Cloneable {
    private InstructionHandle ih;
    private int src_line;

    public int getSourceLine() {
        return this.src_line;
    }

    public void setSourceLine(int src_line) {
        this.src_line = src_line;
    }

    public LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.src_line);
    }

    public InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setInstruction(InstructionHandle ih) {
        BranchInstruction.notifyTarget(this.ih, ih, this);
        this.ih = ih;
    }

    public boolean containsTarget(InstructionHandle ih) {
        return this.ih == ih;
    }

    public LineNumberGen(InstructionHandle ih, int src_line) {
        this.setInstruction(ih);
        this.setSourceLine(src_line);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
            return null;
        }
    }

    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        if (old_ih != this.ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.ih + "}");
        }
        this.setInstruction(new_ih);
    }
}

