/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.util;

import com.sun.web.ui.util.ClientType;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;

public class ClientSniffer {
    private String agent = null;
    private int major = -1;

    public ClientSniffer(FacesContext context) {
        StringTokenizer st;
        String version = null;
        this.setUserAgent(context);
        this.agent = this.getUserAgent().toLowerCase();
        if (this.agent != null) {
            st = new StringTokenizer(this.agent, "/");
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                version = st.nextToken();
            }
            if ((st = new StringTokenizer(version)).hasMoreTokens()) {
                version = st.nextToken();
            }
        }
        if (version != null && (st = new StringTokenizer(version, ".")).hasMoreTokens()) {
            try {
                this.major = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
    }

    public static ClientSniffer getInstance(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ClientSniffer sniffer = (ClientSniffer)requestMap.get("__sniffer");
        if (sniffer == null) {
            sniffer = new ClientSniffer(context);
            requestMap.put("__sniffer", sniffer);
        }
        return sniffer;
    }

    protected void setUserAgent(FacesContext context) {
        this.agent = ((String)context.getExternalContext().getRequestHeaderMap().get("USER-AGENT")).toLowerCase();
    }

    public String getUserAgent() {
        return this.agent;
    }

    public int getUserAgentMajor() {
        return this.major;
    }

    public boolean isWin() {
        boolean result = false;
        if (this.agent != null && (this.agent.indexOf("win") != -1 || this.agent.indexOf("16bit") != -1)) {
            result = true;
        }
        return result;
    }

    public boolean isSun() {
        boolean result = false;
        if (this.agent != null && this.agent.indexOf("sunos") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isGecko() {
        boolean result = false;
        if (this.agent != null && this.agent.indexOf("gecko") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav() {
        boolean result = false;
        if (!(this.agent == null || this.agent.indexOf("mozilla") == -1 || this.agent.indexOf("spoofer") != -1 || this.agent.indexOf("compatible") != -1 || this.agent.indexOf("opera") != -1 || this.agent.indexOf("webtv") != -1 || this.agent.indexOf("hotjava") != -1 || this.isGecko() && this.agent.indexOf("netscape") == -1)) {
            result = true;
        }
        return result;
    }

    public boolean isNav4() {
        boolean result = false;
        if (this.isNav() && this.major == 4) {
            result = true;
        }
        return result;
    }

    public boolean isNav4up() {
        boolean result = false;
        if (this.isNav() && this.major >= 4) {
            result = true;
        }
        return result;
    }

    public boolean isNav6() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape6") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav6up() {
        boolean result = false;
        if (this.isNav() && this.major >= 5) {
            result = true;
        }
        return result;
    }

    public boolean isNav7() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape/7") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav70() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape/7.0") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isNav7up() {
        boolean result = false;
        if (this.isNav() && this.major >= 5 && !this.isNav4() && !this.isNav6()) {
            result = true;
        }
        return result;
    }

    public boolean isIe() {
        boolean result = false;
        if (this.agent != null && this.agent.indexOf("msie") != -1 && this.agent.indexOf("opera") == -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe3() {
        boolean result = false;
        if (this.isIe() && this.major < 4) {
            result = true;
        }
        return result;
    }

    public boolean isIe4() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 4") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe5() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 5") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe5up() {
        boolean result = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4()) {
            result = true;
        }
        return result;
    }

    public boolean isIe6() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 6") != -1) {
            result = true;
        }
        return result;
    }

    public boolean isIe6up() {
        boolean result = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4() && !this.isIe5()) {
            result = true;
        }
        return result;
    }

    public static ClientType getClientType(FacesContext context) {
        String agent = ((String)context.getExternalContext().getRequestHeaderMap().get("USER-AGENT")).toLowerCase();
        if (agent == null) {
            return ClientType.OTHER;
        }
        if (agent.indexOf("gecko") != -1) {
            return ClientType.GECKO;
        }
        if (agent.indexOf("msie 6") != -1) {
            return ClientType.IE6;
        }
        if (agent.indexOf("msie 5.5") != -1) {
            return ClientType.IE5_5;
        }
        return ClientType.OTHER;
    }
}

