/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.Wizard;
import com.sun.web.ui.component.WizardStep;
import com.sun.web.ui.component.util.Util;
import com.sun.web.ui.model.WizardStepListItem;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class WizardRenderer
extends AbstractRenderer {
    private static final String ANCHOR = "a";
    private static final String DIV = "div";
    private static final String IMG = "img";
    private static final String INPUT = "input";
    private static final String PARA = "p";
    private static final String SCRIPT = "script";
    private static final String SPAN = "span";
    private static final String TABLE = "table";
    private static final String TD = "td";
    private static final String TR = "tr";
    private static final String ALIGN = "align";
    private static final String ALT = "alt";
    private static final String BORDER = "border";
    private static final String CELLPADDING = "cellpadding";
    private static final String CELLSPACING = "cellspacing";
    private static final String CLASS = "class";
    private static final String STYLE_CLASS = "styleClass";
    private static final String DISABLED = "disabled";
    private static final String HEIGHT = "height";
    private static final String HREF = "href";
    private static final String HSPACE = "hspace";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NOWRAP = "nowrap";
    private static final String ONBLUR = "onblur";
    private static final String ONCLICK = "onclick";
    private static final String ONFOCUS = "onfocus";
    private static final String ONMOUSEOVER = "onmouseover";
    private static final String ONMOUSEOUT = "onmouseout";
    private static final String SRC = "src";
    private static final String STYLE = "style";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String VALIGN = "valign";
    private static final String VALUE = "valign";
    private static final String WIDTH = "width";
    private static final String _1_PERCENT = "1%";
    private static final String _90_PERCENT = "90%";
    private static final String _99_PERCENT = "99%";
    private static final String _100_PERCENT = "100%";
    private static final String BOTTOM = "bottom";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String SUBMIT = "submit";
    private static final String TOP = "top";
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String NBSP = "&nbsp;";
    private static final String STEPS_PANE_SUFFIX = "_stepspane";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String USCORE = "_";
    private static final String WIZARD_JSOBJECT_CLASS = "Wizard";
    private static final String SQUOTE = "'";
    private static final String CLOSEPOPUPJS = "{0}.closePopup();";
    private static final String TOOLTIP = "toolTip";
    private static final String SHOWCONTROLS = "showControls";
    private static final String SHOWSTEPSPANE = "showStepsPane";
    private static final String SHOWSTEPHELP = "showStepHelp";
    private static final String SHOWTITLE = "showTitle";
    private static final String ONPOPUPDISMISS = "onPopupDismiss";
    private static final String WIZARD_SKIP_LINK_ALT = "Wizard.skipLinkAlt";
    private static final String MSG_COMPONENT_NOT_WIZARD = "WizardLayoutRenderer only renders Wizard components.";

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderWizardClose(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(SCRIPT, component);
        writer.writeAttribute(TYPE, (Object)TEXT_JAVASCRIPT, null);
        this.renderJsClose(context, component, writer);
        writer.endElement(SCRIPT);
    }

    protected void renderJsClose(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String onPopupDismiss = (String)component.getAttributes().get(ONPOPUPDISMISS);
        if (onPopupDismiss == null || onPopupDismiss.length() == 0) {
            Object[] args = new Object[]{RenderingUtilities.getJsObjectName(context, component, WIZARD_JSOBJECT_CLASS)};
            onPopupDismiss = MessageFormat.format(CLOSEPOPUPJS, args);
        }
        writer.write(onPopupDismiss);
    }

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof Wizard)) {
            throw new IllegalArgumentException(this.getMessage(MSG_COMPONENT_NOT_WIZARD));
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String formId = EMPTY_STRING;
        UIComponent form = Util.getForm(context, component);
        if (form != null) {
            formId = form.getClientId(context);
        }
        StringBuffer sb = new StringBuffer(SQUOTE);
        sb.append(formId).append(SQUOTE);
        String args = sb.toString();
        RenderingUtilities.renderJsInclude(context, component, theme, writer, "wizard");
        RenderingUtilities.renderJsObject(context, component, writer, WIZARD_JSOBJECT_CLASS, WIZARD_JSOBJECT_CLASS, args);
        if (((Wizard)component).isComplete()) {
            this.renderWizardClose(context, component, theme, writer);
            return;
        }
        this.renderWizardBegin(context, component, theme, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) {
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (((Wizard)component).isComplete()) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderWizard(context, component, theme, writer);
        this.renderWizardEnd(context, component, theme, writer);
    }

    protected void renderWizardBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        String wizId = component.getClientId(context);
        writer.startElement(DIV, component);
        writer.writeAttribute(ID, (Object)wizId, ID);
        String style = (String)component.getAttributes().get(STYLE);
        if (style != null) {
            writer.writeAttribute(STYLE, (Object)style, STYLE);
        }
        String styles = RenderingUtilities.getStyleClasses(context, component, theme.getStyleClass("Wiz"));
        writer.writeAttribute(CLASS, (Object)styles, null);
        String toolTip = (String)component.getAttributes().get(TOOLTIP);
        if (toolTip == null) {
            toolTip = theme.getMessage(WIZARD_SKIP_LINK_ALT);
        }
        this.renderSkipLink(context, component, theme, writer, component.getClientId(context), toolTip);
    }

    protected void renderWizard(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        this.renderTitle(context, component, theme, writer);
        this.renderStepsPane(context, component, theme, writer);
        this.renderTask(context, component, theme, writer);
        this.renderControlBar(context, component, theme, writer);
    }

    protected void renderWizardEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderTitle(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        if (!this.show(component, SHOWTITLE)) {
            return;
        }
        this.renderTitleBegin(context, component, theme, writer);
        this.renderTitleText(context, component, theme, writer);
        this.renderTitleEnd(context, component, theme, writer);
    }

    protected void renderTitleBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizTtl"), null);
        writer.startElement(TABLE, component);
        writer.writeAttribute(BORDER, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLSPACING, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLPADDING, (Object)Integer.toString(0), null);
        writer.writeAttribute(WIDTH, (Object)_100_PERCENT, null);
        writer.startElement(TR, component);
        writer.writeAttribute("valign", (Object)BOTTOM, null);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)BOTTOM, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("TtlTxtDiv"), null);
    }

    protected void renderTitleText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent title = wizard.getTitleComponent();
        if (title != null) {
            title.getAttributes().put(STYLE_CLASS, theme.getStyleClass("TtlTxt"));
            RenderingUtilities.renderComponent(title, context);
        }
    }

    protected void renderTitleEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
        writer.endElement(TABLE);
        writer.endElement(DIV);
    }

    protected void renderStepsPane(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        if (!this.show(component, SHOWSTEPSPANE)) {
            return;
        }
        Wizard wizard = (Wizard)component;
        UIComponent stepsPane = wizard.getStepsPaneComponent();
        if (stepsPane != null) {
            RenderingUtilities.renderComponent(stepsPane, context);
            return;
        }
        this.renderStepsPaneBegin(context, component, theme, writer);
        if (wizard.hasStepHelp() && this.show(component, SHOWSTEPHELP)) {
            this.renderTabs(context, component, theme, writer);
        } else {
            this.renderStepsPaneTitle(context, component, theme, writer);
        }
        if (wizard.isStepsTabActive()) {
            writer.startElement(DIV, component);
            this.renderRule(context, component, theme, writer, 1, 15, EMPTY_STRING);
            writer.endElement(DIV);
            this.renderStepList(context, component, theme, writer);
        } else {
            this.renderStepHelp(context, component, theme, writer);
        }
        this.renderStepsPaneEnd(context, component, theme, writer);
    }

    protected void renderStepsPaneBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        String paneId = component.getClientId(context).concat(STEPS_PANE_SUFFIX);
        writer.startElement(DIV, component);
        writer.writeAttribute(ID, (Object)paneId, null);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStp"), null);
    }

    protected void renderTabs(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent tabs = wizard.getTabsComponent();
        if (tabs == null) {
            return;
        }
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpTab"), null);
        RenderingUtilities.renderComponent(tabs, context);
        writer.endElement(DIV);
    }

    protected void renderStepsPaneTitle(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent stepsPaneTitle = wizard.getStepsPaneTitleComponent();
        if (stepsPaneTitle == null) {
            return;
        }
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpsPnTtlDiv"), null);
        stepsPaneTitle.getAttributes().put(STYLE_CLASS, theme.getStyleClass("WizSubTtlTxt"));
        RenderingUtilities.renderComponent(stepsPaneTitle, context);
        writer.endElement(DIV);
    }

    protected void renderStepList(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent stepList = wizard.getStepListComponent();
        if (stepList != null) {
            RenderingUtilities.renderComponent(stepList, context);
            return;
        }
        writer.startElement(TABLE, component);
        writer.writeAttribute(BORDER, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLSPACING, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLPADDING, (Object)Integer.toString(0), null);
        writer.writeAttribute(WIDTH, (Object)_90_PERCENT, null);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpTbl"), null);
        Iterator stepListIterator = wizard.getStepListIterator();
        while (stepListIterator.hasNext()) {
            WizardStepListItem stepItem = (WizardStepListItem)stepListIterator.next();
            if (stepItem.isSubstep()) {
                this.renderSubstep(context, component, theme, writer, stepItem);
                continue;
            }
            if (stepItem.isCurrentStep()) {
                this.renderCurrentStep(context, component, theme, writer, stepItem);
                continue;
            }
            if (stepItem.isBranch()) {
                this.renderBranchStep(context, component, theme, writer, stepItem);
                continue;
            }
            this.renderStep(context, component, theme, writer, stepItem);
        }
        writer.endElement(TABLE);
    }

    protected void renderCurrentStepIndicator(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent stepIndicator = wizard.getStepIndicatorComponent();
        if (stepIndicator != null) {
            RenderingUtilities.renderComponent(stepIndicator, context);
        }
    }

    protected void renderSubstep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        boolean isCurrentStep = step.isCurrentStep();
        String stepTextStyle = isCurrentStep ? theme.getStyleClass("WizStpCurTxt") : theme.getStyleClass("WizStpTxt");
        writer.startElement(TR, component);
        if (isCurrentStep) {
            writer.startElement(TD, component);
            writer.writeAttribute("valign", (Object)TOP, null);
            writer.writeAttribute(ALIGN, (Object)RIGHT, null);
            writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
            writer.startElement(DIV, component);
            writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpArwDiv"), null);
            this.renderCurrentStepIndicator(context, component, theme, writer);
            writer.endElement(DIV);
            writer.endElement(TD);
        } else {
            writer.startElement(TD, component);
            writer.writeAttribute("valign", (Object)TOP, null);
            writer.endElement(TD);
        }
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(TABLE, component);
        writer.writeAttribute(BORDER, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLSPACING, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLPADDING, (Object)Integer.toString(0), null);
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpTxtDiv"), null);
        this.renderStepNumber(context, component, theme, writer, step, stepTextStyle);
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpTxtDiv"), null);
        this.renderStepSummary(context, component, theme, writer, step, stepTextStyle);
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
        writer.endElement(TABLE);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderBranchStep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
        writer.write(NBSP);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpTxtDiv"), null);
        this.renderStepPlaceholderText(context, component, theme, writer, step);
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderCurrentStep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpArwDiv"), null);
        this.renderCurrentStepIndicator(context, component, theme, writer);
        this.renderStepNumber(context, component, theme, writer, step, theme.getStyleClass("WizStpCurTxt"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpTxtDiv"), null);
        this.renderStepSummary(context, component, theme, writer, step, theme.getStyleClass("WizStpCurTxt"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderStepNumber(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step, String styleClass) throws IOException {
        UIComponent number = ((Wizard)component).getStepNumberComponent(step.getStep(), step.getStepNumberString());
        if (number == null) {
            return;
        }
        number.getAttributes().put(STYLE_CLASS, styleClass);
        RenderingUtilities.renderComponent(number, context);
    }

    protected void renderStepSummary(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step, String styleClass) throws IOException {
        UIComponent text = ((Wizard)component).getStepSummaryComponent(step.getStep());
        if (text == null) {
            return;
        }
        text.getAttributes().put(STYLE_CLASS, styleClass);
        RenderingUtilities.renderComponent(text, context);
    }

    protected void renderStepPlaceholderText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        UIComponent text = ((Wizard)component).getStepPlaceholderTextComponent(step.getStep());
        if (text == null) {
            return;
        }
        text.getAttributes().put(STYLE_CLASS, theme.getStyleClass("WizStpTxt"));
        RenderingUtilities.renderComponent(text, context);
    }

    protected void renderStep(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        writer.startElement(TR, component);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpNumDiv"), null);
        this.renderStepNumber(context, component, theme, writer, step, theme.getStyleClass("WizStpTxt"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)TOP, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizStpTxtDiv"), null);
        this.renderStepSummary(context, component, theme, writer, step, theme.getStyleClass("WizStpTxt"));
        writer.endElement(DIV);
        writer.endElement(TD);
        writer.endElement(TR);
    }

    protected void renderStepHelp(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent stepHelp = ((Wizard)component).getStepHelpComponent();
        if (stepHelp != null) {
            RenderingUtilities.renderComponent(stepHelp, context);
        }
        WizardStep step = ((Wizard)component).getCurrentStep();
        this.renderStepHelpBegin(context, component, theme, writer, step);
        this.renderStepHelpText(context, component, theme, writer, step);
        this.renderStepHelpEnd(context, component, theme, writer, step);
    }

    protected void renderStepHelpBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizHlpDiv"), null);
        writer.startElement(PARA, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizHlpTxt"), null);
    }

    protected void renderStepHelpText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepHelp = ((Wizard)component).getStepHelpTextComponent();
        if (stepHelp != null) {
            RenderingUtilities.renderComponent(stepHelp, context);
        }
    }

    protected void renderStepHelpEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(PARA);
        writer.endElement(DIV);
    }

    protected void renderStepsPaneEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderTask(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent task = ((Wizard)component).getTaskComponent();
        if (task != null) {
            RenderingUtilities.renderComponent(task, context);
            return;
        }
        WizardStep step = ((Wizard)component).getCurrentStep();
        if (step == null) {
            return;
        }
        this.renderTaskBegin(context, component, theme, writer);
        this.renderTaskHeader(context, component, theme, writer, step);
        this.renderStepTask(context, component, theme, writer, step);
        this.renderTaskEnd(context, component, theme, writer);
    }

    protected void renderTaskBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        String idandclass = theme.getStyleClass("WizBdy");
        writer.startElement(DIV, component);
        writer.writeAttribute(ID, (Object)component.getClientId(context).concat(USCORE).concat(idandclass), null);
        writer.writeAttribute(CLASS, (Object)idandclass, null);
        this.renderSkipAnchor(context, component, theme, writer, component.getClientId(context));
    }

    protected void renderTaskEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderTaskHeader(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent taskHeader = ((Wizard)component).getTaskHeaderComponent();
        if (taskHeader != null) {
            RenderingUtilities.renderComponent(taskHeader, context);
            return;
        }
        this.renderStepTitle(context, component, theme, writer, step);
        this.renderStepDetail(context, component, theme, writer, step);
    }

    protected void renderStepTitleLabel(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        this.renderStepTitleLabelBegin(context, component, theme, writer, step);
        this.renderStepTitleLabelText(context, component, theme, writer, step);
        this.renderStepTitleLabelEnd(context, component, theme, writer, step);
    }

    protected void renderStepTitleLabelBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)BOTTOM, null);
        writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
    }

    protected void renderStepTitleLabelText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent titleLabel = ((Wizard)component).getStepTitleLabelTextComponent();
        if (titleLabel != null) {
            titleLabel.getAttributes().put(STYLE_CLASS, theme.getStyleClass("WizSubTtlTxt"));
            RenderingUtilities.renderComponent(titleLabel, context);
        }
    }

    protected void renderStepTitleLabelEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(TD);
    }

    protected void renderStepTitle(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepTitle = ((Wizard)component).getStepTitleComponent();
        if (stepTitle != null) {
            RenderingUtilities.renderComponent(stepTitle, context);
            return;
        }
        this.renderStepTitleBegin(context, component, theme, writer, step);
        this.renderStepTitleLabel(context, component, theme, writer, step);
        this.renderStepTitleText(context, component, theme, writer, step);
        this.renderStepTitleEnd(context, component, theme, writer, step);
    }

    protected void renderStepTitleBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)"WizSubTtlDiv", null);
        writer.startElement(TABLE, component);
        writer.writeAttribute(BORDER, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLSPACING, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLPADDING, (Object)Integer.toString(0), null);
        writer.writeAttribute(WIDTH, (Object)_99_PERCENT, null);
        writer.startElement(TR, component);
        writer.writeAttribute("valign", (Object)BOTTOM, null);
    }

    protected void renderStepTitleText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)BOTTOM, null);
        writer.writeAttribute(WIDTH, (Object)_99_PERCENT, null);
        UIComponent stepTitle = ((Wizard)component).getStepTitleTextComponent();
        if (stepTitle != null) {
            stepTitle.getAttributes().put(STYLE_CLASS, theme.getStyleClass("WizSubTtlTxt"));
            RenderingUtilities.renderComponent(stepTitle, context);
        }
        writer.endElement(TD);
    }

    protected void renderStepTitleEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(TR);
        writer.endElement(TABLE);
        writer.endElement(DIV);
    }

    protected void renderStepDetail(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepDetail = ((Wizard)component).getStepDetailComponent();
        if (stepDetail != null) {
            RenderingUtilities.renderComponent(stepDetail, context);
            return;
        }
        this.renderStepDetailBegin(context, component, theme, writer, step);
        this.renderStepDetailText(context, component, theme, writer, step);
        this.renderStepDetailEnd(context, component, theme, writer, step);
    }

    protected void renderStepDetailBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)"WizCntHlpTxt", null);
    }

    protected void renderStepDetailText(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent stepDetail = ((Wizard)component).getStepDetailTextComponent();
        if (stepDetail != null) {
            RenderingUtilities.renderComponent(stepDetail, context);
        }
    }

    protected void renderStepDetailEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderStepTaskBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("WizTsk"), null);
    }

    protected void renderStepTask(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        UIComponent task = ((Wizard)component).getTaskStepComponent();
        if (task != null) {
            RenderingUtilities.renderComponent(task, context);
            return;
        }
        this.renderStepTaskBegin(context, component, theme, writer, step);
        this.renderStepTaskComponents(context, component, theme, writer, step);
        this.renderStepTaskEnd(context, component, theme, writer, step);
    }

    protected void renderStepTaskEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        writer.endElement(DIV);
    }

    protected void renderControlBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        if (!this.show(component, SHOWCONTROLS)) {
            return;
        }
        UIComponent controlBar = ((Wizard)component).getControlBarComponent();
        if (controlBar != null) {
            RenderingUtilities.renderComponent(controlBar, context);
            return;
        }
        this.renderControlBarBegin(context, component, theme, writer);
        this.renderLeftControlBar(context, component, theme, writer);
        this.renderRightControlBar(context, component, theme, writer);
        this.renderControlBarEnd(context, component, theme, writer);
    }

    protected void renderControlBarBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)"WizBtn", null);
        writer.startElement(TABLE, component);
        writer.writeAttribute(BORDER, (Object)Integer.toString(0), null);
        writer.writeAttribute(CELLSPACING, (Object)Integer.toString(10), null);
        writer.writeAttribute(CELLPADDING, (Object)Integer.toString(0), null);
        writer.writeAttribute(WIDTH, (Object)_100_PERCENT, null);
        writer.startElement(TR, component);
    }

    protected void renderControlBarEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(TR);
        writer.endElement(TABLE);
        writer.endElement(DIV);
    }

    protected void renderLeftControlBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent leftControlBar = wizard.getLeftControlBarComponent();
        if (leftControlBar != null) {
            RenderingUtilities.renderComponent(leftControlBar, context);
            return;
        }
        this.renderLeftControlBarBegin(context, component, theme, writer);
        if (wizard.hasPrevious()) {
            this.renderPreviousControl(context, component, theme, writer);
        }
        if (wizard.hasNext()) {
            this.renderNextControl(context, component, theme, writer);
        } else if (wizard.hasFinish()) {
            this.renderFinishControl(context, component, theme, writer);
        }
        this.renderLeftControlBarEnd(context, component, theme, writer);
    }

    protected void renderLeftControlBarBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)BOTTOM, null);
        writer.writeAttribute(NOWRAP, (Object)NOWRAP, null);
        writer.writeAttribute(WIDTH, (Object)_1_PERCENT, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)"WizBtnDiv", null);
    }

    protected void renderPreviousControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getPreviousComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderNextControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent nextControl = wizard.getNextComponent();
        if (nextControl == null) {
            return;
        }
        this.renderControl(context, theme, nextControl);
    }

    protected void renderFinishControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getFinishComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderLeftControlBarEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
        writer.endElement(TD);
    }

    protected void renderRightControlBar(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent rightControlBar = wizard.getRightControlBarComponent();
        if (rightControlBar != null) {
            RenderingUtilities.renderComponent(rightControlBar, context);
            return;
        }
        this.renderRightControlBarBegin(context, component, theme, writer);
        if (wizard.hasCancel()) {
            this.renderCancelControl(context, component, theme, writer);
        } else if (wizard.hasClose()) {
            this.renderCloseControl(context, component, theme, writer);
        }
        this.renderRightControlBarEnd(context, component, theme, writer);
    }

    protected void renderRightControlBarBegin(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement(TD, component);
        writer.writeAttribute("valign", (Object)BOTTOM, null);
        writer.writeAttribute(ALIGN, (Object)RIGHT, null);
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)"WizBtnDiv", null);
    }

    protected void renderCancelControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getCancelComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderCloseControl(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        Wizard wizard = (Wizard)component;
        UIComponent control = wizard.getCloseComponent();
        if (control == null) {
            return;
        }
        this.renderControl(context, theme, control);
    }

    protected void renderRightControlBarEnd(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        writer.endElement(DIV);
        writer.endElement(TD);
    }

    private void renderSkipLink(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, String link, String alt) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("SkpWht"), null);
        writer.startElement(ANCHOR, component);
        writer.writeAttribute(HREF, (Object)("#" + link), null);
        this.renderRule(context, component, theme, writer, 1, 1, alt);
        writer.endElement(ANCHOR);
        writer.endElement(DIV);
    }

    private void renderSkipAnchor(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, String anchor) throws IOException {
        writer.startElement(DIV, component);
        writer.writeAttribute(CLASS, (Object)theme.getStyleClass("SkpWht"), null);
        writer.startElement(ANCHOR, component);
        writer.writeAttribute(NAME, (Object)anchor, null);
        writer.writeAttribute(ID, (Object)anchor, null);
        writer.endElement(ANCHOR);
        writer.endElement(DIV);
    }

    private void renderRule(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, int width, int height, String alt) throws IOException {
        Icon icon = theme.getIcon("DOT");
        if (alt != null) {
            icon.setAlt(alt);
        }
        icon.setHeight(height);
        icon.setWidth(width);
        RenderingUtilities.renderComponent((UIComponent)icon, context);
    }

    private boolean show(UIComponent component, String feature) {
        return true;
    }

    protected void renderStepTaskComponents(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStep step) throws IOException {
        RenderingUtilities.renderComponent((UIComponent)step, context);
    }

    private String mergeStyle(String styles, String newStyle) {
        if (newStyle == null) {
            return styles;
        }
        if (styles == null) {
            return newStyle;
        }
        StringBuffer sb = new StringBuffer(styles);
        String[] splitStyles = styles.split(SPACE);
        for (int i = 0; i < splitStyles.length; ++i) {
            if (!splitStyles[i].equals(newStyle)) continue;
            return sb.toString();
        }
        sb.append(SPACE).append(newStyle);
        return sb.toString();
    }

    private void renderControl(FacesContext context, Theme theme, UIComponent control) throws IOException {
        RenderingUtilities.renderComponent(control, context);
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }

    private String getMessage(String key) {
        return key;
    }

    protected void renderStepNumber(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        UIComponent number = ((Wizard)component).getStepNumberComponent(step.getStep(), step.getStepNumberString());
        if (number == null) {
            return;
        }
        RenderingUtilities.renderComponent(number, context);
    }

    protected void renderStepSummary(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer, WizardStepListItem step) throws IOException {
        UIComponent text = ((Wizard)component).getStepSummaryComponent(step.getStep());
        if (text == null) {
            return;
        }
        RenderingUtilities.renderComponent(text, context);
    }
}

