/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.data.provider.SortCriteria;
import com.sun.web.ui.component.TableColumn;
import com.sun.web.ui.component.TableRowGroup;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TableColumnRenderer
extends Renderer {
    private static final String[] stringAttributes = new String[]{"abbr", "axis", "bgColor", "char", "charOff", "dir", "headers", "height", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign", "width"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TableColumn col = (TableColumn)component;
        Iterator kids = col.getTableColumnChildren();
        if (!kids.hasNext()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderEnclosingTagStart(context, col, writer);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableColumn col = (TableColumn)component;
        Iterator kids = col.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn kid = (TableColumn)((Object)kids.next());
                if (!kid.isRendered()) {
                    this.log("encodeChildren", "TableColumn not rendered, nothing to display");
                    continue;
                }
                RenderingUtilities.renderComponent((UIComponent)kid, context);
            }
        } else if (col.isEmptyCell()) {
            RenderingUtilities.renderComponent(col.getEmptyCellIcon(), context);
        } else {
            kids = col.getChildren().iterator();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (!kid.isRendered()) {
                    this.log("encodeChildren", "TableColumn child not rendered, nothing to display");
                    continue;
                }
                RenderingUtilities.renderComponent(kid, context);
                if (!kids.hasNext() || !col.isEmbeddedActions()) continue;
                RenderingUtilities.renderComponent(col.getEmbeddedActionSeparatorIcon(), context);
                ResponseWriter writer = context.getResponseWriter();
                writer.writeText((Object)" ", null);
            }
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            this.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            this.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TableColumn col = (TableColumn)component;
        Iterator kids = col.getTableColumnChildren();
        if (!kids.hasNext()) {
            ResponseWriter writer = context.getResponseWriter();
            this.renderEnclosingTagEnd(context, col, writer);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderEnclosingTagStart(FacesContext context, TableColumn component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagStart", "Cannot render enclosing tag, UIComponent is null");
            return;
        }
        boolean isRowHeader = component.isRowHeader() && component.getSelectId() == null;
        writer.writeText((Object)"\n", null);
        writer.startElement(isRowHeader ? "th" : "td", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, this.getStyleClass(component));
        if (component.getAlign() != null) {
            writer.writeAttribute("align", (Object)component.getAlign(), null);
        }
        if (isRowHeader) {
            writer.writeAttribute("scope", (Object)"row", null);
        } else if (component.getScope() != null) {
            writer.writeAttribute("scope", (Object)component.getScope(), null);
        }
        if (component.getColSpan() > -1) {
            writer.writeAttribute("colspan", (Object)Integer.toString(component.getColSpan()), null);
        }
        if (component.getRowSpan() > -1) {
            writer.writeAttribute("rowspan", (Object)Integer.toString(component.getRowSpan()), null);
        }
        if (component.isNoWrap()) {
            writer.writeAttribute("nowrap", (Object)"nowrap", null);
        }
        if (component.getToolTip() != null) {
            writer.writeAttribute("title", (Object)component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, stringAttributes);
    }

    protected void renderEnclosingTagEnd(FacesContext context, TableColumn component, ResponseWriter writer) throws IOException {
        if (component == null) {
            this.log("renderEnclosingTagEnd", "Cannot render enclosing tag, UIComponent is null");
            return;
        }
        boolean isRowHeader = component.isRowHeader() && component.getSelectId() == null;
        writer.endElement(isRowHeader ? "th" : "td");
    }

    private String getStyleClass(TableColumn component) {
        int level;
        String styleClass = null;
        if (component == null) {
            this.log("getStyleClass", "Cannot obtain style class, TableColumn is null");
            return styleClass;
        }
        TableRowGroup group = component.getTableRowGroupAncestor();
        SortCriteria criteria = component.getSortCriteria();
        int n = level = group != null ? group.getSortLevel(criteria) : -1;
        styleClass = component.isSpacerColumn() ? "TblTdSpc" : (component.getSeverity() != null && !component.getSeverity().equals("ok") ? "TblTdAlm" : (level == 1 ? (component.getSelectId() != null ? "TblTdSrtSel" : "TblTdSrt") : (component.getSelectId() != null ? "TblTdSel" : "TblTdLyt")));
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

