/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.Scheduler;
import com.sun.web.ui.component.Time;
import com.sun.web.ui.model.ClockTime;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.model.ScheduledEvent;
import com.sun.web.ui.model.scheduler.RepeatInterval;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class SchedulerRenderer
extends Renderer {
    private static final String SPACE = "&nbsp;";
    private static final boolean DEBUG = false;

    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!(component instanceof Scheduler)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Scheduler.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        Scheduler scheduler = (Scheduler)component;
        if (scheduler.getSubmittedValue() != null) {
            this.updateDatePicker(scheduler, context);
        } else {
            this.initializeValues(scheduler, context);
        }
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        String spacerPath = theme.getIcon("DOT").getUrl();
        this.includeJsFile(writer, scheduler, theme.getPathToJSFile("scheduler"));
        this.renderEnclosingDiv(scheduler, context, writer);
        writer.writeText((Object)"\n", null);
        this.renderOpenTable((UIComponent)scheduler, writer);
        writer.writeText((Object)"\n", null);
        this.renderLegendRow(scheduler, theme, writer, context);
        writer.writeText((Object)"\n", null);
        this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 2, writer);
        writer.writeText((Object)"\n", null);
        this.renderControlRow(scheduler, theme, spacerPath, writer, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        writer.write(this.getJavaScriptInitializer(scheduler, context));
    }

    private void initializeValues(Scheduler scheduler, FacesContext context) {
        Object value = scheduler.getValue();
        if (value != null && value instanceof ScheduledEvent) {
            ScheduledEvent event = (ScheduledEvent)value;
            scheduler.getDatePicker().setValue(event);
            scheduler.getDatePicker().displayValue();
            ((EditableValueHolder)scheduler.getDateComponent()).setValue((Object)event.getStartTime());
            scheduler.getDatePicker().setValue(event);
            if (scheduler.isStartTime()) {
                scheduler.getStartTimeComponent().setValue(this.getClockTime(scheduler, event.getStartTime()));
            }
            if (scheduler.isEndTime()) {
                scheduler.getEndTimeComponent().setValue(this.getClockTime(scheduler, event.getEndTime()));
            }
            if (scheduler.isRepeating()) {
                RepeatInterval ri = event.getRepeatInterval();
                scheduler.getRepeatIntervalComponent().setValue(ri);
                if (scheduler.isLimitRepeating()) {
                    DropDown unitDropDown = scheduler.getRepeatUnitComponent();
                    UIComponent comp = scheduler.getRepeatingFieldComponent();
                    if (ri == null || ri.getRepresentation().equals("ONETIME")) {
                        unitDropDown.setDisabled(true);
                        unitDropDown.setValue(null);
                        ((EditableValueHolder)comp).setValue(null);
                        comp.getAttributes().put("disabled", Boolean.TRUE);
                    } else {
                        unitDropDown.setDisabled(false);
                        unitDropDown.setValue(event.getDurationUnit());
                        ((EditableValueHolder)comp).setValue((Object)event.getDuration());
                        comp.getAttributes().put("disabled", Boolean.FALSE);
                    }
                }
            }
        } else {
            scheduler.getDatePicker().setValue(null);
            ((EditableValueHolder)scheduler.getDateComponent()).setValue(null);
            if (scheduler.isStartTime()) {
                scheduler.getStartTimeComponent().setValue(null);
            }
            if (scheduler.isEndTime()) {
                scheduler.getEndTimeComponent().setValue(null);
            }
            if (scheduler.isRepeating()) {
                scheduler.getRepeatIntervalComponent().setValue("ONETIME");
                if (scheduler.isLimitRepeating()) {
                    scheduler.getRepeatUnitComponent().setValue(null);
                    scheduler.getRepeatUnitComponent().setDisabled(true);
                    ((EditableValueHolder)scheduler.getRepeatingFieldComponent()).setValue(null);
                    scheduler.getRepeatingFieldComponent().getAttributes().put("disabled", Boolean.TRUE);
                }
            }
        }
    }

    private void updateDatePicker(Scheduler scheduler, FacesContext context) {
        block4: {
            try {
                Object value = scheduler.getConvertedValue(context, null);
                scheduler.getDatePicker().setValue(value);
            }
            catch (Exception ex) {
                UIComponent comp = scheduler.getDateComponent();
                Object value = ((EditableValueHolder)comp).getSubmittedValue();
                if (value == null) break block4;
                try {
                    Object dO = ConversionUtilities.convertValueToObject(comp, (String)value, context);
                    scheduler.getDatePicker().setValue(dO);
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
    }

    private ClockTime getClockTime(Scheduler scheduler, Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = scheduler.getDatePicker().getCalendar();
        calendar.setTime(date);
        ClockTime clockTime = new ClockTime();
        clockTime.setHour(new Integer(calendar.get(11)));
        clockTime.setMinute(new Integer(calendar.get(12)));
        return clockTime;
    }

    private void includeJsFile(ResponseWriter writer, Scheduler scheduler, String src) throws IOException {
        writer.startElement("script", (UIComponent)scheduler);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    private void renderEnclosingDiv(Scheduler scheduler, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)scheduler);
        writer.writeAttribute("id", (Object)scheduler.getClientId(context), null);
        String style = scheduler.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((style = scheduler.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)style, "styleClass");
        }
    }

    private void renderOpenTable(UIComponent comp, ResponseWriter writer) throws IOException {
        writer.startElement("table", comp);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
    }

    private void renderLegendRow(Scheduler scheduler, Theme theme, ResponseWriter writer, FacesContext context) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        if (scheduler.isRequiredLegend()) {
            writer.writeText((Object)"\n", null);
            writer.startElement("div", (UIComponent)scheduler);
            writer.writeAttribute("align", (Object)"right", null);
            writer.writeAttribute("class", (Object)theme.getStyleClass("LblRqdDiv"), null);
            writer.writeText((Object)"\n", null);
            Icon icon = theme.getIcon("LABEL_REQUIRED_ICON");
            icon.setId(scheduler.getId().concat("_icon"));
            RenderingUtilities.renderComponent((UIComponent)icon, context);
            writer.writeText((Object)"\n", null);
            writer.write(theme.getMessage("Scheduler.requiredLegend"));
            writer.writeText((Object)"\n", null);
            writer.endElement("div");
            writer.writeText((Object)"\n", null);
        } else {
            writer.write(SPACE);
        }
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderSpacerRow(UIComponent component, String path, int height, int width, int colspan, ResponseWriter writer) throws IOException {
        writer.startElement("tr", component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", component);
        writer.writeAttribute("colspan", (Object)String.valueOf(colspan), null);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage(component, path, height, width, writer);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderSpacerImage(UIComponent component, String path, int height, int width, ResponseWriter writer) throws IOException {
        writer.startElement("img", component);
        writer.writeAttribute("src", (Object)path, null);
        writer.writeAttribute("height", (Object)String.valueOf(height), null);
        writer.writeAttribute("width", (Object)String.valueOf(width), null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.endElement("img");
    }

    private void renderControlRow(Scheduler scheduler, Theme theme, String spacerPath, ResponseWriter writer, FacesContext context) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)scheduler.getDatePicker(), context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        this.renderInputControls(context, scheduler, writer, theme, spacerPath);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderInputControls(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        boolean unsetLabel;
        UIComponent label;
        this.renderOpenTable((UIComponent)scheduler, writer);
        writer.writeText((Object)"\n", null);
        this.renderStartDateRow(scheduler, spacerPath, theme, context, writer);
        writer.writeText((Object)"\n", null);
        this.renderHelpTextRow(scheduler, theme, writer);
        writer.writeText((Object)"\n", null);
        if (scheduler.isStartTime()) {
            label = scheduler.getStartTimeLabelComponent(theme);
            unsetLabel = false;
            if (label instanceof Label && ((Label)label).getText() == null) {
                ((Label)label).setText(theme.getMessage("Scheduler.startTime"));
                unsetLabel = true;
            }
            this.renderTimeRow(scheduler, label, scheduler.getStartTimeComponent(), theme, spacerPath, context, writer);
            writer.writeText((Object)"\n", null);
            if (unsetLabel) {
                ((Label)label).setText(null);
            }
        }
        if (scheduler.isEndTime()) {
            label = scheduler.getEndTimeLabelComponent(theme);
            unsetLabel = false;
            if (label instanceof Label && ((Label)label).getText() == null) {
                ((Label)label).setText(theme.getMessage("Scheduler.endTime"));
            }
            this.renderTimeRow(scheduler, label, scheduler.getEndTimeComponent(), theme, spacerPath, context, writer);
            writer.writeText((Object)"\n", null);
            if (unsetLabel) {
                ((Label)label).setText(null);
            }
        }
        if (scheduler.isRepeating()) {
            this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
            this.renderRepeatIntervalRow(scheduler, theme, context, writer);
            if (scheduler.isLimitRepeating()) {
                this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
                this.renderRepeatLimitRow(context, scheduler, writer, theme, spacerPath);
                this.renderRepeatLegend(scheduler, theme, context, writer);
            }
        }
        if (scheduler.isPreviewButton()) {
            this.renderSpacerRow((UIComponent)scheduler, spacerPath, 20, 1, 4, writer);
            this.renderPreviewRow(context, scheduler, writer, theme);
        }
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    private void renderTimeRow(Scheduler scheduler, UIComponent label, Time time, Theme theme, String spacerPath, FacesContext context, ResponseWriter writer) throws IOException {
        this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
        writer.writeText((Object)"\n", null);
        this.renderInputRowStart(scheduler, writer, theme);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)time, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
    }

    private void renderStartDateRow(Scheduler scheduler, String spacerPath, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent date = scheduler.getDateComponent();
        UIComponent label = scheduler.getDateLabelComponent(theme);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage((UIComponent)scheduler, spacerPath, 1, 30, writer);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage((UIComponent)scheduler, spacerPath, 1, 10, writer);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(date, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderHelpTextRow(Scheduler scheduler, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("colspan", (Object)"3", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)scheduler);
        String styleClass = theme.getStyleClass("HlpFldTxt");
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.write(this.getPattern(scheduler));
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private String getPattern(Scheduler scheduler) {
        String pattern = scheduler.getDateFormatPatternHelp();
        if (pattern == null) {
            pattern = scheduler.getDatePicker().getDateFormatPattern().toLowerCase();
        }
        return pattern;
    }

    private void renderPreviewRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("colspan", (Object)"3", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        Button button = scheduler.getPreviewButtonComponent();
        button.setText(theme.getMessage("Scheduler.preview"));
        RenderingUtilities.renderComponent((UIComponent)button, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatIntervalRow(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        Object o;
        UIComponent label = scheduler.getRepeatIntervalLabelComponent();
        if (label instanceof Label && ((o = ((Label)label).getText()) == null || o.toString().length() == 0)) {
            ((Label)label).setText(theme.getMessage("Scheduler.repeatInterval"));
        }
        DropDown menu = scheduler.getRepeatIntervalComponent();
        Option[] options = (Option[])scheduler.getRepeatIntervalItems();
        menu.setItems(options);
        menu.setToolTip(theme.getMessage("Scheduler.repeatIntervalDesc"));
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.write(SPACE);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)scheduler);
        writer.writeAttribute("class", (Object)theme.getStyleClass("DatLblTxt"), null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.write(SPACE);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)menu, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderInputRowStart(Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)scheduler);
        String styleClass = theme.getStyleClass("DatLblTxt");
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatLimitRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        Object o;
        UIComponent label = scheduler.getRepeatLimitLabelComponent();
        if (label instanceof Label && ((o = ((Label)label).getText()) == null || o.toString().length() == 0)) {
            ((Label)label).setText(theme.getMessage("Scheduler.repeatLimit"));
        }
        DropDown repeatMenu = scheduler.getRepeatIntervalComponent();
        UIComponent field = scheduler.getRepeatingFieldComponent();
        DropDown menu = scheduler.getRepeatUnitComponent();
        Option[] options = (Option[])scheduler.getRepeatUnitItems();
        menu.setItems(options);
        menu.setToolTip(theme.getMessage("Scheduler.repeatUnitDesc"));
        this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
        writer.writeText((Object)"\n", null);
        this.renderInputRowStart(scheduler, writer, theme);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("span");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        RenderingUtilities.renderComponent(field, context);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)menu, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatLegend(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.write("\n");
        for (int i = 0; i < 3; ++i) {
            writer.startElement("td", (UIComponent)scheduler);
            writer.write(SPACE);
            writer.endElement("td");
            writer.write("\n");
        }
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.startElement("div", (UIComponent)scheduler);
        writer.write(theme.getMessage("Scheduler.blankForWhat"));
        writer.write("\n");
        writer.endElement("div");
        writer.write("\n");
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
        writer.write("\n");
    }

    private String getJavaScriptInitializer(Scheduler scheduler, FacesContext context) {
        String jsName = scheduler.getJavaScriptObjectName(context);
        StringBuffer js = new StringBuffer(128);
        js.append("\n<script type=\"text/javascript\">\nvar ");
        js.append(jsName);
        js.append(" = new Scheduler('");
        js.append(scheduler.getClientId(context));
        js.append("', '");
        js.append(scheduler.getDateComponent().getClientId(context));
        js.append("');</script>\n");
        return js.toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }
}

