/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.RadioButton;
import com.sun.web.ui.component.RadioButtonGroup;
import com.sun.web.ui.model.Option;
import com.sun.web.ui.renderer.SelectorGroupRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ConversionUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class RadioButtonGroupRenderer
extends SelectorGroupRenderer {
    private final String MSG_COMPONENT_NOT_RADIOBUTTONGROUP = "RadioButtonGroupRender only renders RadioButtonGroup components.";
    protected String[] styles = new String[]{"RbGrp", "RbGrpCpt", "RbGrpLbl", "RbGrpLblDis", "RbGrpRwEv", "RbGrpRwOd", "RbGrpClEv", "RbGrpClOd", "Rb", "RbDis", "RbLbl", "RbLblDis", "RbImg", "RbImgDis", "LblLev1Txt", "LblLev2Txt", "LblLev3Txt"};

    public void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof RadioButtonGroup)) {
            throw new IllegalArgumentException("RadioButtonGroupRender only renders RadioButtonGroup components.");
        }
    }

    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        RadioButtonGroup rbgrp = (RadioButtonGroup)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderSelectorGroup(context, component, theme, writer, rbgrp.getColumns());
    }

    protected UIComponent getSelectorComponent(FacesContext context, UIComponent component, Theme theme, String id, Option option) {
        RadioButtonGroup rbgrp = (RadioButtonGroup)component;
        RadioButton rb = new RadioButton();
        rb.setId(id);
        rb.setParent(component);
        rb.setName(rbgrp.getClientId(context));
        rb.setToolTip(option.getTooltip());
        rb.setImageURL(option.getImage());
        rb.setSelectedValue(option.getValue());
        rb.setLabel(option.getLabel());
        rb.setDisabled(rbgrp.isDisabled());
        rb.setReadOnly(rbgrp.isReadOnly());
        rb.setTabIndex(rbgrp.getTabIndex());
        rb.setSelected(null);
        String[] subValue = (String[])rbgrp.getSubmittedValue();
        if (subValue == null) {
            if (this.isSelected(option, rbgrp.getSelected())) {
                rb.setSelected(rb.getSelectedValue());
            }
        } else if (subValue.length != 0) {
            Object selectedValue = rb.getSelectedValue();
            String selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
            if (subValue[0] != null && subValue[0].equals(selectedValueAsString)) {
                rb.setSelected(rb.getSelectedValue());
            }
        }
        return rb;
    }

    private boolean isSelected(Option item, Object currentValue) {
        return currentValue != null && item.getValue() != null && item.getValue().equals(currentValue);
    }

    protected String[] getStyles() {
        return this.styles;
    }
}

