/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.PageAlert;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class PageAlertRenderer
extends AbstractRenderer {
    public static final String PAGETITLE_BUTTON_FACET = "pageButtons";

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null || writer == null) {
            throw new NullPointerException();
        }
        PageAlert pagealert = (PageAlert)component;
        writer.startElement("div", component);
        this.addCoreAttributes(context, component, writer, null);
        this.renderAlert(context, component, writer);
        this.renderSeparator(context, component, writer);
        this.renderButtons(context, component, writer);
        writer.endElement("div");
    }

    protected void renderAlertSummary(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        String summary = pagealert.getSummary();
        if (summary == null || summary.trim().length() == 0) {
            return;
        }
        writer.startElement("div", (UIComponent)pagealert);
        String style = theme.getStyleClass("FulAlrtHdrDiv");
        RenderingUtilities.renderStyleClass(context, writer, component, style);
        writer.startElement("span", (UIComponent)pagealert);
        style = theme.getStyleClass("FulAlrtHdrTxt");
        writer.writeAttribute("class", (Object)style, null);
        this.renderFormattedMessage(writer, component, context, summary);
        writer.endElement("span");
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderAlertDetail(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        String detail = pagealert.getDetail();
        if (detail == null || detail.trim().length() == 0) {
            return;
        }
        writer.startElement("div", (UIComponent)pagealert);
        String style = theme.getStyleClass("FulAlrtMsgDiv");
        writer.writeAttribute("class", (Object)style, null);
        writer.startElement("span", (UIComponent)pagealert);
        style = theme.getStyleClass("AlrtMsgTxt");
        writer.writeAttribute("class", (Object)style, null);
        this.renderFormattedMessage(writer, component, context, detail);
        writer.endElement("span");
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
    }

    protected void renderAlertIcon(FacesContext context, UIComponent component, Theme theme, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        writer.startElement("table", component);
        writer.writeAttribute("title", (Object)"", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.startElement("tbody", component);
        writer.startElement("tr", component);
        writer.writeAttribute("valign", (Object)"bottom", null);
        writer.startElement("td", component);
        writer.writeAttribute("valign", (Object)"bottom", null);
        writer.startElement("div", component);
        UIComponent titleFacet = pagealert.getFacet("pageAlertTitle");
        if (titleFacet == null) {
            String style = theme.getStyleClass("TtlTxtDiv");
            writer.writeAttribute("class", (Object)style, null);
            writer.startElement("h1", component);
            style = theme.getStyleClass("TtlTxt");
            writer.writeAttribute("class", (Object)style, null);
            UIComponent image = pagealert.getPageAlertImage();
            RenderingUtilities.renderComponent(image, context);
            writer.write(pagealert.getSafeTitle());
            writer.endElement("h1");
        } else {
            RenderingUtilities.renderComponent(titleFacet, context);
        }
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void renderAlert(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderAlertIcon(context, component, theme, writer);
        this.renderAlertSummary(context, component, theme, writer);
        this.renderAlertDetail(context, component, theme, writer);
        UIComponent inputComponent = pagealert.getPageAlertInput();
        if (inputComponent != null) {
            writer.startElement("div", (UIComponent)pagealert);
            String style = theme.getStyleClass("FulAlrtFrmDiv");
            RenderingUtilities.renderStyleClass(context, writer, component, style);
            RenderingUtilities.renderComponent(inputComponent, context);
            writer.endElement("div");
            writer.writeText((Object)"\n", null);
        }
    }

    private void renderSeparator(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        PageAlert pageAlert = (PageAlert)component;
        UIComponent separator = pageAlert.getPageAlertSeparator();
        RenderingUtilities.renderComponent(separator, context);
    }

    private void renderButtons(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        PageAlert pagealert = (PageAlert)component;
        UIComponent buttonFacet = pagealert.getPageAlertButtons();
        if (buttonFacet == null) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("table", (UIComponent)pagealert);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.startElement("tr", (UIComponent)pagealert);
        String style = theme.getStyleClass("TtlBtnBtmDiv");
        writer.startElement("td", (UIComponent)pagealert);
        writer.writeAttribute("align", (Object)"right", null);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeAttribute("valign", (Object)"bottom", null);
        writer.startElement("div", (UIComponent)pagealert);
        writer.writeAttribute("class", (Object)style, null);
        RenderingUtilities.renderComponent(buttonFacet, context);
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void renderFormattedMessage(ResponseWriter writer, UIComponent component, FacesContext context, String msg) throws IOException {
        ArrayList<Object> parameterList = new ArrayList<Object>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UIParameter)) continue;
            parameterList.add(((UIParameter)kid).getValue());
        }
        String message = null;
        message = parameterList.size() > 0 ? MessageFormat.format(msg, parameterList.toArray(new Object[parameterList.size()])) : msg;
        if (message != null) {
            PageAlert pa = (PageAlert)component;
            if (!pa.isEscape()) {
                writer.write(message);
            } else {
                writer.writeText((Object)message, "message");
            }
        }
    }
}

