/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Message;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.FacesMessageUtils;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.beans.Beans;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageRenderer
extends AbstractRenderer {
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Message message = (Message)component;
        String forComponentId = message.getFor();
        FacesMessage msg = null;
        Iterator msgIt = null;
        if (Beans.isDesignTime()) {
            String summary = null;
            summary = forComponentId == null || forComponentId.length() == 0 ? MessageUtil.getMessage(context, "com.sun.web.ui.renderer.Bundle", "Message.default.summary") : MessageUtil.getMessage(context, "com.sun.web.ui.renderer.Bundle", "Message.for.summary", (Object[])new String[]{forComponentId});
            this.renderMessage(context, component, writer, new FacesMessage(summary));
        } else if (forComponentId != null && (msgIt = FacesMessageUtils.getMessageIterator(context, forComponentId, (UIComponent)message)).hasNext()) {
            msg = (FacesMessage)msgIt.next();
            this.renderMessage(context, component, writer, msg);
        }
    }

    public void renderMessage(FacesContext context, UIComponent component, ResponseWriter writer, FacesMessage fMsg) throws IOException {
        String styleClass;
        Message message = (Message)component;
        String summary = null;
        String detail = null;
        if (message.isShowSummary() && (summary = fMsg.getSummary()) != null && summary.length() <= 0) {
            summary = null;
        }
        if (message.isShowDetail() && (detail = fMsg.getDetail()) != null && detail.length() <= 0) {
            detail = null;
        }
        if (summary == null && detail == null) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        boolean wroteSpanId = false;
        if (summary != null && detail != null) {
            this.renderUserStyles(context, message, writer, null);
            wroteSpanId = true;
        }
        if (summary != null) {
            styleClass = theme.getStyleClass("MsgFldSumTxt");
            this.renderMessageText(context, message, writer, summary, styleClass, wroteSpanId);
        }
        if (detail != null) {
            styleClass = theme.getStyleClass("MsgFldTxt");
            if (summary != null) {
                detail = " " + detail;
            }
            this.renderMessageText(context, message, writer, detail, styleClass, wroteSpanId);
        }
        if (wroteSpanId) {
            writer.endElement("span");
        }
    }

    private void renderMessageText(FacesContext context, Message message, ResponseWriter writer, String msgText, String textStyle, boolean wroteOpeningSpanId) throws IOException {
        if (!wroteOpeningSpanId) {
            this.renderUserStyles(context, message, writer, textStyle);
        } else {
            writer.startElement("span", (UIComponent)message);
            writer.writeAttribute("class", (Object)textStyle, "class");
        }
        writer.writeText((Object)msgText, null);
        writer.endElement("span");
    }

    private void renderUserStyles(FacesContext context, Message message, ResponseWriter writer, String styleClass) throws IOException {
        String userStyle = message.getStyle();
        String id = message.getClientId(context);
        writer.startElement("span", (UIComponent)message);
        writer.writeAttribute("id", (Object)id, "id");
        if (userStyle != null && userStyle.length() > 0) {
            writer.writeAttribute("style", (Object)userStyle, "style");
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)message, styleClass);
    }
}

