/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.DropDown;
import com.sun.web.ui.component.FileChooser;
import com.sun.web.ui.component.HelpInline;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.Label;
import com.sun.web.ui.component.StaticText;
import com.sun.web.ui.component.TextField;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ClientSniffer;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;

public class FileChooserRenderer
extends AbstractRenderer {
    private static final boolean DEBUG = false;
    public static final String HYFEN = "-";

    public void decode(FacesContext context, UIComponent component) {
        if (this.isDisabled(component) || this.isReadOnly(component)) {
            return;
        }
        if (!(component instanceof FileChooser)) {
            throw new FacesException("FileChooserRenderer can only render FileChooser components.");
        }
        FileChooser chooser = (FileChooser)component;
        if (chooser.getSubmittedValue() == null) {
            this.decodeSubmittedValue(context, chooser);
        }
    }

    private void decodeSubmittedValue(FacesContext context, FileChooser chooser) {
        String selectionsId = chooser.getClientId(context) + ":" + chooser.getId() + "_selections";
        Map requestParameters = context.getExternalContext().getRequestParameterValuesMap();
        String[] selections = (String[])requestParameters.get(selectionsId);
        if (selections != null) {
            chooser.setSubmittedValue(selections);
        } else {
            chooser.setSubmittedValue(null);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (!(component instanceof FileChooser)) {
            String msg = "Can only convert values for FileChooser component.";
            throw new ConverterException(msg);
        }
        return ((FileChooser)component).getConvertedValue(context, (FileChooser)component, submittedValue);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        try {
            FileChooser chooser = null;
            if (!(component instanceof FileChooser)) {
                String message = "Component " + component.toString() + " has been associated with a FileChooser. " + " This renderer can only be used by components " + " that extend com.sun.web.ui.component.FileChooser.";
                throw new FacesException(message);
            }
            chooser = (FileChooser)component;
            if (!chooser.isRendered()) {
                return;
            }
            Theme theme = ThemeUtilities.getTheme(context);
            this.addJSFile(chooser, context, writer, theme);
            this.renderChooserTitle(context, chooser, writer, theme);
            writer.startElement("div", component);
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
            String style = chooser.getStyle();
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            RenderingUtilities.renderStyleClass(context, writer, component, theme.getStyleClass("ConMgn"));
            writer.writeText((Object)"\n", null);
            writer.startElement("table", (UIComponent)chooser);
            writer.writeAttribute("border", (Object)"0", "border");
            writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
            writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
            writer.writeAttribute("title", (Object)" ", "title");
            this.renderEmptyLine(context, chooser, writer, null, 1, 20, theme);
            this.renderServerName(context, chooser, writer, theme);
            this.renderEmptyLine(context, chooser, writer, null, 1, 20, theme);
            this.renderLookinTextField(context, chooser, writer, theme);
            this.renderEmptyLine(context, chooser, writer, "3", 1, 5, theme);
            this.renderFilterField(context, chooser, writer, theme);
            String helpMessage = theme.getMessage("filechooser.enterKeyHelp");
            this.renderInlineHelp(context, chooser, writer, helpMessage, theme);
            this.renderSortFields(context, chooser, writer, theme);
            this.renderFileList(context, chooser, writer, theme);
            this.renderButtons(context, chooser, writer, theme);
            this.renderSelectText(context, chooser, writer, theme);
            writer.endElement("table");
            writer.endElement("div");
            String hiddenID = chooser.getClientId(context) + ":" + chooser.getId() + FileChooser.FILECHOOSER_HIDDENFIELD_ID;
            writer.startElement("input", (UIComponent)chooser);
            writer.writeAttribute("id", (Object)hiddenID, null);
            writer.writeAttribute("name", (Object)hiddenID, null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("value", (Object)"NOACTION", null);
            writer.endElement("input");
            Button hiddenButton = (Button)chooser.getHiddenFCButton();
            hiddenButton.setStyleClass(theme.getStyleClass("hidden"));
            RenderingUtilities.renderComponent((UIComponent)hiddenButton, context);
            this.initializeScript(chooser, context, writer, theme);
        }
        catch (Exception e) {
            throw new FacesException("Filechooser throws exception whilerendering: " + e.getMessage());
        }
    }

    private void renderSelectedSelections(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("select", (UIComponent)chooser);
        String id = chooser.getClientId(context) + ":" + chooser.getId() + "_selections";
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("style", (Object)"{display:none}", null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.endElement("select");
    }

    private void renderRoots(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        String[] roots = chooser.getRoots();
        writer.startElement("select", (UIComponent)chooser);
        String id = chooser.getClientId(context) + ":" + chooser.getId() + "_roots";
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("style", (Object)"{display:none}", null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        for (int i = 0; i < roots.length; ++i) {
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)roots[i], null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void renderServerName(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("tr", (UIComponent)chooser);
        writer.startElement("td", (UIComponent)chooser);
        UIOutput uio = (UIOutput)chooser.getServerNameText();
        if (!uio.isRendered()) {
            return;
        }
        Label label = (Label)chooser.getServerNameLabel();
        if (!label.isRendered()) {
            return;
        }
        RenderingUtilities.renderComponent((UIComponent)label, context);
        writer.writeText((Object)"  ", null);
        RenderingUtilities.renderComponent((UIComponent)uio, context);
        writer.endElement("td");
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    protected void renderChooserTitle(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        StaticText title = (StaticText)chooser.getFileChooserTitle();
        if (!title.isRendered()) {
            return;
        }
        writer.startElement("table", (UIComponent)chooser);
        writer.writeAttribute("width", (Object)"100%", "width");
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("title", (Object)"", "title");
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeAttribute("valign", (Object)"bottom", "valign");
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("valign", (Object)"bottom", "valign");
        writer.startElement("div", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TtlTxtDiv"), "class");
        writer.startElement("span", (UIComponent)chooser);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TtlTxt"), "class");
        RenderingUtilities.renderComponent((UIComponent)title, context);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    protected void renderInlineHelp(FacesContext context, FileChooser chooser, ResponseWriter writer, String messageKey, Theme theme) throws Exception {
        writer.startElement("tr", (UIComponent)chooser);
        this.renderDotImage(writer, chooser, context, "2", 1, 1, theme);
        writer.startElement("td", (UIComponent)chooser);
        HelpInline help = (HelpInline)chooser.getEnterInlineHelp();
        if (help.isRendered()) {
            RenderingUtilities.renderComponent((UIComponent)help, context);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        this.renderEmptyLine(context, chooser, writer, "3", 1, 15, theme);
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    protected void renderLookinTextField(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        TextField lookinField = (TextField)chooser.getLookInTextField();
        if (!lookinField.isRendered()) {
            return;
        }
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("table", (UIComponent)chooser);
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("title", (Object)"", "title");
        writer.writeText((Object)"\n\t", null);
        this.renderEmptyLine(context, chooser, writer, "3", 1, 3, theme);
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)chooser);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("nowrap", (Object)"nowrap", "nowrap");
        writer.startElement("span", (UIComponent)chooser);
        RenderingUtilities.renderComponent(chooser.getLookInLabel(), context);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        this.renderDotImage(writer, chooser, context, null, 10, 1, theme);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        this.setEnterKeyPressHandler(context, chooser, (UIComponent)lookinField);
        RenderingUtilities.renderComponent((UIComponent)lookinField, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    protected void renderFilterField(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        TextField filterOnField = (TextField)chooser.getFilterTextField();
        if (!filterOnField.isRendered()) {
            return;
        }
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("nowrap", (Object)"nowrap", "nowrap");
        RenderingUtilities.renderComponent(chooser.getFilterLabel(), context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        this.renderDotImage(writer, chooser, context, null, 10, 1, theme);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        this.setEnterKeyPressHandler(context, chooser, (UIComponent)filterOnField);
        RenderingUtilities.renderComponent((UIComponent)filterOnField, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
    }

    protected void renderSortFields(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("align", (Object)"right", "align");
        writer.writeText((Object)"\n", null);
        DropDown jdd = (DropDown)chooser.getSortComponent();
        if (!jdd.isRendered()) {
            return;
        }
        RenderingUtilities.renderComponent((UIComponent)jdd, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        this.renderEmptyLine(context, chooser, writer, null, 1, 5, theme);
        writer.writeText((Object)"\n", null);
    }

    protected void renderFileList(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        UIComponent fileList = chooser.getListComponent();
        this.createJavaScriptForFileList(chooser, context, fileList);
        this.setEnterKeyPressHandler(context, chooser, fileList);
        RenderingUtilities.renderComponent(fileList, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        this.renderEmptyLine(context, chooser, writer, null, 1, 5, theme);
        writer.writeText((Object)"\n", null);
    }

    protected void renderButtons(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n\t", null);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeText((Object)"\n\t", null);
        writer.startElement("table", (UIComponent)chooser);
        writer.writeAttribute("width", (Object)"100%", "width");
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("title", (Object)" ", "title");
        writer.writeText((Object)"\n\t", null);
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n\t", null);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("valign", (Object)"top", "valign");
        HelpInline help = (HelpInline)chooser.getMultiSelectHelp();
        if (help == null) {
            writer.write("&nbsp;");
        } else if (help.isRendered()) {
            RenderingUtilities.renderComponent((UIComponent)help, context);
        }
        writer.endElement("td");
        this.renderDotImage(writer, chooser, context, null, 10, 1, theme);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("align", (Object)"right", "align");
        writer.writeAttribute("nowrap", (Object)"nowrap", "nowrap");
        this.renderUpLevelButton(context, chooser, writer, theme);
        this.renderOpenFolderButton(context, chooser, writer, theme);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
    }

    protected void renderUpLevelButton(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.writeText((Object)"\n", null);
        Button child = (Button)chooser.getUpLevelButton(false);
        if (!child.isRendered()) {
            return;
        }
        StringBuffer jsBuffer = new StringBuffer(200);
        jsBuffer.append("javascript: ");
        jsBuffer.append(chooser.getAttributes().get("com.sun.web.ui.FileChooserJS"));
        jsBuffer.append(".moveUpButtonClicked();");
        child.setOnClick(jsBuffer.toString());
        RenderingUtilities.renderComponent((UIComponent)child, context);
        writer.writeText((Object)"\n", null);
    }

    protected void renderOpenFolderButton(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        writer.writeText((Object)"\n", null);
        Button child = (Button)chooser.getOpenFolderButton();
        if (!child.isRendered()) {
            return;
        }
        StringBuffer jsBuffer = new StringBuffer(200);
        jsBuffer.append("javascript: ");
        jsBuffer.append(chooser.getAttributes().get("com.sun.web.ui.FileChooserJS"));
        jsBuffer.append(".openFolderClicked();");
        child.setOnClick(jsBuffer.toString());
        RenderingUtilities.renderComponent((UIComponent)child, context);
        writer.writeText((Object)"\n", null);
    }

    protected void renderSelectText(FacesContext context, FileChooser chooser, ResponseWriter writer, Theme theme) throws Exception {
        TextField selectedTextField = (TextField)chooser.getSelectedTextField();
        if (!selectedTextField.isRendered()) {
            return;
        }
        this.renderEmptyLine(context, chooser, writer, null, 1, 10, theme);
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("table", (UIComponent)chooser);
        writer.writeAttribute("border", (Object)"0", "border");
        writer.writeAttribute("cellspacing", (Object)"0", "cellspacing");
        writer.writeAttribute("cellpadding", (Object)"0", "cellpadding");
        writer.writeAttribute("title", (Object)" ", "title");
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)chooser);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        writer.writeAttribute("nowrap", (Object)"nowrap", "nowrap");
        RenderingUtilities.renderComponent(chooser.getSelectLabel(), context);
        writer.endElement("td");
        this.renderDotImage(writer, chooser, context, null, 10, 1, theme);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)chooser);
        this.setEnterKeyPressHandler(context, chooser, (UIComponent)selectedTextField);
        RenderingUtilities.renderComponent((UIComponent)selectedTextField, context);
        writer.endElement("td");
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("td");
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        this.renderEmptyLine(context, chooser, writer, null, 1, 30, theme);
    }

    private void addJSFile(FileChooser chooser, FacesContext context, ResponseWriter writer, Theme theme) throws IOException {
        String jsID = chooser.getClientId(context);
        String jsObject = null;
        Object jsO = chooser.getAttributes().get("com.sun.web.ui.FileChooserJS");
        if (jsO == null) {
            jsObject = jsID.replace(':', '_');
            jsObject = "FileChooser_".concat(jsObject);
            chooser.getAttributes().put("com.sun.web.ui.FileChooserJS", jsObject);
        } else {
            jsObject = jsO.toString();
        }
        String jsFile = theme.getPathToJSFile("fileChooser");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)chooser);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)jsFile, null);
        writer.endElement("script");
        writer.write("\n");
    }

    private void initializeScript(FileChooser chooser, FacesContext context, ResponseWriter writer, Theme theme) throws IOException {
        String sep;
        String chooserType = null;
        chooserType = chooser.isFolderChooser() ? "folderChooser" : (chooser.isFileAndFolderChooser() ? "fileAndFolderChooser" : "fileChooser");
        String parentDir = chooser.getParentFolder();
        String jsID = chooser.getClientId(context);
        String jsObject = null;
        Object jsO = chooser.getAttributes().get("com.sun.web.ui.FileChooserJS");
        if (jsO == null) {
            jsObject = jsID.replace(':', '_');
            jsObject = "FileChooser_".concat(jsObject);
            chooser.getAttributes().put("com.sun.web.ui.FileChooserJS", jsObject);
        } else {
            jsObject = jsO.toString();
        }
        String esc = chooser.getEscapeChar();
        if (esc.equals("\\")) {
            esc = "\\\\";
        }
        if ((sep = chooser.getModel().getSeparatorString()).equals("\\")) {
            sep = sep + sep;
            parentDir = parentDir.replaceAll(sep, sep + sep);
        }
        StringBuffer jsBuffer = new StringBuffer(200);
        jsBuffer.append("var ");
        jsBuffer.append(jsObject);
        jsBuffer.append(" = new FileChooser('");
        jsBuffer.append(jsID + ":" + chooser.getId());
        jsBuffer.append("', '");
        jsBuffer.append(chooserType);
        jsBuffer.append("','");
        jsBuffer.append(parentDir);
        jsBuffer.append("', '");
        jsBuffer.append(sep);
        jsBuffer.append("', '");
        jsBuffer.append(esc);
        jsBuffer.append("', '");
        jsBuffer.append(chooser.getDelimiterChar());
        jsBuffer.append("');\n");
        writer.writeText((Object)"\n", null);
        writer.startElement("script", (UIComponent)chooser);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)jsBuffer.toString(), null);
        writer.writeText((Object)"\n", null);
        writer.endElement("script");
        writer.write("\n");
    }

    private void createJavaScriptForFileList(FileChooser chooser, FacesContext context, UIComponent fileList) {
        StringBuffer dblClickBuffer = new StringBuffer(200);
        dblClickBuffer.append("javascript: ");
        dblClickBuffer.append(chooser.getAttributes().get("com.sun.web.ui.FileChooserJS"));
        dblClickBuffer.append(".handleDblClick();");
        fileList.getAttributes().put("onDblClick", dblClickBuffer.toString());
        String cid = fileList.getClientId(context);
        StringBuffer jsBuffer = new StringBuffer(200);
        jsBuffer.append("javascript: ");
        jsBuffer.append("listbox_changed('");
        jsBuffer.append(cid);
        jsBuffer.append("');");
        jsBuffer.append(chooser.getAttributes().get("com.sun.web.ui.FileChooserJS"));
        jsBuffer.append(".handleOnChange();");
        fileList.getAttributes().put("onChange", jsBuffer.toString());
    }

    private void setEnterKeyPressHandler(FacesContext context, FileChooser chooser, UIComponent child) {
        StringBuffer scriptBuffer = new StringBuffer();
        scriptBuffer.append("return ");
        scriptBuffer.append(chooser.getAttributes().get("com.sun.web.ui.FileChooserJS"));
        scriptBuffer.append(".enterKeyPressed(this);");
        String js = this.getReturnKeyJavascriptWrapper(scriptBuffer.toString());
        scriptBuffer.setLength(0);
        scriptBuffer.append("javascript: ");
        scriptBuffer.append(js);
        child.getAttributes().put("onKeyPress", scriptBuffer.toString());
    }

    private void setHandler(FacesContext context, FileChooser chooser, UIComponent child, String handler) {
        StringBuffer jsBuffer = new StringBuffer(200);
        jsBuffer.append("javascript: ");
        jsBuffer.append(chooser.getAttributes().get("com.sun.web.ui.FileChooserJS"));
        jsBuffer.append(".");
        jsBuffer.append(handler);
        jsBuffer.append("(this);");
        child.getAttributes().put(handler, jsBuffer.toString());
    }

    private void renderEmptyLine(FacesContext context, FileChooser chooser, ResponseWriter writer, String colSpan, int wd, int ht, Theme theme) {
        try {
            writer.startElement("tr", (UIComponent)chooser);
            this.renderDotImage(writer, chooser, context, colSpan, wd, ht, theme);
            writer.endElement("tr");
            writer.writeText((Object)"\n", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderDotImage(ResponseWriter writer, FileChooser chooser, FacesContext context, String colSpan, int wd, int ht, Theme theme) {
        try {
            writer.startElement("td", (UIComponent)chooser);
            if (colSpan != null) {
                writer.writeAttribute("colspan", (Object)colSpan, null);
            }
            Icon dot = theme.getIcon("DOT");
            dot.setWidth(wd);
            dot.setHeight(ht);
            dot.setBorder(0);
            dot.setAlt("");
            RenderingUtilities.renderComponent((UIComponent)dot, context);
            writer.endElement("td");
            writer.writeText((Object)"\n", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void log(String s) {
        if (LogUtil.fineEnabled(FileChooserRenderer.class)) {
            LogUtil.fine(FileChooserRenderer.class, s);
        }
    }

    private String getReturnKeyJavascriptWrapper(String body) {
        ClientSniffer cs = ClientSniffer.getInstance(this.getFacesContext());
        String keyCode = cs.isNav() ? "event.which" : "event.keyCode";
        StringBuffer buff = new StringBuffer(128).append("if (").append(keyCode).append("==13) {");
        if (cs.isNav6() || cs.isNav70()) {
            buff.append("event.cancelBubble = true;");
        }
        buff.append(body).append("} else { return true; }");
        return buff.toString();
    }
}

